/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.bean;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.ProvisionListener;
import java.util.ArrayList;

public abstract class BeanScheduler {
    static final Object ACTIVATOR;
    static final Object PLACEHOLDER;
    public static final Module MODULE;
    private static final ThreadLocal<Object[]> pendingHolder;

    public final void schedule(Object bean) {
        if (null != ACTIVATOR) {
            Object[] holder = BeanScheduler.getPendingHolder();
            Object pending = holder[0];
            if (pending == PLACEHOLDER) {
                holder[0] = new Pending(bean);
                return;
            }
            if (pending instanceof Pending) {
                ((Pending)pending).add(bean);
                return;
            }
        }
        this.activate(bean);
    }

    protected abstract void activate(Object var1);

    static Object[] getPendingHolder() {
        Object[] holder = pendingHolder.get();
        if (null == holder) {
            holder = new Object[1];
            pendingHolder.set(holder);
        }
        return holder;
    }

    static {
        Activator activator;
        try {
            Binder.class.getMethod("bindListener", Matcher.class, ProvisionListener[].class);
            activator = new Activator();
        }
        catch (Exception e) {
            activator = null;
        }
        catch (LinkageError e) {
            activator = null;
        }
        ACTIVATOR = activator;
        PLACEHOLDER = new Object();
        MODULE = new Module(){

            public void configure(Binder binder) {
                if (null != ACTIVATOR) {
                    binder.bindListener(Matchers.any(), new ProvisionListener[]{(ProvisionListener)ACTIVATOR});
                }
            }
        };
        pendingHolder = new ThreadLocal();
    }

    static final class Activator
    implements ProvisionListener {
        Activator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> pi) {
            Object[] holder = BeanScheduler.getPendingHolder();
            if (null == holder[0]) {
                Object pending;
                holder[0] = PLACEHOLDER;
                try {
                    pi.provision();
                }
                finally {
                    pending = holder[0];
                    holder[0] = null;
                }
                if (pending instanceof Pending) {
                    ((Pending)pending).activate();
                }
            }
        }
    }

    private final class Pending
    extends ArrayList<Object> {
        Pending(Object bean) {
            this.add(bean);
        }

        public void activate() {
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                BeanScheduler.this.activate(this.get(i));
            }
        }
    }
}

