/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.osgi;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.eclipse.sisu.inject.BindingPublisher;
import org.eclipse.sisu.inject.BindingSubscriber;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.osgi.BindingTracker;
import org.osgi.framework.BundleContext;

public final class ServiceBindings
implements BindingPublisher {
    private static final Pattern GLOB_SYNTAX = Pattern.compile("(?:\\w+|\\*)(?:\\.?(?:\\w+|\\*))*");
    private final ConcurrentMap<String, BindingTracker<?>> trackers = new ConcurrentHashMap();
    private final BundleContext context;
    private final Pattern[] allowed;
    private final Pattern[] ignored;
    private final int maxRank;

    public ServiceBindings(BundleContext context, String allow, String ignore, int maxRank) {
        this.context = context;
        this.maxRank = maxRank;
        this.allowed = ServiceBindings.parseGlobs(allow);
        this.ignored = ServiceBindings.parseGlobs(ignore);
    }

    public ServiceBindings(BundleContext context) {
        this(context, ServiceBindings.defaultAllow(), ServiceBindings.defaultIgnore(), Integer.MIN_VALUE);
    }

    public static String defaultAllow() {
        return System.getProperty(ServiceBindings.class.getName() + ".allow", "");
    }

    public static String defaultIgnore() {
        return System.getProperty(ServiceBindings.class.getName() + ".ignore", "");
    }

    @Override
    public <T> void subscribe(BindingSubscriber<T> subscriber) {
        String clazzName = subscriber.type().getRawType().getName();
        if (this.shouldTrack(clazzName)) {
            BindingTracker oldTracker;
            BindingTracker<T> tracker = (BindingTracker<T>)((Object)this.trackers.get(clazzName));
            if (null == tracker && null != (oldTracker = this.trackers.putIfAbsent(clazzName, tracker = new BindingTracker<T>(this.context, this.maxRank, clazzName)))) {
                tracker = oldTracker;
            }
            tracker.subscribe(subscriber);
        }
    }

    @Override
    public <T> void unsubscribe(BindingSubscriber<T> subscriber) {
        String clazzName = subscriber.type().getRawType().getName();
        BindingTracker tracker = (BindingTracker)((Object)this.trackers.get(clazzName));
        if (null != tracker) {
            tracker.unsubscribe(subscriber);
        }
    }

    @Override
    public int maxBindingRank() {
        return this.maxRank;
    }

    private boolean shouldTrack(String clazzName) {
        for (Pattern allow : this.allowed) {
            if (!allow.matcher(clazzName).matches()) continue;
            for (Pattern ignore : this.ignored) {
                if (!ignore.matcher(clazzName).matches()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static Pattern[] parseGlobs(String globs) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String glob : globs.split("\\s*,\\s*")) {
            if (GLOB_SYNTAX.matcher(glob).matches()) {
                patterns.add(Pattern.compile(glob.replace(".", "\\.").replace("*", ".*")));
                continue;
            }
            if (glob.length() <= 0) continue;
            Logs.warn("Ignoring malformed glob pattern: {}", glob, null);
        }
        return patterns.toArray(new Pattern[patterns.size()]);
    }
}

