/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.reflect;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class MildKeys<K, V>
implements Map<K, V> {
    private final ReferenceQueue<K> queue = new ReferenceQueue();
    private final Map<Reference<K>, V> map;
    private final boolean soft;

    MildKeys(Map<Reference<K>, V> map, boolean soft) {
        this.map = map;
        this.soft = soft;
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.map.containsKey(MildKeys.tempKey(key));
    }

    @Override
    public final boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public final V get(Object key) {
        return this.map.get(MildKeys.tempKey(key));
    }

    @Override
    public final V put(K key, V value) {
        this.compact();
        return this.map.put(this.mildKey(key), value);
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> m) {
        this.compact();
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.map.put(this.mildKey(e.getKey()), e.getValue());
        }
    }

    @Override
    public final V remove(Object key) {
        this.compact();
        return this.map.remove(MildKeys.tempKey(key));
    }

    @Override
    public final void clear() {
        this.map.clear();
        this.compact();
    }

    @Override
    public final boolean isEmpty() {
        this.compact();
        return this.map.isEmpty();
    }

    @Override
    public final int size() {
        this.compact();
        return this.map.size();
    }

    @Override
    public final Set<K> keySet() {
        this.compact();
        HashSet<K> keys = new HashSet<K>();
        for (Reference<K> r : this.map.keySet()) {
            K key = r.get();
            if (null == key) continue;
            keys.add(key);
        }
        return keys;
    }

    @Override
    public final Collection<V> values() {
        this.compact();
        return this.map.values();
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        this.compact();
        HashMap<K, V> entries = new HashMap<K, V>();
        for (Map.Entry<Reference<K>, V> e : this.map.entrySet()) {
            K key = e.getKey().get();
            if (null == key) continue;
            entries.put(key, e.getValue());
        }
        return entries.entrySet();
    }

    final Reference<K> mildKey(K key) {
        return this.soft ? new Soft<K>(key, this.queue) : new Weak<K>(key, this.queue);
    }

    static final Reference<?> tempKey(Object key) {
        return new Weak<Object>(key, (ReferenceQueue<Object>)null);
    }

    final void compact() {
        Reference<K> ref;
        while ((ref = this.queue.poll()) != null) {
            this.map.remove(ref);
        }
    }

    static class Weak<T>
    extends WeakReference<T> {
        private final int hash;

        Weak(T o, ReferenceQueue<T> queue) {
            super(o, queue);
            this.hash = o.hashCode();
        }

        public final int hashCode() {
            return this.hash;
        }

        public final boolean equals(Object rhs) {
            if (this == rhs) {
                return true;
            }
            Object o = this.get();
            if (null != o && rhs instanceof Reference) {
                return o == ((Reference)rhs).get();
            }
            return false;
        }
    }

    static class Soft<T>
    extends SoftReference<T> {
        private final int hash;

        Soft(T o, ReferenceQueue<T> queue) {
            super(o, queue);
            this.hash = o.hashCode();
        }

        public final int hashCode() {
            return this.hash;
        }

        public final boolean equals(Object rhs) {
            if (this == rhs) {
                return true;
            }
            Object o = this.get();
            if (null != o && rhs instanceof Reference) {
                return o == ((Reference)rhs).get();
            }
            return false;
        }
    }
}

