/*
 * Decompiled with CFR 0.152.
 */
package dom.traversal;

import dom.traversal.NameNodeFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import ui.DOMTreeFull;

public class IteratorView
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 3256726186452662580L;
    Document document;
    TreeNode lastSelected;
    DOMParser parser;
    JTextArea messageText;
    JScrollPane messageScroll;
    DOMTreeFull jtree;
    NodeIterator iterator;
    NameNodeFilter nameNodeFilter;
    JButton nextButton;
    JButton prevButton;
    JButton removeButton;
    JButton addButton;
    JTextField addText;
    JButton newIterator;
    JList whatToShow;
    JCheckBox match;
    JTextField nameFilter;
    String[] whatArray = new String[]{"ALL", "ELEMENT", "ATTRIBUTE", "TEXT", "CDATA_SECTION", "ENTITY_REFERENCE", "ENTITY", "PROCESSING_INSTRUCTION", "COMMENT", "DOCUMENT", "DOCUMENT_TYPE", "DOCUMENT_FRAGMENT", "NOTATION"};
    JCheckBox expandERs;
    Hashtable treeNodeMap = new Hashtable();

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            String string = stringArray[0];
            try {
                IteratorView iteratorView = new IteratorView(string);
                iteratorView.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        System.exit(0);
                    }
                });
                iteratorView.setSize(640, 480);
                iteratorView.setVisible(true);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    public IteratorView(String string) {
        super("IteratorView: " + string);
        try {
            this.parser = new DOMParser();
            this.parser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", true);
            this.parser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
            Errors errors = new Errors();
            this.parser.setErrorHandler((ErrorHandler)errors);
            this.parser.parse(string);
            this.document = this.parser.getDocument();
            if (!this.document.isSupported("Traversal", "2.0")) {
                throw new RuntimeException("This DOM Document does not support Traversal");
            }
            this.jtree = new DOMTreeFull(this.document);
            this.jtree.getSelectionModel().setSelectionMode(1);
            this.jtree.setRootVisible(false);
            this.jtree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    TreePath treePath = treeSelectionEvent.getPath();
                    TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
                    if (IteratorView.this.jtree.getSelectionModel().isPathSelected(treePath)) {
                        IteratorView.this.nodeSelected(treeNode);
                    }
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Iterate"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            this.prevButton = new JButton("Previous");
            jPanel.add(this.prevButton);
            this.prevButton.addActionListener(this);
            this.nextButton = new JButton("Next");
            jPanel.add(this.nextButton);
            this.nextButton.addActionListener(this);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Selected Node"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            this.removeButton = new JButton("Remove Selected Node");
            jPanel2.add((Component)this.removeButton, "North");
            this.removeButton.addActionListener(this);
            this.addButton = new JButton("Add Text Node");
            this.addText = new JTextField(10);
            jPanel2.add((Component)this.addButton, "Center");
            jPanel2.add((Component)this.addText, "South");
            this.addButton.addActionListener(this);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BorderLayout());
            jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Iterator Settings"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            JPanel jPanel4 = new JPanel();
            this.newIterator = new JButton("createNodeIterator");
            this.expandERs = new JCheckBox("expandEntityReferences");
            jPanel4.add(this.newIterator);
            this.expandERs.setSelected(true);
            jPanel4.add(this.expandERs);
            jPanel3.add((Component)jPanel4, "North");
            this.newIterator.addActionListener(this);
            JPanel jPanel5 = new JPanel();
            jPanel5.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("whatToShow"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            this.whatToShow = new JList<String>(DOMTreeFull.whatArray);
            JScrollPane jScrollPane = new JScrollPane(this.whatToShow){
                private static final long serialVersionUID = 3546357344813724213L;

                public Dimension getPreferredSize() {
                    return new Dimension(200, 75);
                }
            };
            jPanel5.add(jScrollPane);
            JPanel jPanel6 = new JPanel();
            jPanel6.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("NodeNameFilter"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            jPanel6.setLayout(new BorderLayout());
            this.match = new JCheckBox("match/ignore node name", true);
            this.nameFilter = new JTextField(10);
            jPanel6.add((Component)this.match, "North");
            jPanel6.add((Component)this.nameFilter, "South");
            jPanel3.add((Component)jPanel5, "West");
            jPanel3.add((Component)jPanel6, "East");
            this.whatToShow.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                }
            });
            JPanel jPanel7 = new JPanel(new BorderLayout());
            JPanel jPanel8 = new JPanel(new BorderLayout());
            jPanel8.add((Component)jPanel, "North");
            jPanel8.add((Component)jPanel2, "South");
            jPanel7.add((Component)jPanel8, "West");
            jPanel7.add((Component)jPanel3, "Center");
            jPanel7.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Controls"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            JPanel jPanel9 = new JPanel(new BorderLayout());
            JScrollPane jScrollPane2 = new JScrollPane(this.jtree);
            jScrollPane2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Tree View"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            this.messageText = new JTextArea(3, 5);
            JPanel jPanel10 = new JPanel(new BorderLayout());
            this.messageScroll = new JScrollPane(this.messageText);
            jPanel10.add(this.messageScroll);
            jPanel10.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Messages"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            JPanel jPanel11 = new JPanel();
            jPanel11.setLayout(new BorderLayout());
            jPanel11.add((Component)jPanel7, "North");
            jPanel11.add((Component)jScrollPane2, "Center");
            jPanel11.add((Component)jPanel10, "South");
            this.getContentPane().add(jPanel11);
            Hashtable hashtable = errors.getErrorNodes();
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                this.messageText.append((String)enumeration.nextElement());
            }
            this.iterator = ((DocumentTraversal)((Object)this.document)).createNodeIterator(this.document, -1, new NameNodeFilter(), true);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.newIterator) {
            Document document = this.document;
            int[] nArray = this.whatToShow.getSelectedIndices();
            int n = 0;
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == 0) {
                    n = 65535;
                    break;
                }
                n |= 1 << nArray[i] - 1;
            }
            String string = this.nameFilter.getText();
            boolean bl = this.match.isSelected();
            if (this.nameNodeFilter == null) {
                this.nameNodeFilter = new NameNodeFilter();
            }
            if (string.length() == 0) {
                this.setMessage("NodeNameFilter name is \"\". Assuming null.");
                string = null;
            }
            this.nameNodeFilter.setName(string);
            this.nameNodeFilter.setMatch(bl);
            if (this.iterator != null) {
                this.iterator.detach();
            }
            boolean bl2 = this.expandERs.isSelected();
            this.iterator = ((DocumentTraversal)((Object)this.document)).createNodeIterator(document, (short)n, this.nameNodeFilter, bl2);
            this.setMessage("doc.createNodeIterator( root=" + document + ", whatToShow=" + n + ", match=" + bl + ", name=" + string + ")");
            return;
        }
        if (actionEvent.getSource() == this.addButton) {
            String string = this.addText.getText();
            if (string == null) {
                return;
            }
            TreeNode treeNode = (TreeNode)this.jtree.getLastSelectedPathComponent();
            if (treeNode == null) {
                this.messageText.append("Must select a tree component to add a child to it.");
                return;
            }
            TreePath treePath = new TreePath(((DefaultTreeModel)this.jtree.getModel()).getPathToRoot(treeNode));
            if (treePath == null) {
                this.setMessage("Could not create a path.");
                return;
            }
            if (!this.jtree.getSelectionModel().isPathSelected(treePath)) {
                return;
            }
            Node node = this.jtree.getNode(treeNode);
            Text text = this.document.createTextNode(string);
            try {
                node.appendChild(text);
            }
            catch (DOMException dOMException) {
                this.setMessage("DOMException:" + dOMException.code + ", " + dOMException);
                return;
            }
            ((DOMTreeFull.Model)this.jtree.getModel()).insertNode(text, (MutableTreeNode)treeNode);
            return;
        }
        if (actionEvent.getSource() == this.nextButton) {
            Node node = this.iterator.nextNode();
            if (node == null) {
                this.setMessage("iterator.nextNode() == null");
                return;
            }
            this.setMessage("iterator.nextNode() == " + node);
            TreeNode treeNode = this.jtree.getTreeNode(node);
            if (treeNode == null) {
                this.setMessage("No JTree TreeNode for Node name:" + node.getNodeName());
                return;
            }
            TreePath treePath = new TreePath(((DefaultTreeModel)this.jtree.getModel()).getPathToRoot(treeNode));
            this.jtree.requestFocus();
            this.jtree.setSelectionPath(treePath);
            this.jtree.scrollPathToVisible(treePath);
            return;
        }
        if (actionEvent.getSource() == this.prevButton) {
            Node node = this.iterator.previousNode();
            if (node == null) {
                this.setMessage("iterator.previousNode() == null");
                return;
            }
            this.setMessage("iterator.previousNode() == " + node);
            TreeNode treeNode = this.jtree.getTreeNode(node);
            if (treeNode == null) {
                this.setMessage("No JTree TreeNode for Node name:" + node.getNodeName());
                return;
            }
            TreePath treePath = new TreePath(((DefaultTreeModel)this.jtree.getModel()).getPathToRoot(treeNode));
            this.jtree.requestFocus();
            this.jtree.setSelectionPath(treePath);
            this.jtree.scrollPathToVisible(treePath);
            return;
        }
        if (actionEvent.getSource() == this.removeButton) {
            TreeNode treeNode = (TreeNode)this.jtree.getLastSelectedPathComponent();
            if (treeNode == null) {
                this.messageText.append("Must select a tree component to remove it.");
                return;
            }
            TreePath treePath = new TreePath(((DefaultTreeModel)this.jtree.getModel()).getPathToRoot(treeNode));
            if (treePath == null) {
                this.setMessage("Could not create a path.");
                return;
            }
            if (!this.jtree.getSelectionModel().isPathSelected(treePath)) {
                return;
            }
            Node node = this.jtree.getNode(treeNode);
            if (node == null) {
                return;
            }
            Node node2 = node.getParentNode();
            if (node2 == null) {
                return;
            }
            node2.removeChild(node);
            ((DefaultTreeModel)this.jtree.getModel()).removeNodeFromParent((MutableTreeNode)treeNode);
            return;
        }
    }

    void setMessage(String string) {
        this.messageText.selectAll();
        this.messageText.cut();
        this.messageText.append(string);
        this.messageText.setCaretPosition(0);
    }

    void nodeSelected(TreeNode treeNode) {
        this.lastSelected = treeNode;
        Node node = this.jtree.getNode(treeNode);
        System.out.println("nodeSelected.node=" + node);
        if (node == null) {
            return;
        }
        this.setMessage(DOMTreeFull.toString(node));
    }

    void expandTree() {
        for (int i = 0; i < this.jtree.getRowCount(); ++i) {
            this.jtree.expandRow(i);
        }
    }

    class Errors
    implements ErrorHandler {
        Hashtable errorNodes = new Hashtable();

        Errors() {
        }

        public void warning(SAXParseException sAXParseException) {
            this.store(sAXParseException, "[Warning]");
        }

        public void error(SAXParseException sAXParseException) {
            this.store(sAXParseException, "[Error]");
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.store(sAXParseException, "[Fatal Error]");
        }

        public Hashtable getErrorNodes() {
            return this.errorNodes;
        }

        public Object getError(Node node) {
            return this.errorNodes.get(node);
        }

        public void clearErrors() {
            this.errorNodes.clear();
        }

        void store(SAXParseException sAXParseException, String string) {
            String string2 = string + " at line number, " + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage() + "\n";
            Node node = null;
            try {
                node = (Node)IteratorView.this.parser.getProperty("http://apache.org/xml/properties/dom-node");
            }
            catch (SAXException sAXException) {
                System.err.println(sAXException.getMessage());
                return;
            }
            if (node == null) {
                return;
            }
            String string3 = (String)this.errorNodes.get(node);
            if (string3 != null) {
                this.errorNodes.put(node, string3 + string2);
            } else {
                this.errorNodes.put(node, string2);
            }
        }
    }
}

