/*
 * Decompiled with CFR 0.152.
 */
package jaxp;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class InlineSchemaValidator
implements ErrorHandler,
NamespaceContext {
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String HONOUR_ALL_SCHEMA_LOCATIONS_ID = "http://apache.org/xml/features/honour-all-schemaLocations";
    protected static final String VALIDATE_ANNOTATIONS_ID = "http://apache.org/xml/features/validate-annotations";
    protected static final String GENERATE_SYNTHETIC_ANNOTATIONS_ID = "http://apache.org/xml/features/generate-synthetic-annotations";
    protected static final String DEFAULT_SCHEMA_LANGUAGE = "http://www.w3.org/2001/XMLSchema";
    protected static final int DEFAULT_REPETITION = 1;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_HONOUR_ALL_SCHEMA_LOCATIONS = false;
    protected static final boolean DEFAULT_VALIDATE_ANNOTATIONS = false;
    protected static final boolean DEFAULT_GENERATE_SYNTHETIC_ANNOTATIONS = false;
    protected static final boolean DEFAULT_MEMORY_USAGE = false;
    protected PrintWriter fOut = new PrintWriter(System.out);
    protected HashMap fPrefixToURIMappings;
    protected HashMap fURIToPrefixMappings;

    public InlineSchemaValidator(HashMap hashMap, HashMap hashMap2) {
        this.fPrefixToURIMappings = hashMap;
        this.fURIToPrefixMappings = hashMap2;
    }

    public void validate(Validator validator, Source source, String string, int n, boolean bl) {
        try {
            long l = System.currentTimeMillis();
            long l2 = Runtime.getRuntime().freeMemory();
            for (int i = 0; i < n; ++i) {
                validator.validate(source);
            }
            long l3 = Runtime.getRuntime().freeMemory();
            long l4 = System.currentTimeMillis();
            long l5 = l4 - l;
            long l6 = bl ? l2 - l3 : Long.MIN_VALUE;
            this.printResults(this.fOut, string, l5, l6, n);
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (Exception exception) {
            System.err.println("error: Parse error occurred - " + exception.getMessage());
            Exception exception2 = exception;
            if (exception instanceof SAXException) {
                exception2 = ((SAXException)exception).getException();
            }
            if (exception2 != null) {
                exception2.printStackTrace(System.err);
            }
            exception.printStackTrace(System.err);
        }
    }

    public void printResults(PrintWriter printWriter, String string, long l, long l2, int n) {
        printWriter.print(string);
        printWriter.print(": ");
        if (n == 1) {
            printWriter.print(l);
        } else {
            printWriter.print(l);
            printWriter.print('/');
            printWriter.print(n);
            printWriter.print('=');
            printWriter.print((float)l / (float)n);
        }
        printWriter.print(" ms");
        if (l2 != Long.MIN_VALUE) {
            printWriter.print(", ");
            printWriter.print(l2);
            printWriter.print(" bytes");
        }
        printWriter.println();
        printWriter.flush();
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.printError("Warning", sAXParseException);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.printError("Error", sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.printError("Fatal Error", sAXParseException);
        throw sAXParseException;
    }

    public String getNamespaceURI(String string) {
        String string2;
        if (string == null) {
            throw new IllegalArgumentException("Prefix cannot be null.");
        }
        if ("xml".equals(string)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(string)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if (this.fPrefixToURIMappings != null && (string2 = (String)this.fPrefixToURIMappings.get(string)) != null) {
            return string2;
        }
        return "";
    }

    public String getPrefix(String string) {
        HashSet hashSet;
        if (string == null) {
            throw new IllegalArgumentException("Namespace URI cannot be null.");
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(string)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(string)) {
            return "xmlns";
        }
        if (this.fURIToPrefixMappings != null && (hashSet = (HashSet)this.fURIToPrefixMappings.get(string)) != null && hashSet.size() > 0) {
            return (String)hashSet.iterator().next();
        }
        return null;
    }

    public Iterator getPrefixes(String string) {
        HashSet hashSet;
        if (string == null) {
            throw new IllegalArgumentException("Namespace URI cannot be null.");
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(string)) {
            return new Iterator(){
                boolean more = true;

                public boolean hasNext() {
                    return this.more;
                }

                public Object next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.more = false;
                    return "xml";
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        if ("http://www.w3.org/2000/xmlns/".equals(string)) {
            return new Iterator(){
                boolean more = true;

                public boolean hasNext() {
                    return this.more;
                }

                public Object next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.more = false;
                    return "xmlns";
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        if (this.fURIToPrefixMappings != null && (hashSet = (HashSet)this.fURIToPrefixMappings.get(string)) != null && hashSet.size() > 0) {
            return hashSet.iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    protected void printError(String string, SAXParseException sAXParseException) {
        System.err.print("[");
        System.err.print(string);
        System.err.print("] ");
        String string2 = sAXParseException.getSystemId();
        if (string2 != null) {
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.err.print(string2);
        }
        System.err.print(':');
        System.err.print(sAXParseException.getLineNumber());
        System.err.print(':');
        System.err.print(sAXParseException.getColumnNumber());
        System.err.print(": ");
        System.err.print(sAXParseException.getMessage());
        System.err.println();
        System.err.flush();
    }

    public static void main(String[] stringArray) {
        HashSet<Object> hashSet;
        Object object;
        Object object2;
        Object object3;
        if (stringArray.length == 0) {
            InlineSchemaValidator.printUsage();
            System.exit(1);
        }
        Vector<Object> vector = null;
        Vector<Object> vector2 = null;
        HashMap<Object, String> hashMap = null;
        HashMap<String, HashSet<Object>> hashMap2 = null;
        String string = stringArray[stringArray.length - 1];
        String string2 = DEFAULT_SCHEMA_LANGUAGE;
        int n = 1;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        for (int i = 0; i < stringArray.length - 1; ++i) {
            object3 = stringArray[i];
            if (!((String)object3).startsWith("-")) continue;
            object2 = ((String)object3).substring(1);
            if (((String)object2).equals("l")) {
                if (++i == stringArray.length) {
                    System.err.println("error: Missing argument to -l option.");
                    continue;
                }
                string2 = stringArray[i];
                continue;
            }
            if (((String)object2).equals("x")) {
                if (++i == stringArray.length) {
                    System.err.println("error: Missing argument to -x option.");
                    continue;
                }
                object = stringArray[i];
                try {
                    int n2 = Integer.parseInt((String)object);
                    if (n2 < 1) {
                        System.err.println("error: Repetition must be at least 1.");
                        continue;
                    }
                    n = n2;
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("error: invalid number (" + (String)object + ").");
                }
                continue;
            }
            if (((String)object3).equals("-a")) {
                if (vector == null) {
                    vector = new Vector<Object>();
                }
                while (i + 1 < stringArray.length - 1 && !((String)(object3 = stringArray[i + 1])).startsWith("-")) {
                    vector.add(object3);
                    ++i;
                }
                continue;
            }
            if (((String)object3).equals("-i")) {
                if (vector2 == null) {
                    vector2 = new Vector<Object>();
                }
                while (i + 1 < stringArray.length - 1 && !((String)(object3 = stringArray[i + 1])).startsWith("-")) {
                    vector2.add(object3);
                    ++i;
                }
                continue;
            }
            if (((String)object3).equals("-nm")) {
                String string3;
                while (i + 2 < stringArray.length - 1 && !((String)(object = stringArray[i + 1])).startsWith("-") && !(string3 = stringArray[i + 2]).startsWith("-")) {
                    if (hashMap == null) {
                        hashMap = new HashMap<Object, String>();
                        hashMap2 = new HashMap<String, HashSet<Object>>();
                    }
                    hashMap.put(object, string3);
                    hashSet = (HashSet)hashMap2.get(string3);
                    if (hashSet == null) {
                        hashSet = new HashSet<Object>();
                        hashMap2.put(string3, hashSet);
                    }
                    hashSet.add(object);
                    i += 2;
                }
                continue;
            }
            if (((String)object2).equalsIgnoreCase("f")) {
                bl = ((String)object2).equals("f");
                continue;
            }
            if (((String)object2).equalsIgnoreCase("hs")) {
                bl2 = ((String)object2).equals("hs");
                continue;
            }
            if (((String)object2).equalsIgnoreCase("va")) {
                bl3 = ((String)object2).equals("va");
                continue;
            }
            if (((String)object2).equalsIgnoreCase("ga")) {
                bl4 = ((String)object2).equals("ga");
                continue;
            }
            if (((String)object2).equalsIgnoreCase("m")) {
                bl5 = ((String)object2).equals("m");
                continue;
            }
            if (((String)object2).equals("h")) {
                InlineSchemaValidator.printUsage();
                continue;
            }
            System.err.println("error: unknown option (" + (String)object2 + ").");
        }
        try {
            int n3;
            int n4;
            Object object4;
            InlineSchemaValidator inlineSchemaValidator = new InlineSchemaValidator(hashMap, hashMap2);
            object3 = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object3).setNamespaceAware(true);
            object2 = ((DocumentBuilderFactory)object3).newDocumentBuilder();
            ((DocumentBuilder)object2).setErrorHandler(inlineSchemaValidator);
            object = ((DocumentBuilder)object2).parse(string);
            XPathFactory xPathFactory = XPathFactory.newInstance();
            hashSet = xPathFactory.newXPath();
            hashSet.setNamespaceContext(inlineSchemaValidator);
            NodeList[] nodeListArray = new NodeList[vector != null ? vector.size() : 0];
            for (int i = 0; i < nodeListArray.length; ++i) {
                XPathExpression xPathExpression = hashSet.compile((String)vector.elementAt(i));
                nodeListArray[i] = (NodeList)xPathExpression.evaluate(object, XPathConstants.NODESET);
            }
            NodeList[] nodeListArray2 = new NodeList[vector2 != null ? vector2.size() : 0];
            for (int i = 0; i < nodeListArray2.length; ++i) {
                object4 = hashSet.compile((String)vector2.elementAt(i));
                nodeListArray2[i] = (NodeList)object4.evaluate(object, XPathConstants.NODESET);
            }
            SchemaFactory schemaFactory = SchemaFactory.newInstance(string2);
            schemaFactory.setErrorHandler(inlineSchemaValidator);
            try {
                schemaFactory.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, bl);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: SchemaFactory does not recognize feature (http://apache.org/xml/features/validation/schema-full-checking)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: SchemaFactory does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
            }
            try {
                schemaFactory.setFeature(HONOUR_ALL_SCHEMA_LOCATIONS_ID, bl2);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: SchemaFactory does not recognize feature (http://apache.org/xml/features/honour-all-schemaLocations)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: SchemaFactory does not support feature (http://apache.org/xml/features/honour-all-schemaLocations)");
            }
            try {
                schemaFactory.setFeature(VALIDATE_ANNOTATIONS_ID, bl3);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: SchemaFactory does not recognize feature (http://apache.org/xml/features/validate-annotations)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: SchemaFactory does not support feature (http://apache.org/xml/features/validate-annotations)");
            }
            try {
                schemaFactory.setFeature(GENERATE_SYNTHETIC_ANNOTATIONS_ID, bl4);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: SchemaFactory does not recognize feature (http://apache.org/xml/features/generate-synthetic-annotations)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: SchemaFactory does not support feature (http://apache.org/xml/features/generate-synthetic-annotations)");
            }
            int n5 = 0;
            for (n4 = 0; n4 < nodeListArray.length; ++n4) {
                n5 += nodeListArray[n4].getLength();
            }
            Object object5 = new DOMSource[n5];
            if (n5 == 0) {
                object4 = schemaFactory.newSchema();
            } else {
                n4 = 0;
                for (n3 = 0; n3 < nodeListArray.length; ++n3) {
                    NodeList nodeList = nodeListArray[n3];
                    int n6 = nodeList.getLength();
                    for (int i = 0; i < n6; ++i) {
                        object5[n4++] = new DOMSource(nodeList.item(i));
                    }
                }
                object4 = schemaFactory.newSchema((Source[])object5);
            }
            object5 = ((Schema)object4).newValidator();
            ((Validator)object5).setErrorHandler(inlineSchemaValidator);
            try {
                ((Validator)object5).setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, bl);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Validator does not recognize feature (http://apache.org/xml/features/validation/schema-full-checking)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Validator does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
            }
            try {
                ((Validator)object5).setFeature(HONOUR_ALL_SCHEMA_LOCATIONS_ID, bl2);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Validator does not recognize feature (http://apache.org/xml/features/honour-all-schemaLocations)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Validator does not support feature (http://apache.org/xml/features/honour-all-schemaLocations)");
            }
            try {
                ((Validator)object5).setFeature(VALIDATE_ANNOTATIONS_ID, bl3);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Validator does not recognize feature (http://apache.org/xml/features/validate-annotations)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Validator does not support feature (http://apache.org/xml/features/validate-annotations)");
            }
            try {
                ((Validator)object5).setFeature(GENERATE_SYNTHETIC_ANNOTATIONS_ID, bl4);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Validator does not recognize feature (http://apache.org/xml/features/generate-synthetic-annotations)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Validator does not support feature (http://apache.org/xml/features/generate-synthetic-annotations)");
            }
            for (int i = 0; i < nodeListArray2.length; ++i) {
                NodeList nodeList = nodeListArray2[i];
                n3 = nodeList.getLength();
                for (int j = 0; j < n3; ++j) {
                    DOMSource dOMSource = new DOMSource(nodeList.item(j));
                    dOMSource.setSystemId(string);
                    inlineSchemaValidator.validate((Validator)object5, dOMSource, string, n, bl5);
                }
            }
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (Exception exception) {
            Object object6;
            System.err.println("error: Parse error occurred - " + exception.getMessage());
            if (exception instanceof SAXException && (object3 = ((SAXException)exception).getException()) != null) {
                object6 = object3;
            }
            ((Throwable)object6).printStackTrace(System.err);
        }
    }

    private static void printUsage() {
        System.err.println("usage: java jaxp.InlineSchemaValidator (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -l name          Select schema language by name.");
        System.err.println("  -x number        Select number of repetitions.");
        System.err.println("  -a xpath    ...  Provide a list of XPath expressions for schema roots");
        System.err.println("  -i xpath    ...  Provide a list of XPath expressions for validation roots");
        System.err.println("  -nm pre uri ...  Provide a list of prefix to namespace URI mappings for the XPath expressions.");
        System.err.println("  -f  | -F         Turn on/off Schema full checking.");
        System.err.println("                   NOTE: Not supported by all schema factories and validators.");
        System.err.println("  -hs | -HS        Turn on/off honouring of all schema locations.");
        System.err.println("                   NOTE: Not supported by all schema factories and validators.");
        System.err.println("  -va | -VA        Turn on/off validation of schema annotations.");
        System.err.println("                   NOTE: Not supported by all schema factories and validators.");
        System.err.println("  -ga | -GA        Turn on/off generation of synthetic schema annotations.");
        System.err.println("                   NOTE: Not supported by all schema factories and validators.");
        System.err.println("  -m  | -M         Turn on/off memory usage report");
        System.err.println("  -h               This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Schema language:                 http://www.w3.org/2001/XMLSchema");
        System.err.println("  Repetition:                      1");
        System.err.print("  Schema full checking:            ");
        System.err.println("off");
        System.err.print("  Honour all schema locations:     ");
        System.err.println("off");
        System.err.print("  Validate annotations:            ");
        System.err.println("off");
        System.err.print("  Generate synthetic annotations:  ");
        System.err.println("off");
        System.err.print("  Memory:                          ");
        System.err.println("off");
        System.err.println();
        System.err.println("notes:");
        System.err.println("  The speed and memory results from this program should NOT be used as the");
        System.err.println("  basis of parser performance comparison! Real analytical methods should be");
        System.err.println("  used. For better results, perform multiple document validations within the");
        System.err.println("  same virtual machine to remove class loading from parse time and memory usage.");
    }
}

