/*
 * Decompiled with CFR 0.152.
 */
package socket;

import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Random;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.ParserAdapter;
import org.xml.sax.helpers.ParserFactory;
import org.xml.sax.helpers.XMLReaderFactory;

public class DelayedInput
extends DefaultHandler {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected PrintWriter fOut;

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        System.out.println("(" + string3);
        int n = attributes != null ? attributes.getLength() : 0;
        for (int i = 0; i < n; ++i) {
            System.out.println("A" + attributes.getQName(i) + ' ' + attributes.getValue(i));
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        System.out.println(")" + string3);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.printError("Warning", sAXParseException);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.printError("Error", sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.printError("Fatal Error", sAXParseException);
        throw sAXParseException;
    }

    protected void printError(String string, SAXParseException sAXParseException) {
        System.err.print("[");
        System.err.print(string);
        System.err.print("] ");
        String string2 = sAXParseException.getSystemId();
        if (string2 != null) {
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.err.print(string2);
        }
        System.err.print(':');
        System.err.print(sAXParseException.getLineNumber());
        System.err.print(':');
        System.err.print(sAXParseException.getColumnNumber());
        System.err.print(": ");
        System.err.print(sAXParseException.getMessage());
        System.err.println();
        System.err.flush();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            DelayedInput.printUsage();
            System.exit(1);
        }
        DelayedInput delayedInput = new DelayedInput();
        XMLReader xMLReader = null;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            Object object2;
            String string = stringArray[i];
            if (string.startsWith("-")) {
                object2 = string.substring(1);
                if (((String)object2).equals("p")) {
                    if (++i == stringArray.length) {
                        System.err.println("error: Missing argument to -p option.");
                    }
                    object = stringArray[i];
                    try {
                        xMLReader = XMLReaderFactory.createXMLReader((String)object);
                    }
                    catch (Exception exception) {
                        try {
                            Parser parser = ParserFactory.makeParser((String)object);
                            xMLReader = new ParserAdapter(parser);
                            System.err.println("warning: Features and properties not supported on SAX1 parsers.");
                        }
                        catch (Exception exception2) {
                            xMLReader = null;
                            System.err.println("error: Unable to instantiate parser (org.apache.xerces.parsers.SAXParser)");
                        }
                    }
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("n")) {
                    bl = ((String)object2).equals("n");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("v")) {
                    bl2 = ((String)object2).equals("v");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("s")) {
                    bl3 = ((String)object2).equals("s");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("f")) {
                    bl4 = ((String)object2).equals("f");
                    continue;
                }
                if (((String)object2).equals("h")) {
                    DelayedInput.printUsage();
                    continue;
                }
            }
            if (xMLReader == null) {
                try {
                    xMLReader = XMLReaderFactory.createXMLReader(DEFAULT_PARSER_NAME);
                }
                catch (Exception exception) {
                    System.err.println("error: Unable to instantiate parser (org.apache.xerces.parsers.SAXParser)");
                    continue;
                }
            }
            try {
                xMLReader.setFeature(NAMESPACES_FEATURE_ID, bl);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespaces)");
            }
            try {
                xMLReader.setFeature(VALIDATION_FEATURE_ID, bl2);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/validation)");
            }
            try {
                xMLReader.setFeature(SCHEMA_VALIDATION_FEATURE_ID, bl3);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema)");
            }
            try {
                xMLReader.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, bl4);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
            }
            xMLReader.setContentHandler(delayedInput);
            xMLReader.setErrorHandler(delayedInput);
            try {
                System.out.println("# filename: " + string);
                object2 = new DelayedInputStream(new FileInputStream(string));
                object = new InputSource((InputStream)object2);
                ((InputSource)object).setSystemId(string);
                xMLReader.parse((InputSource)object);
                continue;
            }
            catch (SAXParseException sAXParseException) {
                continue;
            }
            catch (Exception exception) {
                System.err.println("error: Parse error occurred - " + exception.getMessage());
                if (exception instanceof SAXException) {
                    object2 = ((SAXException)exception).getException();
                }
                ((Throwable)object2).printStackTrace(System.err);
            }
        }
    }

    private static void printUsage() {
        System.err.println("usage: java socket.DelayedInput (options) filename ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name  Select parser by name.");
        System.err.println("  -n | -N  Turn on/off namespace processing.");
        System.err.println("  -v | -V  Turn on/off validation.");
        System.err.println("  -s | -S  Turn on/off Schema validation support.");
        System.err.println("           NOTE: Not supported by all parsers.");
        System.err.println("  -f  | -F Turn on/off Schema full checking.");
        System.err.println("           NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -h       This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Parser:     org.apache.xerces.parsers.SAXParser");
        System.err.print("  Namespaces: ");
        System.err.println("on");
        System.err.print("  Validation: ");
        System.err.println("off");
        System.err.print("  Schema:     ");
        System.err.println("off");
        System.err.print("  Schema full checking:     ");
        System.err.println("off");
    }

    static class DelayedInputStream
    extends FilterInputStream {
        private Random fRandom = new Random(System.currentTimeMillis());

        public DelayedInputStream(InputStream inputStream) {
            super(inputStream);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (n2 > 48) {
                n2 = 48;
            }
            int n3 = 0;
            long l = System.currentTimeMillis();
            n3 = this.in.read(byArray, n, n2);
            try {
                Thread.sleep(Math.abs(this.fRandom.nextInt()) % 2000);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace(System.err);
            }
            long l2 = System.currentTimeMillis();
            System.out.print("read " + n3 + " bytes in " + (l2 - l) + " ms: ");
            this.printBuffer(byArray, n, n3);
            System.out.println();
            return n3;
        }

        private void printBuffer(byte[] byArray, int n, int n2) {
            if (n2 <= 0) {
                System.out.print("no data read");
                return;
            }
            System.out.print('[');
            block4: for (int i = 0; i < n2; ++i) {
                switch ((char)byArray[n + i]) {
                    case '\r': {
                        System.out.print("\\r");
                        continue block4;
                    }
                    case '\n': {
                        System.out.print("\\n");
                        continue block4;
                    }
                    default: {
                        System.out.print((char)byArray[n + i]);
                    }
                }
            }
            System.out.print(']');
        }
    }
}

