/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.BreakStatement;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.ContinueStatement;
import org.eclipse.jdt.internal.compiler.ast.DoStatement;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.ForStatement;
import org.eclipse.jdt.internal.compiler.ast.ForeachStatement;
import org.eclipse.jdt.internal.compiler.ast.Invocation;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.UnaryExpression;
import org.eclipse.jdt.internal.compiler.ast.WhileStatement;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public abstract class Statement
extends ASTNode {
    public static final int NOT_COMPLAINED = 0;
    public static final int COMPLAINED_FAKE_REACHABLE = 1;
    public static final int COMPLAINED_UNREACHABLE = 2;

    protected static boolean isKnowDeadCodePattern(Expression expression) {
        if (expression instanceof UnaryExpression) {
            expression = ((UnaryExpression)expression).expression;
        }
        return expression instanceof Reference;
    }

    public abstract FlowInfo analyseCode(BlockScope var1, FlowContext var2, FlowInfo var3);

    public boolean doesNotCompleteNormally() {
        return false;
    }

    public boolean completesByContinue() {
        return false;
    }

    protected void analyseArguments(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, MethodBinding methodBinding, Expression[] expressionArray) {
        block8: {
            int n;
            boolean bl;
            block9: {
                TypeBinding typeBinding;
                if (expressionArray == null) break block8;
                CompilerOptions compilerOptions = blockScope.compilerOptions();
                if (compilerOptions.sourceLevel >= 0x330000L && methodBinding.isPolymorphic()) {
                    return;
                }
                boolean bl2 = blockScope.environment().usesNullTypeAnnotations();
                bl = methodBinding.parameterNonNullness != null;
                n = methodBinding.parameters.length;
                int n2 = -1;
                TypeBinding typeBinding2 = null;
                boolean bl3 = false;
                if ((bl2 || bl) && methodBinding.isVarargs()) {
                    TypeBinding typeBinding3;
                    n2 = n - 1;
                    typeBinding2 = methodBinding.parameters[n2];
                    if (n == expressionArray.length && ((typeBinding3 = expressionArray[n2].resolvedType) == TypeBinding.NULL || typeBinding2.dimensions() == typeBinding3.dimensions() && typeBinding3.isCompatibleWith(typeBinding2))) {
                        bl3 = true;
                    }
                    if (!bl3) {
                        --n;
                    }
                }
                if (!bl2) break block9;
                for (int i = 0; i < n; ++i) {
                    typeBinding = methodBinding.parameters[i];
                    Boolean bl4 = bl ? methodBinding.parameterNonNullness[i] : null;
                    this.analyseOneArgument18(blockScope, flowContext, flowInfo, typeBinding, expressionArray[i], bl4, methodBinding.original().parameters[i]);
                }
                if (bl3 || !(typeBinding2 instanceof ArrayBinding)) break block8;
                TypeBinding typeBinding4 = ((ArrayBinding)typeBinding2).elementsType();
                typeBinding = bl ? methodBinding.parameterNonNullness[n2] : null;
                for (int i = n; i < expressionArray.length; ++i) {
                    this.analyseOneArgument18(blockScope, flowContext, flowInfo, typeBinding4, expressionArray[i], (Boolean)((Object)typeBinding), methodBinding.original().parameters[n2]);
                }
                break block8;
            }
            if (bl) {
                for (int i = 0; i < n; ++i) {
                    if (methodBinding.parameterNonNullness[i] != Boolean.TRUE) continue;
                    TypeBinding typeBinding = methodBinding.parameters[i];
                    Expression expression = expressionArray[i];
                    int n3 = expression.nullStatus(flowInfo, flowContext);
                    if (n3 == 4) continue;
                    flowContext.recordNullityMismatch(blockScope, expression, expression.resolvedType, typeBinding, flowInfo, n3, null);
                }
            }
        }
    }

    void analyseOneArgument18(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, TypeBinding typeBinding, Expression expression, Boolean bl, TypeBinding typeBinding2) {
        if (expression instanceof ConditionalExpression && expression.isPolyExpression()) {
            ConditionalExpression conditionalExpression = (ConditionalExpression)expression;
            conditionalExpression.internalAnalyseOneArgument18(blockScope, flowContext, typeBinding, conditionalExpression.valueIfTrue, flowInfo, conditionalExpression.ifTrueNullStatus, bl, typeBinding2);
            conditionalExpression.internalAnalyseOneArgument18(blockScope, flowContext, typeBinding, conditionalExpression.valueIfFalse, flowInfo, conditionalExpression.ifFalseNullStatus, bl, typeBinding2);
            return;
        }
        int n = expression.nullStatus(flowInfo, flowContext);
        this.internalAnalyseOneArgument18(blockScope, flowContext, typeBinding, expression, flowInfo, n, bl, typeBinding2);
    }

    void internalAnalyseOneArgument18(BlockScope blockScope, FlowContext flowContext, TypeBinding typeBinding, Expression expression, FlowInfo flowInfo, int n, Boolean bl, TypeBinding typeBinding2) {
        int n2 = bl == Boolean.TRUE ? n : 0;
        NullAnnotationMatching nullAnnotationMatching = NullAnnotationMatching.analyse(typeBinding, expression.resolvedType, n);
        if (!nullAnnotationMatching.isAnyMismatch() && n2 != 0) {
            typeBinding = typeBinding2;
        }
        if (n2 == 2) {
            blockScope.problemReporter().nullityMismatchingTypeAnnotation(expression, expression.resolvedType, typeBinding, nullAnnotationMatching);
        } else if (nullAnnotationMatching.isAnyMismatch() || (n2 & 0x10) != 0) {
            if (!typeBinding.hasNullTypeAnnotations() && bl == Boolean.TRUE) {
                LookupEnvironment lookupEnvironment = blockScope.environment();
                typeBinding = lookupEnvironment.createAnnotatedType(typeBinding, new AnnotationBinding[]{lookupEnvironment.getNonNullAnnotation()});
            }
            flowContext.recordNullityMismatch(blockScope, expression, expression.resolvedType, typeBinding, flowInfo, n, nullAnnotationMatching);
        }
    }

    protected void checkAgainstNullTypeAnnotation(BlockScope blockScope, TypeBinding typeBinding, Expression expression, FlowContext flowContext, FlowInfo flowInfo) {
        if (expression instanceof ConditionalExpression && expression.isPolyExpression()) {
            ConditionalExpression conditionalExpression = (ConditionalExpression)expression;
            this.internalCheckAgainstNullTypeAnnotation(blockScope, typeBinding, conditionalExpression.valueIfTrue, conditionalExpression.ifTrueNullStatus, flowContext, flowInfo);
            this.internalCheckAgainstNullTypeAnnotation(blockScope, typeBinding, conditionalExpression.valueIfFalse, conditionalExpression.ifFalseNullStatus, flowContext, flowInfo);
            return;
        }
        int n = expression.nullStatus(flowInfo, flowContext);
        this.internalCheckAgainstNullTypeAnnotation(blockScope, typeBinding, expression, n, flowContext, flowInfo);
    }

    private void internalCheckAgainstNullTypeAnnotation(BlockScope blockScope, TypeBinding typeBinding, Expression expression, int n, FlowContext flowContext, FlowInfo flowInfo) {
        NullAnnotationMatching nullAnnotationMatching = NullAnnotationMatching.analyse(typeBinding, expression.resolvedType, null, null, n, expression, NullAnnotationMatching.CheckMode.COMPATIBLE);
        if (nullAnnotationMatching.isDefiniteMismatch()) {
            blockScope.problemReporter().nullityMismatchingTypeAnnotation(expression, expression.resolvedType, typeBinding, nullAnnotationMatching);
        } else {
            if (nullAnnotationMatching.wantToReport()) {
                nullAnnotationMatching.report(blockScope);
            }
            if (nullAnnotationMatching.isUnchecked()) {
                flowContext.recordNullityMismatch(blockScope, expression, expression.resolvedType, typeBinding, flowInfo, n, nullAnnotationMatching);
            }
        }
    }

    public void branchChainTo(BranchLabel branchLabel) {
    }

    public boolean breaksOut(final char[] cArray) {
        return new ASTVisitor(){
            boolean breaksOut;

            @Override
            public boolean visit(TypeDeclaration typeDeclaration, BlockScope blockScope) {
                return cArray != null;
            }

            @Override
            public boolean visit(TypeDeclaration typeDeclaration, ClassScope classScope) {
                return cArray != null;
            }

            @Override
            public boolean visit(LambdaExpression lambdaExpression, BlockScope blockScope) {
                return cArray != null;
            }

            @Override
            public boolean visit(WhileStatement whileStatement, BlockScope blockScope) {
                return cArray != null;
            }

            @Override
            public boolean visit(DoStatement doStatement, BlockScope blockScope) {
                return cArray != null;
            }

            @Override
            public boolean visit(ForeachStatement foreachStatement, BlockScope blockScope) {
                return cArray != null;
            }

            @Override
            public boolean visit(ForStatement forStatement, BlockScope blockScope) {
                return cArray != null;
            }

            @Override
            public boolean visit(SwitchStatement switchStatement, BlockScope blockScope) {
                return cArray != null;
            }

            @Override
            public boolean visit(BreakStatement breakStatement, BlockScope blockScope) {
                if (cArray == null || CharOperation.equals(cArray, breakStatement.label)) {
                    this.breaksOut = true;
                }
                return false;
            }

            public boolean breaksOut() {
                Statement.this.traverse(this, null);
                return this.breaksOut;
            }
        }.breaksOut();
    }

    public boolean continuesAtOuterLabel() {
        return new ASTVisitor(){
            boolean continuesToLabel;

            @Override
            public boolean visit(ContinueStatement continueStatement, BlockScope blockScope) {
                if (continueStatement.label != null) {
                    this.continuesToLabel = true;
                }
                return false;
            }

            public boolean continuesAtOuterLabel() {
                Statement.this.traverse(this, null);
                return this.continuesToLabel;
            }
        }.continuesAtOuterLabel();
    }

    public int complainIfUnreachable(FlowInfo flowInfo, BlockScope blockScope, int n, boolean bl) {
        if ((flowInfo.reachMode() & 3) != 0) {
            if ((flowInfo.reachMode() & 1) != 0) {
                this.bits &= Integer.MAX_VALUE;
            }
            if (flowInfo == FlowInfo.DEAD_END) {
                if (n < 2) {
                    blockScope.problemReporter().unreachableCode(this);
                    if (bl) {
                        blockScope.checkUnclosedCloseables(flowInfo, null, null, null);
                    }
                }
                return 2;
            }
            if (n < 1) {
                blockScope.problemReporter().fakeReachable(this);
                if (bl) {
                    blockScope.checkUnclosedCloseables(flowInfo, null, null, null);
                }
            }
            return 1;
        }
        return n;
    }

    public void generateArguments(MethodBinding methodBinding, Expression[] expressionArray, BlockScope blockScope, CodeStream codeStream) {
        block10: {
            block9: {
                int n;
                if (!methodBinding.isVarargs()) break block9;
                TypeBinding[] typeBindingArray = methodBinding.parameters;
                int n2 = typeBindingArray.length;
                int n3 = n2 - 1;
                for (int i = 0; i < n3; ++i) {
                    expressionArray[i].generateCode(blockScope, codeStream, true);
                }
                ArrayBinding arrayBinding = (ArrayBinding)typeBindingArray[n3];
                ArrayBinding arrayBinding2 = (ArrayBinding)methodBinding.parameters[n3].erasure();
                int n4 = arrayBinding.elementsType().id;
                int n5 = n = expressionArray == null ? 0 : expressionArray.length;
                if (n > n2) {
                    codeStream.generateInlinedValue(n - n3);
                    codeStream.newArray(arrayBinding2);
                    for (int i = n3; i < n; ++i) {
                        codeStream.dup();
                        codeStream.generateInlinedValue(i - n3);
                        expressionArray[i].generateCode(blockScope, codeStream, true);
                        codeStream.arrayAtPut(n4, false);
                    }
                } else if (n == n2) {
                    TypeBinding typeBinding = expressionArray[n3].resolvedType;
                    if (typeBinding == TypeBinding.NULL || arrayBinding.dimensions() == typeBinding.dimensions() && typeBinding.isCompatibleWith(arrayBinding2)) {
                        expressionArray[n3].generateCode(blockScope, codeStream, true);
                    } else {
                        codeStream.generateInlinedValue(1);
                        codeStream.newArray(arrayBinding2);
                        codeStream.dup();
                        codeStream.generateInlinedValue(0);
                        expressionArray[n3].generateCode(blockScope, codeStream, true);
                        codeStream.arrayAtPut(n4, false);
                    }
                } else {
                    codeStream.generateInlinedValue(0);
                    codeStream.newArray(arrayBinding2);
                }
                break block10;
            }
            if (expressionArray == null) break block10;
            int n = expressionArray.length;
            for (int i = 0; i < n; ++i) {
                expressionArray[i].generateCode(blockScope, codeStream, true);
            }
        }
    }

    public abstract void generateCode(BlockScope var1, CodeStream var2);

    public boolean isBoxingCompatible(TypeBinding typeBinding, TypeBinding typeBinding2, Expression expression, Scope scope) {
        if (scope.isBoxingCompatibleWith(typeBinding, typeBinding2)) {
            return true;
        }
        return typeBinding.isBaseType() && !typeBinding2.isBaseType() && !typeBinding2.isTypeVariable() && scope.compilerOptions().sourceLevel >= 0x310000L && (typeBinding2.id == 26 || typeBinding2.id == 27 || typeBinding2.id == 28) && expression.isConstantValueOfTypeAssignableToType(typeBinding, scope.environment().computeBoxingType(typeBinding2));
    }

    public boolean isEmptyBlock() {
        return false;
    }

    public boolean isValidJavaStatement() {
        return true;
    }

    @Override
    public StringBuffer print(int n, StringBuffer stringBuffer) {
        return this.printStatement(n, stringBuffer);
    }

    public abstract StringBuffer printStatement(int var1, StringBuffer var2);

    public abstract void resolve(BlockScope var1);

    public Constant resolveCase(BlockScope blockScope, TypeBinding typeBinding, SwitchStatement switchStatement) {
        this.resolve(blockScope);
        return Constant.NotAConstant;
    }

    public TypeBinding invocationTargetType() {
        return null;
    }

    public TypeBinding expectedType() {
        return this.invocationTargetType();
    }

    public ExpressionContext getExpressionContext() {
        return ExpressionContext.VANILLA_CONTEXT;
    }

    protected MethodBinding findConstructorBinding(BlockScope blockScope, Invocation invocation, ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray) {
        MethodBinding methodBinding = blockScope.getConstructor(referenceBinding, typeBindingArray, invocation);
        Statement.resolvePolyExpressionArguments(invocation, methodBinding, typeBindingArray, blockScope);
        return methodBinding;
    }
}

