/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.util.Arrays;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ExportsStatement;
import org.eclipse.jdt.internal.compiler.ast.ModuleDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ModuleReference;
import org.eclipse.jdt.internal.compiler.ast.ModuleStatement;
import org.eclipse.jdt.internal.compiler.ast.OpensStatement;
import org.eclipse.jdt.internal.compiler.ast.ProvidesStatement;
import org.eclipse.jdt.internal.compiler.ast.RequiresStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.UsesStatement;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.IModulePathEntry;
import org.eclipse.jdt.internal.compiler.env.ISourceModule;
import org.eclipse.jdt.internal.compiler.env.ModuleReferenceImpl;
import org.eclipse.jdt.internal.compiler.env.PackageExportImpl;

public class BasicModule
implements ISourceModule {
    boolean isAutomodule;
    private boolean isOpen = false;
    char[] name;
    IModule.IModuleReference[] requires;
    IModule.IPackageExport[] exports;
    char[][] uses;
    Service[] provides;
    IModule.IPackageExport[] opens;
    private ICompilationUnit compilationUnit;

    private static PackageExportImpl createPackageExport(ExportsStatement[] exportsStatementArray, int n) {
        ExportsStatement exportsStatement = exportsStatementArray[n];
        PackageExportImpl packageExportImpl = new PackageExportImpl();
        packageExportImpl.pack = exportsStatement.pkgName;
        ModuleReference[] moduleReferenceArray = exportsStatement.targets;
        if (moduleReferenceArray != null) {
            packageExportImpl.exportedTo = new char[moduleReferenceArray.length][];
            for (int i = 0; i < moduleReferenceArray.length; ++i) {
                packageExportImpl.exportedTo = moduleReferenceArray[i].tokens;
            }
        }
        return packageExportImpl;
    }

    private static Service createService(TypeReference typeReference, TypeReference[] typeReferenceArray) {
        Service service = new Service();
        service.provides = CharOperation.concatWith(typeReference.getTypeName(), '.');
        service.with = new char[typeReferenceArray.length][];
        for (int i = 0; i < typeReferenceArray.length; ++i) {
            service.with[i] = CharOperation.concatWith(typeReferenceArray[i].getTypeName(), '.');
        }
        return service;
    }

    private static PackageExportImpl createPackageOpen(OpensStatement opensStatement) {
        PackageExportImpl packageExportImpl = new PackageExportImpl();
        packageExportImpl.pack = opensStatement.pkgName;
        ModuleReference[] moduleReferenceArray = opensStatement.targets;
        if (moduleReferenceArray != null) {
            packageExportImpl.exportedTo = new char[moduleReferenceArray.length][];
            for (int i = 0; i < moduleReferenceArray.length; ++i) {
                packageExportImpl.exportedTo = moduleReferenceArray[i].tokens;
            }
        }
        return packageExportImpl;
    }

    public BasicModule(ModuleDeclaration moduleDeclaration, IModulePathEntry iModulePathEntry) {
        Object object;
        int n;
        ModuleStatement[] moduleStatementArray;
        this.compilationUnit = moduleDeclaration.compilationResult().compilationUnit;
        this.name = moduleDeclaration.moduleName;
        if (moduleDeclaration.requiresCount > 0) {
            moduleStatementArray = moduleDeclaration.requires;
            this.requires = new ModuleReferenceImpl[moduleStatementArray.length];
            for (n = 0; n < moduleStatementArray.length; ++n) {
                object = new ModuleReferenceImpl();
                ((ModuleReferenceImpl)object).name = CharOperation.concatWith(((RequiresStatement)moduleStatementArray[n]).module.tokens, '.');
                ((ModuleReferenceImpl)object).modifiers = ((RequiresStatement)moduleStatementArray[n]).modifiers;
                this.requires[n] = object;
            }
        } else {
            this.requires = new ModuleReferenceImpl[0];
        }
        if (moduleDeclaration.exportsCount > 0) {
            moduleStatementArray = moduleDeclaration.exports;
            this.exports = new PackageExportImpl[moduleStatementArray.length];
            for (n = 0; n < moduleStatementArray.length; ++n) {
                this.exports[n] = object = BasicModule.createPackageExport((ExportsStatement[])moduleStatementArray, n);
            }
        } else {
            this.exports = new PackageExportImpl[0];
        }
        if (moduleDeclaration.usesCount > 0) {
            moduleStatementArray = moduleDeclaration.uses;
            this.uses = new char[moduleStatementArray.length][];
            for (n = 0; n < moduleStatementArray.length; ++n) {
                this.uses[n] = CharOperation.concatWith(((UsesStatement)moduleStatementArray[n]).serviceInterface.getTypeName(), '.');
            }
        }
        if (moduleDeclaration.servicesCount > 0) {
            moduleStatementArray = moduleDeclaration.services;
            this.provides = new Service[moduleDeclaration.servicesCount];
            for (n = 0; n < moduleDeclaration.servicesCount; ++n) {
                this.provides[n] = BasicModule.createService(((ProvidesStatement)moduleStatementArray[n]).serviceInterface, ((ProvidesStatement)moduleStatementArray[n]).implementations);
            }
        }
        if (moduleDeclaration.opensCount > 0) {
            moduleStatementArray = moduleDeclaration.opens;
            this.opens = new PackageExportImpl[moduleStatementArray.length];
            for (n = 0; n < moduleStatementArray.length; ++n) {
                this.opens[n] = object = BasicModule.createPackageOpen((OpensStatement)moduleStatementArray[n]);
            }
        } else {
            this.opens = new PackageExportImpl[0];
        }
        this.isAutomodule = false;
        this.isOpen = moduleDeclaration.isOpen();
    }

    @Override
    public ICompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    @Override
    public char[] name() {
        return this.name;
    }

    @Override
    public IModule.IModuleReference[] requires() {
        return this.requires;
    }

    @Override
    public IModule.IPackageExport[] exports() {
        return this.exports;
    }

    @Override
    public char[][] uses() {
        return this.uses;
    }

    @Override
    public IModule.IService[] provides() {
        return this.provides;
    }

    @Override
    public IModule.IPackageExport[] opens() {
        return this.opens;
    }

    @Override
    public boolean isAutomatic() {
        return this.isAutomodule;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IModule)) {
            return false;
        }
        IModule iModule = (IModule)object;
        if (!CharOperation.equals(this.name, iModule.name())) {
            return false;
        }
        return Arrays.equals(this.requires, iModule.requires());
    }

    public int hashCode() {
        int n = 17;
        int n2 = CharOperation.hashCode(this.name);
        n = 31 * n + n2;
        n2 = Arrays.hashCode(this.requires);
        n = 31 * n + n2;
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        this.toStringContent(stringBuffer);
        return stringBuffer.toString();
    }

    protected void toStringContent(StringBuffer stringBuffer) {
        int n;
        stringBuffer.append("\nmodule ");
        stringBuffer.append(this.name).append(' ');
        stringBuffer.append('{').append('\n');
        if (this.requires != null) {
            for (n = 0; n < this.requires.length; ++n) {
                stringBuffer.append("\trequires ");
                if (this.requires[n].isTransitive()) {
                    stringBuffer.append(" public ");
                }
                stringBuffer.append(this.requires[n].name());
                stringBuffer.append(';').append('\n');
            }
        }
        if (this.exports != null) {
            stringBuffer.append('\n');
            for (n = 0; n < this.exports.length; ++n) {
                stringBuffer.append("\texports ");
                stringBuffer.append(this.exports[n].toString());
            }
        }
        if (this.uses != null) {
            stringBuffer.append('\n');
            for (char[] object : this.uses) {
                stringBuffer.append(object);
                stringBuffer.append(';').append('\n');
            }
        }
        if (this.provides != null) {
            stringBuffer.append('\n');
            for (Service service : this.provides) {
                stringBuffer.append(service.toString());
            }
        }
        stringBuffer.append('\n').append('}').toString();
    }

    static class Service
    implements IModule.IService {
        char[] provides;
        char[][] with;

        Service() {
        }

        @Override
        public char[] name() {
            return this.provides;
        }

        @Override
        public char[][] with() {
            return this.with;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("provides");
            stringBuffer.append(this.provides);
            stringBuffer.append(" with ");
            stringBuffer.append(this.with);
            stringBuffer.append(';');
            return stringBuffer.toString();
        }
    }
}

