/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jdt.internal.compiler.classfmt.ExternalAnnotationProvider;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.ITypeAnnotationWalker;
import org.eclipse.jdt.internal.compiler.lookup.AnnotatableTypeSystem;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.IntersectionTypeBinding18;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBindingVisitor;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.util.Messages;

class ExternalAnnotationSuperimposer
extends TypeBindingVisitor {
    private ITypeAnnotationWalker currentWalker;
    private TypeBinding typeReplacement;
    private LookupEnvironment environment;
    private boolean isReplacing;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void apply(SourceTypeBinding sourceTypeBinding, String string) {
        ZipFile zipFile = null;
        try {
            File file = new File(string);
            if (file.exists()) {
                InputStream inputStream;
                String string2 = String.valueOf(sourceTypeBinding.constantPoolName());
                String string3 = string2.replace('.', '/') + ".eea";
                if (file.isDirectory()) {
                    inputStream = new FileInputStream(string + '/' + string3);
                } else {
                    zipFile = new ZipFile(string);
                    ZipEntry zipEntry = zipFile.getEntry(string3);
                    if (zipEntry == null) {
                        return;
                    }
                    inputStream = zipFile.getInputStream(zipEntry);
                }
                ExternalAnnotationSuperimposer.annotateType(sourceTypeBinding, new ExternalAnnotationProvider(inputStream, string2), sourceTypeBinding.environment);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            sourceTypeBinding.scope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_externaAnnotationFile, new String[]{String.valueOf(sourceTypeBinding.readableName()), string, iOException.getMessage()}));
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static void annotateType(SourceTypeBinding sourceTypeBinding, ExternalAnnotationProvider externalAnnotationProvider, LookupEnvironment lookupEnvironment) {
        ITypeAnnotationWalker iTypeAnnotationWalker = externalAnnotationProvider.forTypeHeader(lookupEnvironment);
        if (iTypeAnnotationWalker != null && iTypeAnnotationWalker != ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER) {
            ExternalAnnotationSuperimposer externalAnnotationSuperimposer = new ExternalAnnotationSuperimposer(lookupEnvironment);
            TypeVariableBinding[] typeVariableBindingArray = sourceTypeBinding.typeVariables();
            for (int i = 0; i < typeVariableBindingArray.length; ++i) {
                if (!externalAnnotationSuperimposer.go(iTypeAnnotationWalker.toTypeParameter(true, i))) continue;
                typeVariableBindingArray[i] = externalAnnotationSuperimposer.superimpose(typeVariableBindingArray[i], TypeVariableBinding.class);
            }
        }
        sourceTypeBinding.externalAnnotationProvider = externalAnnotationProvider;
    }

    public static void annotateFieldBinding(FieldBinding fieldBinding, ExternalAnnotationProvider externalAnnotationProvider, LookupEnvironment lookupEnvironment) {
        ITypeAnnotationWalker iTypeAnnotationWalker;
        ExternalAnnotationSuperimposer externalAnnotationSuperimposer;
        char[] cArray = fieldBinding.genericSignature();
        if (cArray == null && fieldBinding.type != null) {
            cArray = fieldBinding.type.signature();
        }
        if ((externalAnnotationSuperimposer = new ExternalAnnotationSuperimposer(lookupEnvironment)).go(iTypeAnnotationWalker = externalAnnotationProvider.forField(fieldBinding.name, cArray, lookupEnvironment))) {
            fieldBinding.type = externalAnnotationSuperimposer.superimpose(fieldBinding.type, TypeBinding.class);
        }
    }

    public static void annotateMethodBinding(MethodBinding methodBinding, ExternalAnnotationProvider externalAnnotationProvider, LookupEnvironment lookupEnvironment) {
        ITypeAnnotationWalker iTypeAnnotationWalker;
        char[] cArray = methodBinding.genericSignature();
        if (cArray == null) {
            cArray = methodBinding.signature();
        }
        if ((iTypeAnnotationWalker = externalAnnotationProvider.forMethod(methodBinding.selector, cArray, lookupEnvironment)) != null && iTypeAnnotationWalker != ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER) {
            ExternalAnnotationSuperimposer externalAnnotationSuperimposer = new ExternalAnnotationSuperimposer(lookupEnvironment);
            TypeVariableBinding[] typeVariableBindingArray = methodBinding.typeVariables;
            for (int n = 0; n < typeVariableBindingArray.length; n = (int)((short)(n + 1))) {
                if (!externalAnnotationSuperimposer.go(iTypeAnnotationWalker.toTypeParameter(false, n))) continue;
                typeVariableBindingArray[n] = externalAnnotationSuperimposer.superimpose(typeVariableBindingArray[n], TypeVariableBinding.class);
            }
            if (!methodBinding.isConstructor() && externalAnnotationSuperimposer.go(iTypeAnnotationWalker.toMethodReturn())) {
                methodBinding.returnType = externalAnnotationSuperimposer.superimpose(methodBinding.returnType, TypeBinding.class);
            }
            TypeBinding[] typeBindingArray = methodBinding.parameters;
            for (short s = 0; s < typeBindingArray.length; s = (short)(s + 1)) {
                if (!externalAnnotationSuperimposer.go(iTypeAnnotationWalker.toMethodParameter(s))) continue;
                typeBindingArray[s] = externalAnnotationSuperimposer.superimpose(typeBindingArray[s], TypeBinding.class);
            }
        }
    }

    ExternalAnnotationSuperimposer(LookupEnvironment lookupEnvironment) {
        this.environment = lookupEnvironment;
    }

    private ExternalAnnotationSuperimposer(TypeBinding typeBinding, boolean bl, ITypeAnnotationWalker iTypeAnnotationWalker) {
        this.typeReplacement = typeBinding;
        this.isReplacing = bl;
        this.currentWalker = iTypeAnnotationWalker;
    }

    private ExternalAnnotationSuperimposer snapshot() {
        ExternalAnnotationSuperimposer externalAnnotationSuperimposer = new ExternalAnnotationSuperimposer(this.typeReplacement, this.isReplacing, this.currentWalker);
        this.typeReplacement = null;
        this.isReplacing = false;
        return externalAnnotationSuperimposer;
    }

    private void restore(ExternalAnnotationSuperimposer externalAnnotationSuperimposer) {
        this.isReplacing = externalAnnotationSuperimposer.isReplacing;
        this.currentWalker = externalAnnotationSuperimposer.currentWalker;
    }

    boolean go(ITypeAnnotationWalker iTypeAnnotationWalker) {
        this.reset();
        this.typeReplacement = null;
        this.isReplacing = false;
        this.currentWalker = iTypeAnnotationWalker;
        return iTypeAnnotationWalker != ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER;
    }

    <T extends TypeBinding> T superimpose(T t, Class<? extends T> clazz) {
        TypeBindingVisitor.visit((TypeBindingVisitor)this, t);
        if (clazz.isInstance(this.typeReplacement)) {
            return (T)((TypeBinding)clazz.cast(this.typeReplacement));
        }
        return t;
    }

    private TypeBinding goAndSuperimpose(ITypeAnnotationWalker iTypeAnnotationWalker, TypeBinding typeBinding) {
        if (iTypeAnnotationWalker == ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER) {
            return typeBinding;
        }
        this.currentWalker = iTypeAnnotationWalker;
        TypeBindingVisitor.visit((TypeBindingVisitor)this, typeBinding);
        if (this.typeReplacement == null) {
            return typeBinding;
        }
        this.isReplacing = true;
        TypeBinding typeBinding2 = this.typeReplacement;
        this.typeReplacement = null;
        return typeBinding2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visit(ArrayBinding arrayBinding) {
        ExternalAnnotationSuperimposer externalAnnotationSuperimposer = this.snapshot();
        try {
            int n = arrayBinding.dimensions;
            AnnotationBinding[][] annotationBindingArray = new AnnotationBinding[n][];
            ITypeAnnotationWalker iTypeAnnotationWalker = this.currentWalker;
            for (int i = 0; i < n; ++i) {
                IBinaryAnnotation[] iBinaryAnnotationArray = iTypeAnnotationWalker.getAnnotationsAtCursor(arrayBinding.id, false);
                if (iBinaryAnnotationArray != ITypeAnnotationWalker.NO_ANNOTATIONS) {
                    annotationBindingArray[i] = BinaryTypeBinding.createAnnotations(iBinaryAnnotationArray, this.environment, null);
                    this.isReplacing = true;
                } else {
                    annotationBindingArray[i] = Binding.NO_ANNOTATIONS;
                }
                iTypeAnnotationWalker = iTypeAnnotationWalker.toNextArrayDimension();
            }
            TypeBinding typeBinding = this.goAndSuperimpose(iTypeAnnotationWalker, arrayBinding.leafComponentType());
            if (this.isReplacing) {
                this.typeReplacement = this.environment.createArrayType(typeBinding, n, AnnotatableTypeSystem.flattenedAnnotations(annotationBindingArray));
            }
        }
        finally {
            this.restore(externalAnnotationSuperimposer);
        }
        return false;
    }

    @Override
    public boolean visit(BaseTypeBinding baseTypeBinding) {
        return false;
    }

    @Override
    public boolean visit(IntersectionTypeBinding18 intersectionTypeBinding18) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visit(ParameterizedTypeBinding parameterizedTypeBinding) {
        ExternalAnnotationSuperimposer externalAnnotationSuperimposer = this.snapshot();
        try {
            int n;
            IBinaryAnnotation[] iBinaryAnnotationArray = this.currentWalker.getAnnotationsAtCursor(parameterizedTypeBinding.id, false);
            AnnotationBinding[] annotationBindingArray = Binding.NO_ANNOTATIONS;
            if (iBinaryAnnotationArray != ITypeAnnotationWalker.NO_ANNOTATIONS) {
                annotationBindingArray = BinaryTypeBinding.createAnnotations(iBinaryAnnotationArray, this.environment, null);
                this.isReplacing = true;
            }
            TypeBinding[] typeBindingArray = parameterizedTypeBinding.typeArguments();
            TypeBinding[] typeBindingArray2 = new TypeBinding[typeBindingArray.length];
            for (n = 0; n < typeBindingArray.length; ++n) {
                typeBindingArray2[n] = this.goAndSuperimpose(externalAnnotationSuperimposer.currentWalker.toTypeArgument(n), typeBindingArray[n]);
            }
            if (this.isReplacing) {
                this.typeReplacement = this.environment.createParameterizedType(parameterizedTypeBinding.genericType(), typeBindingArray2, parameterizedTypeBinding.enclosingType(), annotationBindingArray);
            }
            n = 0;
            return n != 0;
        }
        finally {
            this.restore(externalAnnotationSuperimposer);
        }
    }

    @Override
    public boolean visit(RawTypeBinding rawTypeBinding) {
        return this.visit((ReferenceBinding)rawTypeBinding);
    }

    @Override
    public boolean visit(ReferenceBinding referenceBinding) {
        IBinaryAnnotation[] iBinaryAnnotationArray = this.currentWalker.getAnnotationsAtCursor(referenceBinding.id, false);
        if (iBinaryAnnotationArray != ITypeAnnotationWalker.NO_ANNOTATIONS) {
            this.typeReplacement = this.environment.createAnnotatedType((TypeBinding)referenceBinding, BinaryTypeBinding.createAnnotations(iBinaryAnnotationArray, this.environment, null));
        }
        return false;
    }

    @Override
    public boolean visit(TypeVariableBinding typeVariableBinding) {
        return this.visit((ReferenceBinding)typeVariableBinding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visit(WildcardBinding wildcardBinding) {
        TypeBinding typeBinding = wildcardBinding.bound;
        ExternalAnnotationSuperimposer externalAnnotationSuperimposer = this.snapshot();
        try {
            if (typeBinding != null) {
                typeBinding = this.goAndSuperimpose(externalAnnotationSuperimposer.currentWalker.toWildcardBound(), typeBinding);
            }
            IBinaryAnnotation[] iBinaryAnnotationArray = externalAnnotationSuperimposer.currentWalker.getAnnotationsAtCursor(-1, false);
            if (this.isReplacing || iBinaryAnnotationArray != ITypeAnnotationWalker.NO_ANNOTATIONS) {
                TypeBinding[] typeBindingArray = wildcardBinding.otherBounds;
                if (iBinaryAnnotationArray != ITypeAnnotationWalker.NO_ANNOTATIONS) {
                    AnnotationBinding[] annotationBindingArray = BinaryTypeBinding.createAnnotations(iBinaryAnnotationArray, this.environment, null);
                    this.typeReplacement = this.environment.createWildcard(wildcardBinding.genericType, wildcardBinding.rank, typeBinding, typeBindingArray, wildcardBinding.boundKind, annotationBindingArray);
                } else {
                    this.typeReplacement = this.environment.createWildcard(wildcardBinding.genericType, wildcardBinding.rank, typeBinding, typeBindingArray, wildcardBinding.boundKind);
                }
            }
        }
        finally {
            this.restore(externalAnnotationSuperimposer);
        }
        return false;
    }
}

