/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.problem;

import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.compiler.util.Util;

public class DefaultProblem
extends CategorizedProblem {
    private char[] fileName;
    private int id;
    private int startPosition;
    private int endPosition;
    private int line;
    public int column;
    public int severity;
    private String[] arguments;
    private String message;
    private static final String MARKER_TYPE_PROBLEM = "org.eclipse.jdt.core.problem";
    private static final String MARKER_TYPE_TASK = "org.eclipse.jdt.core.task";
    public static final Object[] EMPTY_VALUES = new Object[0];

    public DefaultProblem(char[] cArray, String string, int n, String[] stringArray, int n2, int n3, int n4, int n5, int n6) {
        this.fileName = cArray;
        this.message = string;
        this.id = n;
        this.arguments = stringArray;
        this.severity = n2;
        this.startPosition = n3;
        this.endPosition = n4;
        this.line = n5;
        this.column = n6;
    }

    public void reportError() {
    }

    public String errorReportSource(char[] cArray) {
        int n;
        int n2;
        char c;
        int n3;
        if (this.startPosition > this.endPosition || this.startPosition < 0 && this.endPosition < 0 || cArray.length == 0) {
            return Messages.problem_noSourceInformation;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(' ').append(Messages.bind(Messages.problem_atLine, String.valueOf(this.line)));
        stringBuffer.append(Util.LINE_SEPARATOR);
        stringBuffer.append('\t');
        int n4 = cArray.length;
        int n5 = n3 = this.startPosition >= n4 ? n4 - 1 : this.startPosition;
        while (n3 > 0 && (c = cArray[n3 - 1]) != '\n' && c != '\r') {
            --n3;
        }
        int n6 = n2 = this.endPosition >= n4 ? n4 - 1 : this.endPosition;
        while (n2 + 1 < n4 && (c = cArray[n2 + 1]) != '\r' && c != '\n') {
            ++n2;
        }
        while ((c = cArray[n3]) == ' ' || c == '\t') {
            ++n3;
        }
        stringBuffer.append(cArray, n3, n2 - n3 + 1);
        stringBuffer.append(Util.LINE_SEPARATOR).append("\t");
        for (n = n3; n < this.startPosition; ++n) {
            stringBuffer.append(cArray[n] == '\t' ? (char)'\t' : ' ');
        }
        for (n = this.startPosition; n <= (this.endPosition >= n4 ? n4 - 1 : this.endPosition); ++n) {
            stringBuffer.append('^');
        }
        return stringBuffer.toString();
    }

    @Override
    public String[] getArguments() {
        return this.arguments;
    }

    @Override
    public int getCategoryID() {
        return ProblemReporter.getProblemCategory(this.severity, this.id);
    }

    @Override
    public int getID() {
        return this.id;
    }

    public String getInternalCategoryMessage() {
        switch (this.getCategoryID()) {
            case 0: {
                return "unspecified";
            }
            case 10: {
                return "buildpath";
            }
            case 20: {
                return "syntax";
            }
            case 30: {
                return "import";
            }
            case 40: {
                return "type";
            }
            case 50: {
                return "member";
            }
            case 60: {
                return "internal";
            }
            case 70: {
                return "javadoc";
            }
            case 80: {
                return "code style";
            }
            case 90: {
                return "potential programming problem";
            }
            case 100: {
                return "name shadowing conflict";
            }
            case 110: {
                return "deprecation";
            }
            case 120: {
                return "unnecessary code";
            }
            case 130: {
                return "unchecked/raw";
            }
            case 140: {
                return "nls";
            }
            case 150: {
                return "restriction";
            }
            case 160: {
                return "module";
            }
        }
        return null;
    }

    @Override
    public String getMarkerType() {
        return this.id == 536871362 ? MARKER_TYPE_TASK : MARKER_TYPE_PROBLEM;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public char[] getOriginatingFileName() {
        return this.fileName;
    }

    @Override
    public int getSourceEnd() {
        return this.endPosition;
    }

    public int getSourceColumnNumber() {
        return this.column;
    }

    @Override
    public int getSourceLineNumber() {
        return this.line;
    }

    @Override
    public int getSourceStart() {
        return this.startPosition;
    }

    @Override
    public boolean isError() {
        return (this.severity & 1) != 0;
    }

    @Override
    public boolean isWarning() {
        return (this.severity & 1) == 0 && (this.severity & 0x400) == 0;
    }

    @Override
    public boolean isInfo() {
        return (this.severity & 0x400) != 0;
    }

    public void setOriginatingFileName(char[] cArray) {
        this.fileName = cArray;
    }

    @Override
    public void setSourceEnd(int n) {
        this.endPosition = n;
    }

    @Override
    public void setSourceLineNumber(int n) {
        this.line = n;
    }

    @Override
    public void setSourceStart(int n) {
        this.startPosition = n;
    }

    public String toString() {
        String string = "Pb(" + (this.id & 0x7FFFFF) + ") ";
        if (this.message != null) {
            string = string + this.message;
        } else if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                string = string + " " + this.arguments[i];
            }
        }
        return string;
    }
}

