/*
 * Decompiled with CFR 0.152.
 */
package org.glyptodon.guacamole.net.auth.simple;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.glyptodon.guacamole.GuacamoleException;
import org.glyptodon.guacamole.environment.Environment;
import org.glyptodon.guacamole.environment.LocalEnvironment;
import org.glyptodon.guacamole.net.GuacamoleSocket;
import org.glyptodon.guacamole.net.GuacamoleTunnel;
import org.glyptodon.guacamole.net.InetGuacamoleSocket;
import org.glyptodon.guacamole.net.SSLGuacamoleSocket;
import org.glyptodon.guacamole.net.SimpleGuacamoleTunnel;
import org.glyptodon.guacamole.net.auth.AbstractConnection;
import org.glyptodon.guacamole.net.auth.ConnectionRecord;
import org.glyptodon.guacamole.protocol.ConfiguredGuacamoleSocket;
import org.glyptodon.guacamole.protocol.GuacamoleClientInformation;
import org.glyptodon.guacamole.protocol.GuacamoleConfiguration;

public class SimpleConnection
extends AbstractConnection {
    private static final String DEFAULT_GUACD_HOSTNAME = "localhost";
    private static final int DEFAULT_GUACD_PORT = 4822;
    private GuacamoleConfiguration config;

    public SimpleConnection() {
    }

    public SimpleConnection(String name, String identifier, GuacamoleConfiguration config) {
        this.setName(name);
        this.setIdentifier(identifier);
        this.setConfiguration(config);
        this.config = config;
    }

    @Override
    public int getActiveConnections() {
        return 0;
    }

    @Override
    public Map<String, String> getAttributes() {
        return Collections.emptyMap();
    }

    @Override
    public void setAttributes(Map<String, String> attributes) {
    }

    @Override
    public GuacamoleTunnel connect(GuacamoleClientInformation info) throws GuacamoleException {
        LocalEnvironment env = new LocalEnvironment();
        String hostname = env.getProperty(Environment.GUACD_HOSTNAME, DEFAULT_GUACD_HOSTNAME);
        int port = env.getProperty(Environment.GUACD_PORT, 4822);
        ConfiguredGuacamoleSocket socket = env.getProperty(Environment.GUACD_SSL, false) != false ? new ConfiguredGuacamoleSocket((GuacamoleSocket)new SSLGuacamoleSocket(hostname, port), this.config, info) : new ConfiguredGuacamoleSocket((GuacamoleSocket)new InetGuacamoleSocket(hostname, port), this.config, info);
        return new SimpleGuacamoleTunnel((GuacamoleSocket)socket);
    }

    public List<ConnectionRecord> getHistory() throws GuacamoleException {
        return Collections.emptyList();
    }
}

