/*
 * Decompiled with CFR 0.152.
 */
package org.glyptodon.guacamole.net.auth.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.glyptodon.guacamole.GuacamoleException;
import org.glyptodon.guacamole.GuacamoleSecurityException;
import org.glyptodon.guacamole.net.auth.permission.ObjectPermission;
import org.glyptodon.guacamole.net.auth.permission.ObjectPermissionSet;

public class SimpleObjectPermissionSet
implements ObjectPermissionSet {
    private Set<ObjectPermission> permissions = Collections.emptySet();

    public SimpleObjectPermissionSet() {
    }

    public SimpleObjectPermissionSet(Set<ObjectPermission> permissions) {
        this.permissions = permissions;
    }

    protected void setPermissions(Set<ObjectPermission> permissions) {
        this.permissions = permissions;
    }

    @Override
    public Set<ObjectPermission> getPermissions() {
        return this.permissions;
    }

    @Override
    public boolean hasPermission(ObjectPermission.Type permission, String identifier) throws GuacamoleException {
        ObjectPermission objectPermission = new ObjectPermission(permission, identifier);
        return this.permissions.contains(objectPermission);
    }

    @Override
    public void addPermission(ObjectPermission.Type permission, String identifier) throws GuacamoleException {
        throw new GuacamoleSecurityException("Permission denied.");
    }

    @Override
    public void removePermission(ObjectPermission.Type permission, String identifier) throws GuacamoleException {
        throw new GuacamoleSecurityException("Permission denied.");
    }

    @Override
    public Collection<String> getAccessibleObjects(Collection<ObjectPermission.Type> permissionTypes, Collection<String> identifiers) throws GuacamoleException {
        ArrayList<String> accessibleObjects = new ArrayList<String>(this.permissions.size());
        block0: for (String identifier : identifiers) {
            for (ObjectPermission.Type permissionType : permissionTypes) {
                ObjectPermission permission = new ObjectPermission(permissionType, identifier);
                if (!this.permissions.contains(permission)) continue;
                accessibleObjects.add(identifier);
                continue block0;
            }
        }
        return accessibleObjects;
    }

    @Override
    public void addPermissions(Set<ObjectPermission> permissions) throws GuacamoleException {
        throw new GuacamoleSecurityException("Permission denied.");
    }

    @Override
    public void removePermissions(Set<ObjectPermission> permissions) throws GuacamoleException {
        throw new GuacamoleSecurityException("Permission denied.");
    }
}

