/*
 * Decompiled with CFR 0.152.
 */
package org.glyptodon.guacamole.net.auth.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.glyptodon.guacamole.GuacamoleException;
import org.glyptodon.guacamole.form.Form;
import org.glyptodon.guacamole.net.auth.ActiveConnection;
import org.glyptodon.guacamole.net.auth.AuthenticationProvider;
import org.glyptodon.guacamole.net.auth.Connection;
import org.glyptodon.guacamole.net.auth.ConnectionGroup;
import org.glyptodon.guacamole.net.auth.ConnectionRecordSet;
import org.glyptodon.guacamole.net.auth.Directory;
import org.glyptodon.guacamole.net.auth.User;
import org.glyptodon.guacamole.net.auth.UserContext;
import org.glyptodon.guacamole.net.auth.simple.SimpleConnection;
import org.glyptodon.guacamole.net.auth.simple.SimpleConnectionDirectory;
import org.glyptodon.guacamole.net.auth.simple.SimpleConnectionGroup;
import org.glyptodon.guacamole.net.auth.simple.SimpleConnectionGroupDirectory;
import org.glyptodon.guacamole.net.auth.simple.SimpleConnectionRecordSet;
import org.glyptodon.guacamole.net.auth.simple.SimpleDirectory;
import org.glyptodon.guacamole.net.auth.simple.SimpleUser;
import org.glyptodon.guacamole.net.auth.simple.SimpleUserDirectory;
import org.glyptodon.guacamole.protocol.GuacamoleConfiguration;

public class SimpleUserContext
implements UserContext {
    private static final String ROOT_IDENTIFIER = "ROOT";
    private final AuthenticationProvider authProvider;
    private final User self;
    private final Directory<User> userDirectory;
    private final Directory<ConnectionGroup> connectionGroupDirectory;
    private final Directory<Connection> connectionDirectory;
    private final ConnectionGroup rootGroup;

    public SimpleUserContext(AuthenticationProvider authProvider, Map<String, GuacamoleConfiguration> configs) {
        this(authProvider, UUID.randomUUID().toString(), configs);
    }

    public SimpleUserContext(AuthenticationProvider authProvider, String username, Map<String, GuacamoleConfiguration> configs) {
        ArrayList<String> connectionIdentifiers = new ArrayList<String>(configs.size());
        Set<String> connectionGroupIdentifiers = Collections.singleton(ROOT_IDENTIFIER);
        ArrayList<Connection> connections = new ArrayList<Connection>(configs.size());
        for (Map.Entry<String, GuacamoleConfiguration> configEntry : configs.entrySet()) {
            String identifier = configEntry.getKey();
            GuacamoleConfiguration config = configEntry.getValue();
            SimpleConnection connection = new SimpleConnection(identifier, identifier, config);
            connection.setParentIdentifier(ROOT_IDENTIFIER);
            connections.add(connection);
            connectionIdentifiers.add(identifier);
        }
        this.rootGroup = new SimpleConnectionGroup(ROOT_IDENTIFIER, ROOT_IDENTIFIER, connectionIdentifiers, Collections.<String>emptyList());
        this.self = new SimpleUser(username, connectionIdentifiers, connectionGroupIdentifiers);
        this.userDirectory = new SimpleUserDirectory(this.self);
        this.connectionDirectory = new SimpleConnectionDirectory(connections);
        this.connectionGroupDirectory = new SimpleConnectionGroupDirectory(Collections.singleton(this.rootGroup));
        this.authProvider = authProvider;
    }

    @Override
    public User self() {
        return this.self;
    }

    @Override
    public AuthenticationProvider getAuthenticationProvider() {
        return this.authProvider;
    }

    @Override
    public Directory<User> getUserDirectory() throws GuacamoleException {
        return this.userDirectory;
    }

    @Override
    public Directory<Connection> getConnectionDirectory() throws GuacamoleException {
        return this.connectionDirectory;
    }

    @Override
    public Directory<ConnectionGroup> getConnectionGroupDirectory() throws GuacamoleException {
        return this.connectionGroupDirectory;
    }

    @Override
    public ConnectionGroup getRootConnectionGroup() throws GuacamoleException {
        return this.rootGroup;
    }

    @Override
    public Directory<ActiveConnection> getActiveConnectionDirectory() throws GuacamoleException {
        return new SimpleDirectory<ActiveConnection>();
    }

    @Override
    public ConnectionRecordSet getConnectionHistory() throws GuacamoleException {
        return new SimpleConnectionRecordSet();
    }

    @Override
    public Collection<Form> getUserAttributes() {
        return Collections.emptyList();
    }

    @Override
    public Collection<Form> getConnectionAttributes() {
        return Collections.emptyList();
    }

    @Override
    public Collection<Form> getConnectionGroupAttributes() {
        return Collections.emptyList();
    }
}

