/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.ext;

import java.lang.reflect.ReflectPermission;
import java.net.URL;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.FactoryFinder;

public abstract class RuntimeDelegate {
    public static final String JAXRS_RUNTIME_DELEGATE_PROPERTY = "javax.ws.rs.ext.RuntimeDelegate";
    private static final String JAXRS_DEFAULT_RUNTIME_DELEGATE = "com.sun.ws.rs.ext.RuntimeDelegateImpl";
    private static ReflectPermission rp = new ReflectPermission("suppressAccessChecks");
    private static volatile RuntimeDelegate rd;

    protected RuntimeDelegate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RuntimeDelegate getInstance() {
        RuntimeDelegate runtimeDelegate = rd;
        if (runtimeDelegate != null) return runtimeDelegate;
        Class<RuntimeDelegate> clazz = RuntimeDelegate.class;
        synchronized (RuntimeDelegate.class) {
            runtimeDelegate = rd;
            if (runtimeDelegate != null) return runtimeDelegate;
            rd = runtimeDelegate = RuntimeDelegate.findDelegate();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return runtimeDelegate;
        }
    }

    private static RuntimeDelegate findDelegate() {
        try {
            Object object = FactoryFinder.find(JAXRS_RUNTIME_DELEGATE_PROPERTY, JAXRS_DEFAULT_RUNTIME_DELEGATE);
            if (!(object instanceof RuntimeDelegate)) {
                Class<RuntimeDelegate> clazz = RuntimeDelegate.class;
                String string = clazz.getName().replace('.', '/') + ".class";
                ClassLoader classLoader = clazz.getClassLoader();
                if (classLoader == null) {
                    classLoader = ClassLoader.getSystemClassLoader();
                }
                URL uRL = classLoader.getResource(string);
                throw new LinkageError("ClassCastException: attempting to cast" + object.getClass().getClassLoader().getResource(string) + "to" + uRL.toString());
            }
            return (RuntimeDelegate)object;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInstance(RuntimeDelegate runtimeDelegate) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(rp);
        }
        Class<RuntimeDelegate> clazz = RuntimeDelegate.class;
        synchronized (RuntimeDelegate.class) {
            rd = runtimeDelegate;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public abstract UriBuilder createUriBuilder();

    public abstract Response.ResponseBuilder createResponseBuilder();

    public abstract Variant.VariantListBuilder createVariantListBuilder();

    public abstract <T> T createEndpoint(Application var1, Class<T> var2) throws IllegalArgumentException, UnsupportedOperationException;

    public abstract <T> HeaderDelegate<T> createHeaderDelegate(Class<T> var1);

    public static interface HeaderDelegate<T> {
        public T fromString(String var1) throws IllegalArgumentException;

        public String toString(T var1);
    }
}

