/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.snappy.buffer;

import java.lang.ref.SoftReference;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.xerial.snappy.buffer.BufferAllocator;
import org.xerial.snappy.buffer.BufferAllocatorFactory;

public class CachedBufferAllocator
implements BufferAllocator {
    private static BufferAllocatorFactory factory = new BufferAllocatorFactory(){

        public BufferAllocator getBufferAllocator(int bufferSize) {
            return CachedBufferAllocator.getAllocator(bufferSize);
        }
    };
    private static final Map<Integer, SoftReference<CachedBufferAllocator>> queueTable = new HashMap<Integer, SoftReference<CachedBufferAllocator>>();
    private final int bufferSize;
    private final Deque<byte[]> bufferQueue;

    public static void setBufferAllocatorFactory(BufferAllocatorFactory factory) {
        assert (factory != null);
        CachedBufferAllocator.factory = factory;
    }

    public static BufferAllocatorFactory getBufferAllocatorFactory() {
        return factory;
    }

    public CachedBufferAllocator(int bufferSize) {
        this.bufferSize = bufferSize;
        this.bufferQueue = new ArrayDeque<byte[]>();
    }

    public static synchronized CachedBufferAllocator getAllocator(int bufferSize) {
        CachedBufferAllocator result = null;
        if (queueTable.containsKey(bufferSize)) {
            result = queueTable.get(bufferSize).get();
        }
        if (result == null) {
            result = new CachedBufferAllocator(bufferSize);
            queueTable.put(bufferSize, new SoftReference<CachedBufferAllocator>(result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] allocate(int size) {
        CachedBufferAllocator cachedBufferAllocator = this;
        synchronized (cachedBufferAllocator) {
            if (this.bufferQueue.isEmpty()) {
                return new byte[size];
            }
            return this.bufferQueue.pollFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(byte[] buffer) {
        CachedBufferAllocator cachedBufferAllocator = this;
        synchronized (cachedBufferAllocator) {
            this.bufferQueue.addLast(buffer);
        }
    }
}

