/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.TreeMap;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class SystemdFormatter
extends Formatter {
    private TreeMap<Integer, String> levelMapping = new TreeMap();

    public SystemdFormatter() {
        this.levelMapping.put(Level.OFF.intValue(), "<0>");
        this.levelMapping.put(Level.SEVERE.intValue(), "<2>");
        this.levelMapping.put(Level.WARNING.intValue(), "<4>");
        this.levelMapping.put(Level.INFO.intValue(), "<6>");
        this.levelMapping.put(Level.CONFIG.intValue(), "<6>");
        this.levelMapping.put(Level.FINE.intValue(), "<7>");
        this.levelMapping.put(Level.FINER.intValue(), "<7>");
        this.levelMapping.put(Level.FINEST.intValue(), "<7>");
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        String prefix = this.getSystemdLevel(record.getLevel());
        sb.append(prefix);
        sb.append(this.formatMessage(record));
        if (record.getThrown() != null) {
            sb.append("\n").append(prefix);
            sb.append(this.toString(record.getThrown()).replaceAll("\t", "    ").replaceAll("\\n", "\n" + prefix));
        }
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    private String toString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    private String getSystemdLevel(Level level) {
        String systemdLevel = this.levelMapping.get(level.intValue());
        if (systemdLevel == null) {
            systemdLevel = this.levelMapping.ceilingEntry(level.intValue()).getValue();
            this.levelMapping.put(level.intValue(), systemdLevel);
        }
        return systemdLevel;
    }
}

