/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class CombinedBinaryExpression
extends BinaryExpression {
    public int arity;
    public int arityMax;
    public static final int ARITY_MAX_MAX = 160;
    public static final int ARITY_MAX_MIN = 20;
    public static int defaultArityMaxStartingValue = 20;
    public BinaryExpression[] referencesTable;

    public CombinedBinaryExpression(Expression expression, Expression expression2, int n, int n2) {
        super(expression, expression2, n);
        this.initArity(expression, n2);
    }

    public CombinedBinaryExpression(CombinedBinaryExpression combinedBinaryExpression) {
        super(combinedBinaryExpression);
        this.initArity(combinedBinaryExpression.left, combinedBinaryExpression.arity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.referencesTable == null) {
            return super.analyseCode(blockScope, flowContext, flowInfo);
        }
        try {
            BinaryExpression binaryExpression = this.referencesTable[0];
            flowInfo = binaryExpression.left.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
            if (binaryExpression.resolvedType.id != 11) {
                binaryExpression.left.checkNPE(blockScope, flowContext, flowInfo);
            }
            int n = this.arity;
            for (int i = 0; i < n; ++i) {
                binaryExpression = this.referencesTable[i];
                flowInfo = binaryExpression.right.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
                if (binaryExpression.resolvedType.id == 11) continue;
                binaryExpression.right.checkNPE(blockScope, flowContext, flowInfo);
            }
            flowInfo = this.right.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
            if (this.resolvedType.id != 11) {
                this.right.checkNPE(blockScope, flowContext, flowInfo);
            }
            FlowInfo flowInfo2 = flowInfo;
            return flowInfo2;
        }
        finally {
            flowContext.recordAbruptExit();
        }
    }

    @Override
    public void generateOptimizedStringConcatenation(BlockScope blockScope, CodeStream codeStream, int n) {
        if (this.referencesTable == null) {
            super.generateOptimizedStringConcatenation(blockScope, codeStream, n);
        } else if ((this.bits & 0xFC0) >> 6 == 14 && (this.bits & 0xF) == 11) {
            if (this.constant != Constant.NotAConstant) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
                codeStream.invokeStringConcatenationAppendForType(this.implicitConversion & 0xF);
            } else {
                BinaryExpression binaryExpression = this.referencesTable[0];
                int n2 = 0;
                int n3 = codeStream.position;
                for (n2 = this.arity - 1; n2 >= 0; --n2) {
                    binaryExpression = this.referencesTable[n2];
                    if (binaryExpression.constant == Constant.NotAConstant) continue;
                    codeStream.generateConstant(binaryExpression.constant, binaryExpression.implicitConversion);
                    codeStream.invokeStringConcatenationAppendForType(binaryExpression.implicitConversion & 0xF);
                    break;
                }
                if (++n2 == 0) {
                    binaryExpression.left.generateOptimizedStringConcatenation(blockScope, codeStream, binaryExpression.left.implicitConversion & 0xF);
                }
                for (int i = n2; i < this.arity; ++i) {
                    binaryExpression = this.referencesTable[i];
                    codeStream.recordPositionsFrom(n3, binaryExpression.left.sourceStart);
                    int n4 = codeStream.position;
                    binaryExpression.right.generateOptimizedStringConcatenation(blockScope, codeStream, binaryExpression.right.implicitConversion & 0xF);
                    codeStream.recordPositionsFrom(n4, binaryExpression.right.sourceStart);
                }
                codeStream.recordPositionsFrom(n3, this.left.sourceStart);
                n3 = codeStream.position;
                this.right.generateOptimizedStringConcatenation(blockScope, codeStream, this.right.implicitConversion & 0xF);
                codeStream.recordPositionsFrom(n3, this.right.sourceStart);
            }
        } else {
            super.generateOptimizedStringConcatenation(blockScope, codeStream, n);
        }
    }

    @Override
    public void generateOptimizedStringConcatenationCreation(BlockScope blockScope, CodeStream codeStream, int n) {
        if (this.referencesTable == null) {
            super.generateOptimizedStringConcatenationCreation(blockScope, codeStream, n);
        } else if ((this.bits & 0xFC0) >> 6 == 14 && (this.bits & 0xF) == 11 && this.constant == Constant.NotAConstant) {
            int n2 = codeStream.position;
            BinaryExpression binaryExpression = this.referencesTable[this.arity - 1];
            int n3 = 0;
            for (n3 = this.arity - 1; n3 >= 0; --n3) {
                binaryExpression = this.referencesTable[n3];
                if ((binaryExpression.bits & 0xFC0) >> 6 == 14 && (binaryExpression.bits & 0xF) == 11) {
                    if (binaryExpression.constant == Constant.NotAConstant) continue;
                    codeStream.newStringContatenation();
                    codeStream.dup();
                    codeStream.ldc(binaryExpression.constant.stringValue());
                    codeStream.invokeStringConcatenationStringConstructor();
                    break;
                }
                binaryExpression.generateOptimizedStringConcatenationCreation(blockScope, codeStream, binaryExpression.implicitConversion & 0xF);
                break;
            }
            if (++n3 == 0) {
                binaryExpression.left.generateOptimizedStringConcatenationCreation(blockScope, codeStream, binaryExpression.left.implicitConversion & 0xF);
            }
            for (int i = n3; i < this.arity; ++i) {
                binaryExpression = this.referencesTable[i];
                codeStream.recordPositionsFrom(n2, binaryExpression.left.sourceStart);
                int n4 = codeStream.position;
                binaryExpression.right.generateOptimizedStringConcatenation(blockScope, codeStream, binaryExpression.right.implicitConversion & 0xF);
                codeStream.recordPositionsFrom(n4, binaryExpression.right.sourceStart);
            }
            codeStream.recordPositionsFrom(n2, this.left.sourceStart);
            n2 = codeStream.position;
            this.right.generateOptimizedStringConcatenation(blockScope, codeStream, this.right.implicitConversion & 0xF);
            codeStream.recordPositionsFrom(n2, this.right.sourceStart);
        } else {
            super.generateOptimizedStringConcatenationCreation(blockScope, codeStream, n);
        }
    }

    private void initArity(Expression expression, int n) {
        this.arity = n;
        if (n > 1) {
            this.referencesTable = new BinaryExpression[n];
            this.referencesTable[n - 1] = (BinaryExpression)expression;
            for (int i = n - 1; i > 0; --i) {
                this.referencesTable[i - 1] = (BinaryExpression)this.referencesTable[i].left;
            }
        } else {
            this.arityMax = defaultArityMaxStartingValue;
        }
    }

    @Override
    public StringBuffer printExpressionNoParenthesis(int n, StringBuffer stringBuffer) {
        int n2;
        if (this.referencesTable == null) {
            return super.printExpressionNoParenthesis(n, stringBuffer);
        }
        String string = this.operatorToString();
        for (n2 = this.arity - 1; n2 >= 0; --n2) {
            stringBuffer.append('(');
        }
        stringBuffer = this.referencesTable[0].left.printExpression(n, stringBuffer);
        int n3 = this.arity;
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuffer.append(' ').append(string).append(' ');
            stringBuffer = this.referencesTable[n2].right.printExpression(0, stringBuffer);
            stringBuffer.append(')');
        }
        stringBuffer.append(' ').append(string).append(' ');
        return this.right.printExpression(0, stringBuffer);
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        if (this.referencesTable == null) {
            return super.resolveType(blockScope);
        }
        BinaryExpression binaryExpression = this.referencesTable[0];
        if (binaryExpression.left instanceof CastExpression) {
            binaryExpression.left.bits |= 0x20;
        }
        binaryExpression.left.resolveType(blockScope);
        int n = this.arity;
        for (int i = 0; i < n; ++i) {
            this.referencesTable[i].nonRecursiveResolveTypeUpwards(blockScope);
        }
        this.nonRecursiveResolveTypeUpwards(blockScope);
        return this.resolvedType;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (this.referencesTable == null) {
            super.traverse(aSTVisitor, blockScope);
        } else {
            if (aSTVisitor.visit(this, blockScope)) {
                int n;
                for (n = this.arity - 1; n >= 0; --n) {
                    if (aSTVisitor.visit(this.referencesTable[n], blockScope)) continue;
                    aSTVisitor.endVisit(this.referencesTable[n], blockScope);
                    break;
                }
                if (++n == 0) {
                    this.referencesTable[0].left.traverse(aSTVisitor, blockScope);
                }
                int n2 = this.arity;
                for (int i = n; i < n2; ++i) {
                    this.referencesTable[i].right.traverse(aSTVisitor, blockScope);
                    aSTVisitor.endVisit(this.referencesTable[i], blockScope);
                }
                this.right.traverse(aSTVisitor, blockScope);
            }
            aSTVisitor.endVisit(this, blockScope);
        }
    }

    public void tuneArityMax() {
        if (this.arityMax < 160) {
            this.arityMax *= 2;
        }
    }
}

