/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.List;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.Util;

public class FieldDeclaration
extends AbstractVariableDeclaration {
    public FieldBinding binding;
    public Javadoc javadoc;
    public int endPart1Position;
    public int endPart2Position;

    public FieldDeclaration() {
    }

    public FieldDeclaration(char[] cArray, int n, int n2) {
        this.name = cArray;
        this.sourceStart = n;
        this.sourceEnd = n2;
    }

    public FlowInfo analyseCode(MethodScope methodScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.binding != null && !this.binding.isUsed() && this.binding.isOrEnclosedByPrivateType() && !methodScope.referenceCompilationUnit().compilationResult.hasSyntaxError) {
            methodScope.problemReporter().unusedPrivateField(this);
        }
        if (this.binding != null && this.binding.isValidBinding() && this.binding.isStatic() && this.binding.constant(methodScope) == Constant.NotAConstant && this.binding.declaringClass.isNestedType() && !this.binding.declaringClass.isStatic()) {
            methodScope.problemReporter().unexpectedStaticModifierForField((SourceTypeBinding)this.binding.declaringClass, this);
        }
        if (this.initialization != null) {
            flowInfo = this.initialization.analyseCode(methodScope, flowContext, flowInfo).unconditionalInits();
            flowInfo.markAsDefinitelyAssigned(this.binding);
        }
        if (this.initialization != null && this.binding != null) {
            CompilerOptions compilerOptions = methodScope.compilerOptions();
            if (compilerOptions.isAnnotationBasedNullAnalysisEnabled && (this.binding.isNonNull() || compilerOptions.sourceLevel >= 0x340000L)) {
                int n = this.initialization.nullStatus(flowInfo, flowContext);
                NullAnnotationMatching.checkAssignment(methodScope, flowContext, this.binding, flowInfo, n, this.initialization, this.initialization.resolvedType);
            }
            this.initialization.checkNPEbyUnboxing(methodScope, flowContext, flowInfo);
        }
        return flowInfo;
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        boolean bl;
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n = codeStream.position;
        if (!(this.initialization == null || (bl = this.binding.isStatic()) && this.binding.constant() != Constant.NotAConstant)) {
            if (!bl) {
                codeStream.aload_0();
            }
            this.initialization.generateCode(blockScope, codeStream, true);
            if (bl) {
                codeStream.fieldAccess((byte)-77, this.binding, null);
            } else {
                codeStream.fieldAccess((byte)-75, this.binding, null);
            }
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public void getAllAnnotationContexts(int n, List list) {
        TypeReference.AnnotationCollector annotationCollector = new TypeReference.AnnotationCollector(this.type, n, list);
        for (Annotation annotation : this.annotations) {
            annotation.traverse((ASTVisitor)annotationCollector, (BlockScope)null);
        }
    }

    @Override
    public int getKind() {
        return this.type == null ? 3 : 1;
    }

    public boolean isStatic() {
        if (this.binding != null) {
            return this.binding.isStatic();
        }
        return (this.modifiers & 8) != 0;
    }

    public boolean isFinal() {
        if (this.binding != null) {
            return this.binding.isFinal();
        }
        return (this.modifiers & 0x10) != 0;
    }

    @Override
    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        if (this.javadoc != null) {
            this.javadoc.print(n, stringBuffer);
        }
        return super.printStatement(n, stringBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolve(MethodScope methodScope) {
        Binding binding;
        if ((this.bits & 0x10) != 0) {
            return;
        }
        if (this.binding == null || !this.binding.isValidBinding()) {
            return;
        }
        this.bits |= 0x10;
        ClassScope classScope = methodScope.enclosingClassScope();
        if (classScope != null) {
            Object object;
            binding = classScope.enclosingSourceType();
            if (((SourceTypeBinding)binding).superclass != null && (object = classScope.findField(((SourceTypeBinding)binding).superclass, this.name, this, false, true)) != null && ((Binding)object).isValidBinding() && ((FieldBinding)object).original() != this.binding && ((FieldBinding)object).canBeSeenBy((TypeBinding)binding, this, methodScope)) {
                methodScope.problemReporter().fieldHiding(this, (Binding)object);
            } else {
                FieldBinding fieldBinding;
                Binding binding2;
                object = classScope.parent;
                if (((Scope)object).kind != 4 && (binding2 = ((Scope)object).getBinding(this.name, 3, this, false)) != null && binding2.isValidBinding() && binding2 != this.binding && (!(binding2 instanceof FieldBinding) || (fieldBinding = (FieldBinding)binding2).original() != this.binding && (fieldBinding.isStatic() || !((ReferenceBinding)binding).isStatic()))) {
                    methodScope.problemReporter().fieldHiding(this, binding2);
                }
            }
        }
        if (this.type != null) {
            this.type.resolvedType = this.binding.type;
        }
        binding = methodScope.initializedField;
        int n = methodScope.lastVisibleFieldID;
        try {
            methodScope.initializedField = this.binding;
            methodScope.lastVisibleFieldID = this.binding.id;
            FieldDeclaration.resolveAnnotations((BlockScope)methodScope, this.annotations, this.binding);
            if (this.annotations != null) {
                int n2 = this.annotations.length;
                for (int i = 0; i < n2; ++i) {
                    TypeBinding typeBinding = this.annotations[i].resolvedType;
                    if (typeBinding == null || (typeBinding.getAnnotationTagBits() & 0x20000000000000L) == 0L) continue;
                    this.bits |= 0x100000;
                    break;
                }
            }
            if ((this.binding.getAnnotationTagBits() & 0x400000000000L) == 0L && (this.binding.modifiers & 0x100000) != 0 && methodScope.compilerOptions().sourceLevel >= 0x310000L) {
                methodScope.problemReporter().missingDeprecatedAnnotationForField(this);
            }
            if (this.initialization == null) {
                this.binding.setConstant(Constant.NotAConstant);
            } else {
                this.binding.setConstant(Constant.NotAConstant);
                TypeBinding typeBinding = this.binding.type;
                this.initialization.setExpressionContext(ExpressionContext.ASSIGNMENT_CONTEXT);
                this.initialization.setExpectedType(typeBinding);
                if (this.initialization instanceof ArrayInitializer) {
                    TypeBinding typeBinding2 = this.initialization.resolveTypeExpecting(methodScope, typeBinding);
                    if (typeBinding2 != null) {
                        ((ArrayInitializer)this.initialization).binding = (ArrayBinding)typeBinding2;
                        this.initialization.computeConversion(methodScope, typeBinding, typeBinding2);
                    }
                } else {
                    TypeBinding typeBinding3 = this.initialization.resolveType(methodScope);
                    if (typeBinding3 != null) {
                        if (TypeBinding.notEquals(typeBinding, typeBinding3)) {
                            methodScope.compilationUnitScope().recordTypeConversion(typeBinding, typeBinding3);
                        }
                        if (this.initialization.isConstantValueOfTypeAssignableToType(typeBinding3, typeBinding) || typeBinding3.isCompatibleWith(typeBinding, classScope)) {
                            this.initialization.computeConversion(methodScope, typeBinding, typeBinding3);
                            if (typeBinding3.needsUncheckedConversion(typeBinding)) {
                                methodScope.problemReporter().unsafeTypeConversion(this.initialization, typeBinding3, typeBinding);
                            }
                            if (this.initialization instanceof CastExpression && (this.initialization.bits & 0x4000) == 0) {
                                CastExpression.checkNeedForAssignedCast(methodScope, typeBinding, (CastExpression)this.initialization);
                            }
                        } else if (this.isBoxingCompatible(typeBinding3, typeBinding, this.initialization, methodScope)) {
                            this.initialization.computeConversion(methodScope, typeBinding, typeBinding3);
                            if (this.initialization instanceof CastExpression && (this.initialization.bits & 0x4000) == 0) {
                                CastExpression.checkNeedForAssignedCast(methodScope, typeBinding, (CastExpression)this.initialization);
                            }
                        } else if ((typeBinding.tagBits & 0x80L) == 0L) {
                            methodScope.problemReporter().typeMismatchError(typeBinding3, typeBinding, this.initialization, null);
                        }
                        if (this.binding.isFinal()) {
                            this.binding.setConstant(this.initialization.constant.castTo((this.binding.type.id << 4) + this.initialization.constant.typeID()));
                        }
                    } else {
                        this.binding.setConstant(Constant.NotAConstant);
                    }
                }
                if (this.binding == Expression.getDirectBinding(this.initialization)) {
                    methodScope.problemReporter().assignmentHasNoEffect(this, this.name);
                }
            }
        }
        finally {
            methodScope.initializedField = binding;
            methodScope.lastVisibleFieldID = n;
            if (this.binding.constant(methodScope) == null) {
                this.binding.setConstant(Constant.NotAConstant);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveJavadoc(MethodScope methodScope) {
        if (this.javadoc != null) {
            FieldBinding fieldBinding = methodScope.initializedField;
            int n = methodScope.lastVisibleFieldID;
            try {
                methodScope.initializedField = this.binding;
                if (this.binding != null) {
                    methodScope.lastVisibleFieldID = this.binding.id;
                }
                this.javadoc.resolve(methodScope);
            }
            finally {
                methodScope.initializedField = fieldBinding;
                methodScope.lastVisibleFieldID = n;
            }
        } else if (this.binding != null && this.binding.declaringClass != null && !this.binding.declaringClass.isLocalType()) {
            int n = this.binding.modifiers & 7;
            ProblemReporter problemReporter = methodScope.problemReporter();
            int n2 = problemReporter.computeSeverity(-1610612250);
            if (n2 != 256) {
                ClassScope classScope = methodScope.enclosingClassScope();
                if (classScope != null) {
                    n = Util.computeOuterMostVisibility(classScope.referenceType(), n);
                }
                int n3 = this.binding.modifiers & 0xFFFFFFF8 | n;
                problemReporter.javadocMissing(this.sourceStart, this.sourceEnd, n2, n3);
            }
        }
    }

    public void traverse(ASTVisitor aSTVisitor, MethodScope methodScope) {
        if (aSTVisitor.visit(this, methodScope)) {
            if (this.javadoc != null) {
                this.javadoc.traverse(aSTVisitor, methodScope);
            }
            if (this.annotations != null) {
                int n = this.annotations.length;
                for (int i = 0; i < n; ++i) {
                    this.annotations[i].traverse(aSTVisitor, methodScope);
                }
            }
            if (this.type != null) {
                this.type.traverse(aSTVisitor, methodScope);
            }
            if (this.initialization != null) {
                this.initialization.traverse(aSTVisitor, methodScope);
            }
        }
        aSTVisitor.endVisit(this, methodScope);
    }
}

