/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;

public abstract class ClasspathLocation
implements FileSystem.Classpath,
SuffixConstants {
    public static final int SOURCE = 1;
    public static final int BINARY = 2;
    String path;
    char[] normalizedPath;
    public AccessRuleSet accessRuleSet;
    IModule module;
    protected boolean isAutoModule;
    public String destinationPath;

    protected ClasspathLocation(AccessRuleSet accessRuleSet, String string) {
        this.accessRuleSet = accessRuleSet;
        this.destinationPath = string;
    }

    protected AccessRestriction fetchAccessRestriction(String string) {
        if (this.accessRuleSet == null) {
            return null;
        }
        char[] cArray = string.substring(0, string.length() - SUFFIX_CLASS.length).toCharArray();
        if (File.separatorChar == '\\') {
            CharOperation.replace(cArray, File.separatorChar, '/');
        }
        return this.accessRuleSet.getViolatedRestriction(cArray);
    }

    public int getMode() {
        return 3;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.getMode();
        n = 31 * n + (this.path == null ? 0 : this.path.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ClasspathLocation classpathLocation = (ClasspathLocation)object;
        String string = this.getPath();
        String string2 = classpathLocation.getPath();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        return this.getMode() == classpathLocation.getMode();
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getDestinationPath() {
        return this.destinationPath;
    }

    @Override
    public void acceptModule(IModule iModule) {
        this.module = iModule;
        this.isAutoModule = iModule.isAutomatic();
    }

    @Override
    public boolean isAutomaticModule() {
        return this.isAutoModule;
    }

    @Override
    public Collection<String> getModuleNames(Collection<String> collection) {
        return this.getModuleNames(collection, string -> this.getModule(string.toCharArray()));
    }

    @Override
    public Collection<String> getModuleNames(Collection<String> collection, Function<String, IModule> function) {
        if (this.module != null) {
            String string = String.valueOf(this.module.name());
            return this.selectModules(Collections.singleton(string), collection, function);
        }
        return Collections.emptyList();
    }

    protected Collection<String> selectModules(Set<String> set, Collection<String> collection, Function<String, IModule> function) {
        Collection<String> collection2;
        HashSet<String> hashSet;
        if (collection != null) {
            hashSet = new HashSet<String>(set);
            hashSet.retainAll(collection);
            collection2 = hashSet;
        } else {
            collection2 = this.allModules(set, string -> string, string -> this.getModule(string.toCharArray()));
        }
        hashSet = new HashSet<String>(collection2);
        for (String string2 : collection2) {
            this.addRequired(string2, hashSet, function);
        }
        return hashSet;
    }

    private void addRequired(String string, Set<String> set, Function<String, IModule> function) {
        IModule iModule = this.getModule(string.toCharArray());
        if (iModule != null) {
            for (IModule.IModuleReference iModuleReference : iModule.requires()) {
                String string2;
                IModule iModule2 = function.apply(new String(iModuleReference.name()));
                if (iModule2 == null || !set.add(string2 = String.valueOf(iModule2.name()))) continue;
                this.addRequired(string2, set, function);
            }
        }
    }

    protected <T> List<String> allModules(Iterable<T> iterable, Function<T, String> function, Function<T, IModule> function2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (T t : iterable) {
            String string = function.apply(t);
            arrayList.add(string);
        }
        return arrayList;
    }

    @Override
    public boolean isPackage(String string, String string2) {
        return this.getModulesDeclaringPackage(string, string2) != null;
    }

    protected char[][] singletonModuleNameIf(boolean bl) {
        if (!bl) {
            return null;
        }
        if (this.module != null) {
            return new char[][]{this.module.name()};
        }
        return new char[][]{ModuleBinding.UNNAMED};
    }

    @Override
    public void reset() {
        this.module = null;
    }
}

