/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.Arrays;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public class AnnotationBinding {
    ReferenceBinding type;
    ElementValuePair[] pairs;

    public static AnnotationBinding[] addStandardAnnotations(AnnotationBinding[] annotationBindingArray, long l, LookupEnvironment lookupEnvironment) {
        if ((l & 0x77FFFFF800000000L) == 0L) {
            return annotationBindingArray;
        }
        boolean bl = false;
        for (AnnotationBinding annotationBinding : annotationBindingArray) {
            if (annotationBinding.getAnnotationType().id != 44) continue;
            bl = true;
            break;
        }
        int n = 0;
        if ((l & 0x20600FF800000000L) != 0L) {
            ++n;
        }
        if ((l & 0x300000000000L) != 0L) {
            ++n;
        }
        if (!bl && (l & 0x400000000000L) != 0L) {
            ++n;
        }
        if ((l & 0x800000000000L) != 0L) {
            ++n;
        }
        if ((l & 0x1000000000000L) != 0L) {
            ++n;
        }
        if ((l & 0x2000000000000L) != 0L) {
            ++n;
        }
        if ((l & 0x4000000000000L) != 0L) {
            ++n;
        }
        if ((l & 0x10000000000000L) != 0L) {
            ++n;
        }
        if ((l & 0x8000000000000L) != 0L) {
            ++n;
        }
        if (n == 0) {
            return annotationBindingArray;
        }
        int n2 = annotationBindingArray.length;
        AnnotationBinding[] annotationBindingArray2 = new AnnotationBinding[n2 + n];
        System.arraycopy(annotationBindingArray, 0, annotationBindingArray2, 0, n2);
        if ((l & 0x20600FF800000000L) != 0L) {
            annotationBindingArray2[n2++] = AnnotationBinding.buildTargetAnnotation(l, lookupEnvironment);
        }
        if ((l & 0x300000000000L) != 0L) {
            annotationBindingArray2[n2++] = AnnotationBinding.buildRetentionAnnotation(l, lookupEnvironment);
        }
        if (!bl && (l & 0x400000000000L) != 0L) {
            annotationBindingArray2[n2++] = AnnotationBinding.buildMarkerAnnotation(TypeConstants.JAVA_LANG_DEPRECATED, lookupEnvironment.javaBaseModule(), lookupEnvironment);
        }
        if ((l & 0x800000000000L) != 0L) {
            annotationBindingArray2[n2++] = AnnotationBinding.buildMarkerAnnotation(TypeConstants.JAVA_LANG_ANNOTATION_DOCUMENTED, lookupEnvironment.javaBaseModule(), lookupEnvironment);
        }
        if ((l & 0x1000000000000L) != 0L) {
            annotationBindingArray2[n2++] = AnnotationBinding.buildMarkerAnnotation(TypeConstants.JAVA_LANG_ANNOTATION_INHERITED, lookupEnvironment.javaBaseModule(), lookupEnvironment);
        }
        if ((l & 0x2000000000000L) != 0L) {
            annotationBindingArray2[n2++] = AnnotationBinding.buildMarkerAnnotation(TypeConstants.JAVA_LANG_OVERRIDE, lookupEnvironment.javaBaseModule(), lookupEnvironment);
        }
        if ((l & 0x4000000000000L) != 0L) {
            annotationBindingArray2[n2++] = AnnotationBinding.buildMarkerAnnotation(TypeConstants.JAVA_LANG_SUPPRESSWARNINGS, lookupEnvironment.javaBaseModule(), lookupEnvironment);
        }
        if ((l & 0x10000000000000L) != 0L) {
            annotationBindingArray2[n2++] = AnnotationBinding.buildMarkerAnnotationForMemberType(TypeConstants.JAVA_LANG_INVOKE_METHODHANDLE_$_POLYMORPHICSIGNATURE, lookupEnvironment.javaBaseModule(), lookupEnvironment);
        }
        if ((l & 0x8000000000000L) != 0L) {
            annotationBindingArray2[n2++] = AnnotationBinding.buildMarkerAnnotation(TypeConstants.JAVA_LANG_SAFEVARARGS, lookupEnvironment.javaBaseModule(), lookupEnvironment);
        }
        return annotationBindingArray2;
    }

    private static AnnotationBinding buildMarkerAnnotationForMemberType(char[][] cArray, ModuleBinding moduleBinding, LookupEnvironment lookupEnvironment) {
        ReferenceBinding referenceBinding = lookupEnvironment.getResolvedType(cArray, moduleBinding, null);
        if (!referenceBinding.isValidBinding()) {
            referenceBinding = ((ProblemReferenceBinding)referenceBinding).closestMatch;
        }
        return lookupEnvironment.createAnnotation(referenceBinding, Binding.NO_ELEMENT_VALUE_PAIRS);
    }

    private static AnnotationBinding buildMarkerAnnotation(char[][] cArray, ModuleBinding moduleBinding, LookupEnvironment lookupEnvironment) {
        ReferenceBinding referenceBinding = lookupEnvironment.getResolvedType(cArray, moduleBinding, null);
        return lookupEnvironment.createAnnotation(referenceBinding, Binding.NO_ELEMENT_VALUE_PAIRS);
    }

    private static AnnotationBinding buildRetentionAnnotation(long l, LookupEnvironment lookupEnvironment) {
        ReferenceBinding referenceBinding = lookupEnvironment.getResolvedJavaBaseType(TypeConstants.JAVA_LANG_ANNOTATION_RETENTIONPOLICY, null);
        FieldBinding fieldBinding = null;
        if ((l & 0x300000000000L) == 0x300000000000L) {
            fieldBinding = referenceBinding.getField(TypeConstants.UPPER_RUNTIME, true);
        } else if ((l & 0x200000000000L) != 0L) {
            fieldBinding = referenceBinding.getField(TypeConstants.UPPER_CLASS, true);
        } else if ((l & 0x100000000000L) != 0L) {
            fieldBinding = referenceBinding.getField(TypeConstants.UPPER_SOURCE, true);
        }
        return lookupEnvironment.createAnnotation(lookupEnvironment.getResolvedJavaBaseType(TypeConstants.JAVA_LANG_ANNOTATION_RETENTION, null), new ElementValuePair[]{new ElementValuePair(TypeConstants.VALUE, fieldBinding, null)});
    }

    private static AnnotationBinding buildTargetAnnotation(long l, LookupEnvironment lookupEnvironment) {
        ReferenceBinding referenceBinding = lookupEnvironment.getResolvedJavaBaseType(TypeConstants.JAVA_LANG_ANNOTATION_TARGET, null);
        if ((l & 0x800000000L) != 0L) {
            return new AnnotationBinding(referenceBinding, Binding.NO_ELEMENT_VALUE_PAIRS);
        }
        int n = 0;
        if ((l & 0x40000000000L) != 0L) {
            ++n;
        }
        if ((l & 0x10000000000L) != 0L) {
            ++n;
        }
        if ((l & 0x2000000000L) != 0L) {
            ++n;
        }
        if ((l & 0x20000000000L) != 0L) {
            ++n;
        }
        if ((l & 0x4000000000L) != 0L) {
            ++n;
        }
        if ((l & 0x80000000000L) != 0L) {
            ++n;
        }
        if ((l & 0x8000000000L) != 0L) {
            ++n;
        }
        if ((l & 0x1000000000L) != 0L) {
            ++n;
        }
        if ((l & 0x20000000000000L) != 0L) {
            ++n;
        }
        if ((l & 0x40000000000000L) != 0L) {
            ++n;
        }
        if ((l & 0x2000000000000000L) != 0L) {
            ++n;
        }
        Object[] objectArray = new Object[n];
        if (n > 0) {
            ReferenceBinding referenceBinding2 = lookupEnvironment.getResolvedType(TypeConstants.JAVA_LANG_ANNOTATION_ELEMENTTYPE, null);
            int n2 = 0;
            if ((l & 0x20000000000000L) != 0L) {
                objectArray[n2++] = referenceBinding2.getField(TypeConstants.TYPE_USE_TARGET, true);
            }
            if ((l & 0x40000000000L) != 0L) {
                objectArray[n2++] = referenceBinding2.getField(TypeConstants.UPPER_ANNOTATION_TYPE, true);
            }
            if ((l & 0x10000000000L) != 0L) {
                objectArray[n2++] = referenceBinding2.getField(TypeConstants.UPPER_CONSTRUCTOR, true);
            }
            if ((l & 0x2000000000L) != 0L) {
                objectArray[n2++] = referenceBinding2.getField(TypeConstants.UPPER_FIELD, true);
            }
            if ((l & 0x4000000000L) != 0L) {
                objectArray[n2++] = referenceBinding2.getField(TypeConstants.UPPER_METHOD, true);
            }
            if ((l & 0x80000000000L) != 0L) {
                objectArray[n2++] = referenceBinding2.getField(TypeConstants.UPPER_PACKAGE, true);
            }
            if ((l & 0x8000000000L) != 0L) {
                objectArray[n2++] = referenceBinding2.getField(TypeConstants.UPPER_PARAMETER, true);
            }
            if ((l & 0x40000000000000L) != 0L) {
                objectArray[n2++] = referenceBinding2.getField(TypeConstants.TYPE_PARAMETER_TARGET, true);
            }
            if ((l & 0x1000000000L) != 0L) {
                objectArray[n2++] = referenceBinding2.getField(TypeConstants.TYPE, true);
            }
            if ((l & 0x20000000000L) != 0L) {
                objectArray[n2++] = referenceBinding2.getField(TypeConstants.UPPER_LOCAL_VARIABLE, true);
            }
        }
        return lookupEnvironment.createAnnotation(referenceBinding, new ElementValuePair[]{new ElementValuePair(TypeConstants.VALUE, objectArray, null)});
    }

    public AnnotationBinding(ReferenceBinding referenceBinding, ElementValuePair[] elementValuePairArray) {
        this.type = referenceBinding;
        this.pairs = elementValuePairArray;
    }

    AnnotationBinding(Annotation annotation) {
        this((ReferenceBinding)annotation.resolvedType, annotation.computeElementValuePairs());
    }

    public char[] computeUniqueKey(char[] cArray) {
        char[] cArray2 = this.type.computeUniqueKey(false);
        int n = cArray.length;
        char[] cArray3 = new char[n + 1 + cArray2.length];
        System.arraycopy(cArray, 0, cArray3, 0, n);
        cArray3[n] = 64;
        System.arraycopy(cArray2, 0, cArray3, n + 1, cArray2.length);
        return cArray3;
    }

    public ReferenceBinding getAnnotationType() {
        return this.type;
    }

    public void resolve() {
    }

    public ElementValuePair[] getElementValuePairs() {
        return this.pairs;
    }

    public static void setMethodBindings(ReferenceBinding referenceBinding, ElementValuePair[] elementValuePairArray) {
        int n = elementValuePairArray.length;
        while (--n >= 0) {
            ElementValuePair elementValuePair = elementValuePairArray[n];
            MethodBinding[] methodBindingArray = referenceBinding.getMethods(elementValuePair.getName());
            if (methodBindingArray == null || methodBindingArray.length != 1) continue;
            elementValuePair.setMethodBinding(methodBindingArray[0]);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5);
        stringBuffer.append('@').append(this.type.sourceName);
        if (this.pairs != null && this.pairs.length > 0) {
            stringBuffer.append('(');
            if (this.pairs.length == 1 && CharOperation.equals(this.pairs[0].getName(), TypeConstants.VALUE)) {
                stringBuffer.append(this.pairs[0].value);
            } else {
                int n = this.pairs.length;
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.pairs[i]);
                }
            }
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 17;
        int n2 = this.getAnnotationType().hashCode();
        n = 31 * n + n2;
        n2 = Arrays.hashCode(this.getElementValuePairs());
        n = 31 * n + n2;
        return n;
    }

    public boolean equals(Object object) {
        ElementValuePair[] elementValuePairArray;
        if (this == object) {
            return true;
        }
        if (!(object instanceof AnnotationBinding)) {
            return false;
        }
        AnnotationBinding annotationBinding = (AnnotationBinding)object;
        if (this.getAnnotationType() != annotationBinding.getAnnotationType()) {
            return false;
        }
        ElementValuePair[] elementValuePairArray2 = this.getElementValuePairs();
        int n = elementValuePairArray2.length;
        if (n != (elementValuePairArray = annotationBinding.getElementValuePairs()).length) {
            return false;
        }
        block0: for (int i = 0; i < n; ++i) {
            ElementValuePair elementValuePair = elementValuePairArray2[i];
            for (int j = 0; j < n; ++j) {
                ElementValuePair elementValuePair2 = elementValuePairArray[j];
                if (elementValuePair.binding != elementValuePair2.binding) continue;
                if (elementValuePair.value == null) {
                    if (elementValuePair2.value == null) continue block0;
                    return false;
                }
                if (elementValuePair2.value == null) {
                    return false;
                }
                if (!(elementValuePair2.value instanceof Object[] && elementValuePair.value instanceof Object[] ? !Arrays.equals((Object[])elementValuePair.value, (Object[])elementValuePair2.value) : !elementValuePair2.value.equals(elementValuePair.value))) continue block0;
                return false;
            }
            return false;
        }
        return true;
    }
}

