/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;

public class SplitPackageBinding
extends PackageBinding {
    Set<ModuleBinding> declaringModules = new HashSet<ModuleBinding>();
    public Set<PackageBinding> incarnations = new HashSet<PackageBinding>();

    public static PackageBinding combine(PackageBinding packageBinding, PackageBinding packageBinding2, ModuleBinding moduleBinding) {
        int n;
        int n2 = SplitPackageBinding.rank(packageBinding2);
        if (n2 < (n = SplitPackageBinding.rank(packageBinding))) {
            return packageBinding;
        }
        if (n2 > n) {
            return packageBinding2;
        }
        if (packageBinding2 == null) {
            return null;
        }
        if (packageBinding2.subsumes(packageBinding)) {
            return packageBinding2;
        }
        if (packageBinding.subsumes(packageBinding2)) {
            return packageBinding;
        }
        SplitPackageBinding splitPackageBinding = new SplitPackageBinding(packageBinding2, moduleBinding);
        splitPackageBinding.add(packageBinding);
        return splitPackageBinding;
    }

    private static int rank(PackageBinding packageBinding) {
        if (packageBinding == null) {
            return 0;
        }
        if (packageBinding == LookupEnvironment.TheNotFoundPackage) {
            return 1;
        }
        if (!packageBinding.isValidBinding()) {
            return 2;
        }
        return 3;
    }

    public SplitPackageBinding(PackageBinding packageBinding, ModuleBinding moduleBinding) {
        super(packageBinding.compoundName, packageBinding.parent, moduleBinding.environment, moduleBinding);
        this.add(packageBinding);
    }

    public void add(PackageBinding packageBinding) {
        if (packageBinding instanceof SplitPackageBinding) {
            SplitPackageBinding splitPackageBinding = (SplitPackageBinding)packageBinding;
            this.declaringModules.addAll(splitPackageBinding.declaringModules);
            for (PackageBinding packageBinding2 : splitPackageBinding.incarnations) {
                if (!this.incarnations.add(packageBinding2)) continue;
                packageBinding2.addWrappingSplitPackageBinding(this);
            }
        } else {
            this.declaringModules.add(packageBinding.enclosingModule);
            if (this.incarnations.add(packageBinding)) {
                packageBinding.addWrappingSplitPackageBinding(this);
            }
        }
    }

    PackageBinding addPackage(PackageBinding packageBinding, ModuleBinding moduleBinding) {
        return this.addPackage(packageBinding, moduleBinding, true);
    }

    @Override
    PackageBinding addPackage(PackageBinding packageBinding, ModuleBinding moduleBinding, boolean bl) {
        char[] cArray = packageBinding.compoundName[packageBinding.compoundName.length - 1];
        if (bl) {
            packageBinding = this.combineWithSiblings(packageBinding, cArray, moduleBinding);
        }
        PackageBinding packageBinding2 = this.knownPackages.get(cArray);
        packageBinding2 = SplitPackageBinding.combine(packageBinding, packageBinding2, this.enclosingModule);
        this.knownPackages.put(cArray, packageBinding2);
        PackageBinding packageBinding3 = this.getIncarnation(packageBinding.enclosingModule);
        if (packageBinding3 != null) {
            packageBinding3.addPackage(packageBinding, moduleBinding, bl);
        }
        return packageBinding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackageBinding combineWithSiblings(PackageBinding packageBinding, char[] cArray, ModuleBinding moduleBinding) {
        ModuleBinding moduleBinding2 = packageBinding != null ? packageBinding.enclosingModule : this.enclosingModule;
        boolean bl = moduleBinding2.isPackageLookupActive;
        moduleBinding2.isPackageLookupActive = true;
        try {
            for (PackageBinding packageBinding2 : this.incarnations) {
                ModuleBinding moduleBinding3 = packageBinding2.enclosingModule;
                if (moduleBinding3 == moduleBinding) continue;
                PackageBinding packageBinding3 = moduleBinding3.getVisiblePackage(packageBinding2, cArray, false);
                packageBinding = SplitPackageBinding.combine(packageBinding3, packageBinding, moduleBinding2);
            }
            PackageBinding packageBinding4 = packageBinding;
            return packageBinding4;
        }
        finally {
            moduleBinding2.isPackageLookupActive = bl;
        }
    }

    @Override
    ModuleBinding[] getDeclaringModules() {
        return this.declaringModules.toArray(new ModuleBinding[this.declaringModules.size()]);
    }

    @Override
    PackageBinding getPackage0(char[] cArray) {
        PackageBinding packageBinding = super.getPackage0(cArray);
        if (packageBinding != null) {
            return packageBinding;
        }
        PackageBinding packageBinding2 = null;
        for (PackageBinding packageBinding3 : this.incarnations) {
            PackageBinding packageBinding4 = packageBinding3.getPackage0(cArray);
            if (packageBinding4 == null) {
                return null;
            }
            packageBinding2 = SplitPackageBinding.combine(packageBinding4, packageBinding2, this.enclosingModule);
        }
        if (packageBinding2 != null) {
            this.knownPackages.put(cArray, packageBinding2);
        }
        return packageBinding2;
    }

    @Override
    PackageBinding getPackage0Any(char[] cArray) {
        PackageBinding packageBinding = super.getPackage0(cArray);
        if (packageBinding != null) {
            return packageBinding;
        }
        PackageBinding packageBinding2 = null;
        for (PackageBinding packageBinding3 : this.incarnations) {
            PackageBinding packageBinding4 = packageBinding3.getPackage0(cArray);
            if (packageBinding4 == null) continue;
            packageBinding2 = SplitPackageBinding.combine(packageBinding4, packageBinding2, this.enclosingModule);
        }
        return packageBinding2;
    }

    @Override
    protected PackageBinding findPackage(char[] cArray, ModuleBinding moduleBinding) {
        Object object;
        Binding binding2;
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Binding binding2 : this.declaringModules) {
            object = super.findPackage(cArray, (ModuleBinding)binding2);
            if (object == null || object == LookupEnvironment.TheNotFoundPackage || (((PackageBinding)object).tagBits & 0x80L) != 0L) continue;
            hashSet.add(object);
        }
        int n = hashSet.size();
        binding2 = null;
        if (n == 1) {
            binding2 = (PackageBinding)hashSet.iterator().next();
        } else if (n > 1) {
            object = hashSet.iterator();
            SplitPackageBinding splitPackageBinding = new SplitPackageBinding((PackageBinding)object.next(), this.enclosingModule);
            while (object.hasNext()) {
                splitPackageBinding.add((PackageBinding)object.next());
            }
            binding2 = splitPackageBinding;
        }
        if (binding2 == null) {
            this.addNotFoundPackage(cArray);
        } else {
            this.addPackage((PackageBinding)binding2, moduleBinding);
        }
        return binding2;
    }

    public PackageBinding getIncarnation(ModuleBinding moduleBinding) {
        for (PackageBinding packageBinding : this.incarnations) {
            if (packageBinding.enclosingModule != moduleBinding) continue;
            return packageBinding;
        }
        return null;
    }

    @Override
    public boolean subsumes(PackageBinding packageBinding) {
        if (!CharOperation.equals(this.compoundName, packageBinding.compoundName)) {
            return false;
        }
        if (packageBinding instanceof SplitPackageBinding) {
            return this.declaringModules.containsAll(((SplitPackageBinding)packageBinding).declaringModules);
        }
        return this.declaringModules.contains(packageBinding.enclosingModule);
    }

    @Override
    ReferenceBinding getType0(char[] cArray) {
        ReferenceBinding referenceBinding = super.getType0(cArray);
        if (referenceBinding != null) {
            return referenceBinding;
        }
        ReferenceBinding referenceBinding2 = null;
        for (PackageBinding packageBinding : this.incarnations) {
            ReferenceBinding referenceBinding3 = packageBinding.getType0(cArray);
            if (referenceBinding3 == null || !referenceBinding3.isValidBinding()) continue;
            if (referenceBinding2 != null) {
                return null;
            }
            referenceBinding2 = referenceBinding3;
        }
        if (referenceBinding2 != null) {
            this.addType(referenceBinding2);
        }
        return referenceBinding2;
    }

    ReferenceBinding getType0ForModule(ModuleBinding moduleBinding, char[] cArray) {
        if (this.declaringModules.contains(moduleBinding)) {
            return this.getIncarnation(moduleBinding).getType0(cArray);
        }
        return null;
    }

    @Override
    ReferenceBinding getType(char[] cArray, ModuleBinding moduleBinding) {
        ReferenceBinding referenceBinding = null;
        boolean bl = false;
        for (PackageBinding packageBinding : this.incarnations) {
            ReferenceBinding referenceBinding2 = packageBinding.getType(cArray, moduleBinding);
            if (referenceBinding2 == null) continue;
            if (referenceBinding == null || !bl) {
                referenceBinding = referenceBinding2;
                bl = moduleBinding.canAccess(packageBinding);
                continue;
            }
            if (!moduleBinding.canAccess(packageBinding)) continue;
            return new ProblemReferenceBinding(referenceBinding2.compoundName, referenceBinding, 3);
        }
        if (referenceBinding != null && !bl) {
            return new ProblemReferenceBinding(referenceBinding.compoundName, referenceBinding, 30);
        }
        return referenceBinding;
    }

    @Override
    public boolean isDeclaredIn(ModuleBinding moduleBinding) {
        return this.declaringModules.contains(moduleBinding);
    }

    @Override
    public PackageBinding getVisibleFor(ModuleBinding moduleBinding) {
        int n = 0;
        PackageBinding packageBinding = null;
        for (PackageBinding packageBinding2 : this.incarnations) {
            if (!packageBinding2.hasCompilationUnit(false)) continue;
            if (packageBinding2.enclosingModule == moduleBinding) {
                return packageBinding2;
            }
            if (!moduleBinding.canAccess(packageBinding2)) continue;
            if (++n > 1) {
                return this;
            }
            packageBinding = packageBinding2;
        }
        return packageBinding;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append(" (from ");
        String string = "";
        for (ModuleBinding moduleBinding : this.declaringModules) {
            stringBuilder.append(string).append(moduleBinding.readableName());
            string = ", ";
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

