/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.util.JrtFileSystem;

public class JRTUtil {
    public static final String JAVA_BASE = "java.base";
    public static final char[] JAVA_BASE_CHAR = "java.base".toCharArray();
    static final String MODULES_SUBDIR = "/modules";
    static final String[] DEFAULT_MODULE = new String[]{"java.base"};
    static final String[] NO_MODULE = new String[0];
    static final String MULTIPLE = "MU";
    static final String DEFAULT_PACKAGE = "";
    static String MODULE_TO_LOAD = null;
    public static final String JRT_FS_JAR = "jrt-fs.jar";
    static URI JRT_URI = URI.create("jrt:/");
    public static int NOTIFY_FILES = 1;
    public static int NOTIFY_PACKAGES = 2;
    public static int NOTIFY_MODULES = 4;
    public static int NOTIFY_ALL = NOTIFY_FILES | NOTIFY_PACKAGES | NOTIFY_MODULES;
    private static Map<File, JrtFileSystem> images = null;
    private static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JrtFileSystem getJrtSystem(File file) {
        Object object;
        Map<File, JrtFileSystem> map = images;
        if (images == null) {
            object = lock;
            synchronized (object) {
                map = images;
                if (map == null) {
                    images = map = new HashMap<File, JrtFileSystem>();
                }
            }
        }
        object = null;
        Map<File, JrtFileSystem> map2 = map;
        synchronized (map2) {
            object = images.get(file);
            if (object == null) {
                try {
                    object = new JrtFileSystem(file);
                    images.put(file, (JrtFileSystem)object);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return object;
    }

    public static void reset() {
        images = null;
        MODULE_TO_LOAD = System.getProperty("modules.to.load");
    }

    public static void walkModuleImage(File file, JrtFileVisitor<Path> jrtFileVisitor, int n) throws IOException {
        JRTUtil.getJrtSystem(file).walkModuleImage(jrtFileVisitor, false, n);
    }

    public static InputStream getContentFromJrt(File file, String string, String string2) throws IOException {
        return JRTUtil.getJrtSystem(file).getContentFromJrt(string, string2);
    }

    public static byte[] getClassfileContent(File file, String string, String string2) throws IOException, ClassFormatException {
        return JRTUtil.getJrtSystem(file).getClassfileContent(string, string2);
    }

    public static ClassFileReader getClassfile(File file, String string, IModule iModule) throws IOException, ClassFormatException {
        return JRTUtil.getJrtSystem(file).getClassfile(string, iModule);
    }

    public static ClassFileReader getClassfile(File file, String string, String string2, Predicate<String> predicate) throws IOException, ClassFormatException {
        return JRTUtil.getJrtSystem(file).getClassfile(string, string2, predicate);
    }

    public static List<String> getModulesDeclaringPackage(File file, String string, String string2) {
        return JRTUtil.getJrtSystem(file).getModulesDeclaringPackage(string, string2);
    }

    public static boolean hasCompilationUnit(File file, String string, String string2) {
        return JRTUtil.getJrtSystem(file).hasClassFile(string, string2);
    }

    public static byte[] safeReadBytes(Path path) throws IOException {
        try {
            return Files.readAllBytes(path);
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            return null;
        }
        catch (NoSuchFileException noSuchFileException) {
            return null;
        }
    }

    static abstract class AbstractFileVisitor<T>
    implements FileVisitor<T> {
        AbstractFileVisitor() {
        }

        @Override
        public FileVisitResult preVisitDirectory(T t, BasicFileAttributes basicFileAttributes) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(T t, BasicFileAttributes basicFileAttributes) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(T t, IOException iOException) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(T t, IOException iOException) throws IOException {
            return FileVisitResult.CONTINUE;
        }
    }

    public static interface JrtFileVisitor<T> {
        public FileVisitResult visitPackage(T var1, T var2, BasicFileAttributes var3) throws IOException;

        public FileVisitResult visitFile(T var1, T var2, BasicFileAttributes var3) throws IOException;

        public FileVisitResult visitModule(T var1) throws IOException;
    }
}

