/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.model.ElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.Factory;
import org.eclipse.jdt.internal.compiler.apt.model.NameImpl;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.SplitPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ModuleElementImpl
extends ElementImpl
implements ModuleElement {
    ModuleBinding binding;
    private List<ModuleElement.Directive> directives;
    private static List<ModuleElement.Directive> EMPTY_DIRECTIVES = Collections.emptyList();

    ModuleElementImpl(BaseProcessingEnvImpl baseProcessingEnvImpl, ModuleBinding moduleBinding) {
        super(baseProcessingEnvImpl, moduleBinding);
        this.binding = moduleBinding;
    }

    private PackageBinding getModulesPackageBinding(PackageBinding packageBinding) {
        if (packageBinding instanceof SplitPackageBinding) {
            return ((SplitPackageBinding)packageBinding).getIncarnation(this.binding);
        }
        return packageBinding;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.MODULE;
    }

    @Override
    public Set<Modifier> getModifiers() {
        int n = this.binding.modifiers;
        return Factory.getModifiers(n, this.getKind(), false);
    }

    @Override
    public Name getQualifiedName() {
        return new NameImpl(this.binding.moduleName);
    }

    @Override
    public Name getSimpleName() {
        return new NameImpl(this.binding.moduleName);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<? extends Element> getEnclosedElements() {
        void packageBinding;
        ModuleBinding moduleBinding = this.binding;
        PackageBinding[] packageBindingArray = moduleBinding.declaredPackages.valueTable;
        HashSet<Object> hashSet = new HashSet<Object>();
        Object object = packageBindingArray;
        int n = ((PackageBinding[])object).length;
        boolean bl = false;
        while (packageBinding < n) {
            PackageBinding packageBinding2 = object[packageBinding];
            if (packageBinding2 != null && packageBinding2.hasCompilationUnit(true)) {
                hashSet.add(this.getModulesPackageBinding(packageBinding2));
            }
            ++packageBinding;
        }
        if (moduleBinding.isUnnamed()) {
            object = moduleBinding.environment.defaultPackage;
            if (object != null && ((PackageBinding)object).hasCompilationUnit(true)) {
                hashSet.add(object);
            }
        } else {
            void var6_12;
            void var6_10;
            packageBindingArray = this.binding.getExports();
            object = packageBindingArray;
            n = ((PackageBinding[])object).length;
            boolean bl2 = false;
            while (var6_10 < n) {
                Object object2 = object[var6_10];
                hashSet.add(this.getModulesPackageBinding((PackageBinding)object2));
                ++var6_10;
            }
            packageBindingArray = this.binding.getOpens();
            object = packageBindingArray;
            n = ((Object)object).length;
            boolean bl3 = false;
            while (var6_12 < n) {
                Object object3 = object[var6_12];
                hashSet.add(this.getModulesPackageBinding((PackageBinding)object3));
                ++var6_12;
            }
        }
        object = new ArrayList(hashSet.size());
        for (PackageBinding packageBinding3 : hashSet) {
            PackageElement packageElement = (PackageElement)this._env.getFactory().newElement(packageBinding3);
            object.add(packageElement);
        }
        return Collections.unmodifiableList(object);
    }

    @Override
    public boolean isOpen() {
        return (this.binding.modifiers & 0x20) != 0;
    }

    @Override
    public boolean isUnnamed() {
        return this.binding.moduleName.length == 0;
    }

    @Override
    public Element getEnclosingElement() {
        return null;
    }

    @Override
    public List<? extends ModuleElement.Directive> getDirectives() {
        if (this.isUnnamed()) {
            return EMPTY_DIRECTIVES;
        }
        if (this.directives == null) {
            this.directives = new ArrayList<ModuleElement.Directive>();
        }
        PackageBinding[] packageBindingArray = this.binding.getExports();
        for (PackageBinding packageBinding : packageBindingArray) {
            packageBinding = this.getModulesPackageBinding(packageBinding);
            this.directives.add(new ExportsDirectiveImpl(packageBinding));
        }
        HashSet hashSet = new HashSet();
        for (ModuleBinding moduleBinding : this.binding.getRequiresTransitive()) {
            hashSet.add(moduleBinding);
        }
        ModuleBinding[] moduleBindingArray = this.binding.getRequires();
        Binding[] bindingArray = moduleBindingArray;
        int n = bindingArray.length;
        for (int i = 0; i < n; ++i) {
            ModuleBinding moduleBinding = bindingArray[i];
            if (hashSet.contains(moduleBinding)) {
                this.directives.add(new RequiresDirectiveImpl(moduleBinding, true));
                continue;
            }
            this.directives.add(new RequiresDirectiveImpl(moduleBinding, false));
        }
        for (Binding binding : bindingArray = this.binding.getUses()) {
            this.directives.add(new UsesDirectiveImpl((TypeBinding)binding));
        }
        for (Binding binding : bindingArray = this.binding.getServices()) {
            this.directives.add(new ProvidesDirectiveImpl((TypeBinding)binding));
        }
        packageBindingArray = this.binding.getOpens();
        for (Binding binding : packageBindingArray) {
            PackageBinding packageBinding = this.getModulesPackageBinding((PackageBinding)binding);
            this.directives.add(new OpensDirectiveImpl(packageBinding));
        }
        return this.directives;
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> elementVisitor, P p) {
        return elementVisitor.visitModule(this, p);
    }

    @Override
    protected AnnotationBinding[] getAnnotationBindings() {
        return ((ModuleBinding)this._binding).getAnnotations();
    }

    class ProvidesDirectiveImpl
    implements ModuleElement.ProvidesDirective {
        TypeBinding service;
        public List<? extends TypeElement> implementations;

        ProvidesDirectiveImpl(TypeBinding typeBinding) {
            this.service = typeBinding;
        }

        @Override
        public <R, P> R accept(ModuleElement.DirectiveVisitor<R, P> directiveVisitor, P p) {
            return directiveVisitor.visitProvides(this, p);
        }

        @Override
        public ModuleElement.DirectiveKind getKind() {
            return ModuleElement.DirectiveKind.PROVIDES;
        }

        @Override
        public List<? extends TypeElement> getImplementations() {
            if (this.implementations != null) {
                return this.implementations;
            }
            TypeBinding[] typeBindingArray = ModuleElementImpl.this.binding.getImplementations(this.service);
            if (typeBindingArray.length == 0) {
                this.implementations = Collections.emptyList();
                return this.implementations;
            }
            ArrayList<TypeElement> arrayList = new ArrayList<TypeElement>(typeBindingArray.length);
            Factory factory = ModuleElementImpl.this._env.getFactory();
            for (TypeBinding typeBinding : typeBindingArray) {
                TypeElement typeElement = (TypeElement)factory.newElement(typeBinding);
                arrayList.add(typeElement);
            }
            return Collections.unmodifiableList(arrayList);
        }

        @Override
        public TypeElement getService() {
            return (TypeElement)ModuleElementImpl.this._env.getFactory().newElement(this.service);
        }
    }

    class UsesDirectiveImpl
    implements ModuleElement.UsesDirective {
        TypeBinding binding = null;

        UsesDirectiveImpl(TypeBinding typeBinding) {
            this.binding = typeBinding;
        }

        @Override
        public <R, P> R accept(ModuleElement.DirectiveVisitor<R, P> directiveVisitor, P p) {
            return directiveVisitor.visitUses(this, p);
        }

        @Override
        public ModuleElement.DirectiveKind getKind() {
            return ModuleElement.DirectiveKind.USES;
        }

        @Override
        public TypeElement getService() {
            return (TypeElement)ModuleElementImpl.this._env.getFactory().newElement(this.binding);
        }
    }

    class OpensDirectiveImpl
    extends PackageDirectiveImpl
    implements ModuleElement.OpensDirective {
        OpensDirectiveImpl(PackageBinding packageBinding) {
            super(packageBinding);
        }

        @Override
        public <R, P> R accept(ModuleElement.DirectiveVisitor<R, P> directiveVisitor, P p) {
            return directiveVisitor.visitOpens(this, p);
        }

        @Override
        public ModuleElement.DirectiveKind getKind() {
            return ModuleElement.DirectiveKind.OPENS;
        }

        @Override
        public List<? extends ModuleElement> getTargetModules() {
            if (this.targets != null) {
                return this.targets;
            }
            return this.getTargetModules(ModuleElementImpl.this.binding.getOpenRestrictions(this.binding));
        }
    }

    class RequiresDirectiveImpl
    implements ModuleElement.RequiresDirective {
        ModuleBinding dependency;
        boolean transitive;

        RequiresDirectiveImpl(ModuleBinding moduleBinding, boolean bl) {
            this.dependency = moduleBinding;
            this.transitive = bl;
        }

        @Override
        public <R, P> R accept(ModuleElement.DirectiveVisitor<R, P> directiveVisitor, P p) {
            return directiveVisitor.visitRequires(this, p);
        }

        @Override
        public ModuleElement.DirectiveKind getKind() {
            return ModuleElement.DirectiveKind.REQUIRES;
        }

        @Override
        public ModuleElement getDependency() {
            return (ModuleElement)ModuleElementImpl.this._env.getFactory().newElement(this.dependency, ElementKind.MODULE);
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public boolean isTransitive() {
            return this.transitive;
        }
    }

    class ExportsDirectiveImpl
    extends PackageDirectiveImpl
    implements ModuleElement.ExportsDirective {
        ExportsDirectiveImpl(PackageBinding packageBinding) {
            super(packageBinding);
        }

        @Override
        public <R, P> R accept(ModuleElement.DirectiveVisitor<R, P> directiveVisitor, P p) {
            return directiveVisitor.visitExports(this, p);
        }

        @Override
        public ModuleElement.DirectiveKind getKind() {
            return ModuleElement.DirectiveKind.EXPORTS;
        }

        @Override
        public PackageElement getPackage() {
            return ModuleElementImpl.this._env.getFactory().newPackageElement(this.binding);
        }

        @Override
        public List<? extends ModuleElement> getTargetModules() {
            if (this.targets != null) {
                return this.targets;
            }
            return this.getTargetModules(ModuleElementImpl.this.binding.getExportRestrictions(this.binding));
        }
    }

    abstract class PackageDirectiveImpl {
        PackageBinding binding;
        List<ModuleElement> targets;

        PackageDirectiveImpl(PackageBinding packageBinding) {
            this.binding = packageBinding;
        }

        public PackageElement getPackage() {
            return ModuleElementImpl.this._env.getFactory().newPackageElement(this.binding);
        }

        public List<? extends ModuleElement> getTargetModules(String[] stringArray) {
            if (this.targets != null) {
                return this.targets;
            }
            if (stringArray.length == 0) {
                this.targets = null;
                return null;
            }
            ArrayList<ModuleElement> arrayList = new ArrayList<ModuleElement>(stringArray.length);
            for (String string : stringArray) {
                ModuleBinding moduleBinding = ModuleElementImpl.this.binding.environment.getModule(string.toCharArray());
                if (moduleBinding == null) continue;
                ModuleElement moduleElement = (ModuleElement)ModuleElementImpl.this._env.getFactory().newElement(moduleBinding);
                arrayList.add(moduleElement);
            }
            this.targets = Collections.unmodifiableList(arrayList);
            return this.targets;
        }
    }
}

