/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Types;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.model.DeclaredTypeImpl;
import org.eclipse.jdt.internal.compiler.apt.model.ElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.ExecutableTypeImpl;
import org.eclipse.jdt.internal.compiler.apt.model.NoTypeImpl;
import org.eclipse.jdt.internal.compiler.apt.model.PrimitiveTypeImpl;
import org.eclipse.jdt.internal.compiler.apt.model.TypeElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.TypeMirrorImpl;
import org.eclipse.jdt.internal.compiler.apt.model.WildcardTypeImpl;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class TypesImpl
implements Types {
    private final BaseProcessingEnvImpl _env;

    public TypesImpl(BaseProcessingEnvImpl baseProcessingEnvImpl) {
        this._env = baseProcessingEnvImpl;
    }

    @Override
    public Element asElement(TypeMirror typeMirror) {
        switch (typeMirror.getKind()) {
            case DECLARED: 
            case TYPEVAR: {
                return this._env.getFactory().newElement(((TypeMirrorImpl)typeMirror).binding());
            }
        }
        return null;
    }

    @Override
    public TypeMirror asMemberOf(DeclaredType declaredType, Element element) {
        ElementImpl elementImpl = (ElementImpl)element;
        DeclaredTypeImpl declaredTypeImpl = (DeclaredTypeImpl)declaredType;
        ReferenceBinding referenceBinding = (ReferenceBinding)declaredTypeImpl._binding;
        switch (element.getKind()) {
            case CONSTRUCTOR: 
            case METHOD: {
                TypeMirror typeMirror = this.findMemberInHierarchy(referenceBinding, elementImpl._binding, new MemberInTypeFinder(){

                    @Override
                    public TypeMirror find(ReferenceBinding referenceBinding, Binding binding) {
                        MethodBinding methodBinding = (MethodBinding)binding;
                        for (MethodBinding methodBinding2 : referenceBinding.methods()) {
                            if (!CharOperation.equals(methodBinding2.selector, methodBinding.selector) || methodBinding2.original() != methodBinding && !methodBinding2.areParameterErasuresEqual(methodBinding)) continue;
                            return TypesImpl.this._env.getFactory().newTypeMirror(methodBinding2);
                        }
                        return null;
                    }
                });
                if (typeMirror == null) break;
                return typeMirror;
            }
            case TYPE_PARAMETER: {
                TypeMirror typeMirror = this.findMemberInHierarchy(referenceBinding, elementImpl._binding, new MemberInTypeFinder(){

                    @Override
                    public TypeMirror find(ReferenceBinding referenceBinding, Binding binding) {
                        if (referenceBinding instanceof ParameterizedTypeBinding) {
                            TypeBinding[] typeBindingArray;
                            TypeVariableBinding[] typeVariableBindingArray;
                            TypeVariableBinding typeVariableBinding = (TypeVariableBinding)binding;
                            ReferenceBinding referenceBinding2 = ((ParameterizedTypeBinding)referenceBinding).genericType();
                            if (typeVariableBinding.declaringElement == referenceBinding2 && (typeVariableBindingArray = referenceBinding2.typeVariables()).length == (typeBindingArray = ((ParameterizedTypeBinding)referenceBinding).typeArguments()).length) {
                                for (int i = 0; i < typeVariableBindingArray.length; ++i) {
                                    if (typeVariableBindingArray[i] != binding) continue;
                                    return TypesImpl.this._env.getFactory().newTypeMirror(typeBindingArray[i]);
                                }
                            }
                        }
                        return null;
                    }
                });
                if (typeMirror == null) break;
                return typeMirror;
            }
            case FIELD: 
            case ENUM_CONSTANT: {
                TypeMirror typeMirror = this.findMemberInHierarchy(referenceBinding, elementImpl._binding, new MemberInTypeFinder(){

                    @Override
                    public TypeMirror find(ReferenceBinding referenceBinding, Binding binding) {
                        FieldBinding fieldBinding = (FieldBinding)binding;
                        for (FieldBinding fieldBinding2 : referenceBinding.fields()) {
                            if (!CharOperation.equals(fieldBinding2.name, fieldBinding.name)) continue;
                            return TypesImpl.this._env.getFactory().newTypeMirror(fieldBinding2);
                        }
                        return null;
                    }
                });
                if (typeMirror == null) break;
                return typeMirror;
            }
            case ENUM: 
            case ANNOTATION_TYPE: 
            case INTERFACE: 
            case CLASS: {
                TypeMirror typeMirror = this.findMemberInHierarchy(referenceBinding, elementImpl._binding, new MemberInTypeFinder(){

                    @Override
                    public TypeMirror find(ReferenceBinding referenceBinding, Binding binding) {
                        ReferenceBinding referenceBinding2 = (ReferenceBinding)binding;
                        for (ReferenceBinding referenceBinding3 : referenceBinding.memberTypes()) {
                            if (!CharOperation.equals(referenceBinding2.compoundName, referenceBinding3.compoundName)) continue;
                            return TypesImpl.this._env.getFactory().newTypeMirror(referenceBinding3);
                        }
                        return null;
                    }
                });
                if (typeMirror == null) break;
                return typeMirror;
            }
            default: {
                throw new IllegalArgumentException("element " + element + " has unrecognized element kind " + (Object)((Object)element.getKind()));
            }
        }
        throw new IllegalArgumentException("element " + element + " is not a member of the containing type " + declaredType + " nor any of its superclasses");
    }

    private TypeMirror findMemberInHierarchy(ReferenceBinding referenceBinding, Binding binding, MemberInTypeFinder memberInTypeFinder) {
        TypeMirror typeMirror = null;
        if (referenceBinding == null) {
            return null;
        }
        typeMirror = memberInTypeFinder.find(referenceBinding, binding);
        if (typeMirror != null) {
            return typeMirror;
        }
        typeMirror = this.findMemberInHierarchy(referenceBinding.superclass(), binding, memberInTypeFinder);
        if (typeMirror != null) {
            return typeMirror;
        }
        for (ReferenceBinding referenceBinding2 : referenceBinding.superInterfaces()) {
            typeMirror = this.findMemberInHierarchy(referenceBinding2, binding, memberInTypeFinder);
            if (typeMirror == null) continue;
            return typeMirror;
        }
        return null;
    }

    private void validateRealType(TypeMirror typeMirror) {
        switch (typeMirror.getKind()) {
            case EXECUTABLE: 
            case PACKAGE: 
            case MODULE: {
                throw new IllegalArgumentException("Executable, package and module are illegal argument for Types.contains(..)");
            }
        }
    }

    private void validateRealTypes(TypeMirror typeMirror, TypeMirror typeMirror2) {
        this.validateRealType(typeMirror);
        this.validateRealType(typeMirror2);
    }

    @Override
    public TypeElement boxedClass(PrimitiveType primitiveType) {
        PrimitiveTypeImpl primitiveTypeImpl = (PrimitiveTypeImpl)primitiveType;
        BaseTypeBinding baseTypeBinding = (BaseTypeBinding)primitiveTypeImpl._binding;
        TypeBinding typeBinding = this._env.getLookupEnvironment().computeBoxingType(baseTypeBinding);
        return (TypeElement)this._env.getFactory().newElement(typeBinding);
    }

    @Override
    public TypeMirror capture(TypeMirror typeMirror) {
        this.validateRealType(typeMirror);
        TypeMirrorImpl typeMirrorImpl = (TypeMirrorImpl)typeMirror;
        if (typeMirrorImpl._binding instanceof ParameterizedTypeBinding) {
            throw new UnsupportedOperationException("NYI: TypesImpl.capture(...)");
        }
        return typeMirror;
    }

    @Override
    public boolean contains(TypeMirror typeMirror, TypeMirror typeMirror2) {
        this.validateRealTypes(typeMirror, typeMirror2);
        throw new UnsupportedOperationException("NYI: TypesImpl.contains(" + typeMirror + ", " + typeMirror2 + ")");
    }

    @Override
    public List<? extends TypeMirror> directSupertypes(TypeMirror typeMirror) {
        this.validateRealType(typeMirror);
        TypeMirrorImpl typeMirrorImpl = (TypeMirrorImpl)typeMirror;
        Binding binding = typeMirrorImpl._binding;
        if (binding instanceof ReferenceBinding) {
            ReferenceBinding referenceBinding = (ReferenceBinding)binding;
            ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>();
            ReferenceBinding referenceBinding2 = referenceBinding.superclass();
            if (referenceBinding2 != null) {
                arrayList.add(this._env.getFactory().newTypeMirror(referenceBinding2));
            }
            for (ReferenceBinding referenceBinding3 : referenceBinding.superInterfaces()) {
                arrayList.add(this._env.getFactory().newTypeMirror(referenceBinding3));
            }
            return Collections.unmodifiableList(arrayList);
        }
        return Collections.emptyList();
    }

    @Override
    public TypeMirror erasure(TypeMirror typeMirror) {
        this.validateRealType(typeMirror);
        TypeMirrorImpl typeMirrorImpl = (TypeMirrorImpl)typeMirror;
        Binding binding = typeMirrorImpl._binding;
        if (binding instanceof ReferenceBinding) {
            TypeBinding typeBinding = ((ReferenceBinding)binding).erasure();
            if (typeBinding.isGenericType()) {
                typeBinding = this._env.getLookupEnvironment().convertToRawType(typeBinding, false);
            }
            return this._env.getFactory().newTypeMirror(typeBinding);
        }
        if (binding instanceof ArrayBinding) {
            TypeBinding typeBinding = (TypeBinding)binding;
            TypeBinding typeBinding2 = typeBinding.leafComponentType().erasure();
            if (typeBinding2.isGenericType()) {
                typeBinding2 = this._env.getLookupEnvironment().convertToRawType(typeBinding2, false);
            }
            return this._env.getFactory().newTypeMirror(this._env.getLookupEnvironment().createArrayType(typeBinding2, typeBinding.dimensions()));
        }
        return typeMirror;
    }

    @Override
    public ArrayType getArrayType(TypeMirror typeMirror) {
        TypeMirrorImpl typeMirrorImpl = (TypeMirrorImpl)typeMirror;
        TypeBinding typeBinding = (TypeBinding)typeMirrorImpl._binding;
        return (ArrayType)this._env.getFactory().newTypeMirror(this._env.getLookupEnvironment().createArrayType(typeBinding.leafComponentType(), typeBinding.dimensions() + 1));
    }

    @Override
    public DeclaredType getDeclaredType(TypeElement typeElement, TypeMirror ... typeMirrorArray) {
        int n = typeMirrorArray.length;
        TypeElementImpl typeElementImpl = (TypeElementImpl)typeElement;
        ReferenceBinding referenceBinding = (ReferenceBinding)typeElementImpl._binding;
        TypeVariableBinding[] typeVariableBindingArray = referenceBinding.typeVariables();
        int n2 = typeVariableBindingArray.length;
        if (n == 0) {
            if (referenceBinding.isGenericType()) {
                return (DeclaredType)this._env.getFactory().newTypeMirror(this._env.getLookupEnvironment().createRawType(referenceBinding, null));
            }
            return (DeclaredType)typeElement.asType();
        }
        if (n != n2) {
            throw new IllegalArgumentException("Number of typeArguments doesn't match the number of formal parameters of typeElem");
        }
        TypeBinding[] typeBindingArray = new TypeBinding[n];
        for (int i = 0; i < n; ++i) {
            TypeMirrorImpl typeMirrorImpl = (TypeMirrorImpl)typeMirrorArray[i];
            Binding binding = typeMirrorImpl._binding;
            if (!(binding instanceof TypeBinding)) {
                throw new IllegalArgumentException("Invalid type argument: " + typeMirrorImpl);
            }
            typeBindingArray[i] = (TypeBinding)binding;
        }
        ReferenceBinding referenceBinding2 = referenceBinding.enclosingType();
        if (referenceBinding2 != null) {
            referenceBinding2 = this._env.getLookupEnvironment().createRawType(referenceBinding2, null);
        }
        return (DeclaredType)this._env.getFactory().newTypeMirror(this._env.getLookupEnvironment().createParameterizedType(referenceBinding, typeBindingArray, referenceBinding2));
    }

    @Override
    public DeclaredType getDeclaredType(DeclaredType declaredType, TypeElement typeElement, TypeMirror ... typeMirrorArray) {
        int n = typeMirrorArray.length;
        TypeElementImpl typeElementImpl = (TypeElementImpl)typeElement;
        ReferenceBinding referenceBinding = (ReferenceBinding)typeElementImpl._binding;
        TypeVariableBinding[] typeVariableBindingArray = referenceBinding.typeVariables();
        int n2 = typeVariableBindingArray.length;
        DeclaredTypeImpl declaredTypeImpl = (DeclaredTypeImpl)declaredType;
        ReferenceBinding referenceBinding2 = (ReferenceBinding)declaredTypeImpl._binding;
        if (n == 0) {
            if (referenceBinding.isGenericType()) {
                return (DeclaredType)this._env.getFactory().newTypeMirror(this._env.getLookupEnvironment().createRawType(referenceBinding, referenceBinding2));
            }
            ParameterizedTypeBinding parameterizedTypeBinding = this._env.getLookupEnvironment().createParameterizedType(referenceBinding, null, referenceBinding2);
            return (DeclaredType)this._env.getFactory().newTypeMirror(parameterizedTypeBinding);
        }
        if (n != n2) {
            throw new IllegalArgumentException("Number of typeArguments doesn't match the number of formal parameters of typeElem");
        }
        TypeBinding[] typeBindingArray = new TypeBinding[n];
        for (int i = 0; i < n; ++i) {
            TypeMirrorImpl typeMirrorImpl = (TypeMirrorImpl)typeMirrorArray[i];
            Binding binding = typeMirrorImpl._binding;
            if (!(binding instanceof TypeBinding)) {
                throw new IllegalArgumentException("Invalid type for a type arguments : " + typeMirrorImpl);
            }
            typeBindingArray[i] = (TypeBinding)binding;
        }
        return (DeclaredType)this._env.getFactory().newTypeMirror(this._env.getLookupEnvironment().createParameterizedType(referenceBinding, typeBindingArray, referenceBinding2));
    }

    @Override
    public NoType getNoType(TypeKind typeKind) {
        return this._env.getFactory().getNoType(typeKind);
    }

    @Override
    public NullType getNullType() {
        return this._env.getFactory().getNullType();
    }

    @Override
    public PrimitiveType getPrimitiveType(TypeKind typeKind) {
        return this._env.getFactory().getPrimitiveType(typeKind);
    }

    @Override
    public WildcardType getWildcardType(TypeMirror typeMirror, TypeMirror typeMirror2) {
        if (typeMirror != null && typeMirror2 != null) {
            throw new IllegalArgumentException("Extends and super bounds cannot be set at the same time");
        }
        if (typeMirror != null) {
            TypeMirrorImpl typeMirrorImpl = (TypeMirrorImpl)typeMirror;
            TypeBinding typeBinding = (TypeBinding)typeMirrorImpl._binding;
            return (WildcardType)this._env.getFactory().newTypeMirror(this._env.getLookupEnvironment().createWildcard(null, 0, typeBinding, null, 1));
        }
        if (typeMirror2 != null) {
            TypeMirrorImpl typeMirrorImpl = (TypeMirrorImpl)typeMirror2;
            TypeBinding typeBinding = (TypeBinding)typeMirrorImpl._binding;
            return new WildcardTypeImpl(this._env, this._env.getLookupEnvironment().createWildcard(null, 0, typeBinding, null, 2));
        }
        return new WildcardTypeImpl(this._env, this._env.getLookupEnvironment().createWildcard(null, 0, null, null, 0));
    }

    @Override
    public boolean isAssignable(TypeMirror typeMirror, TypeMirror typeMirror2) {
        this.validateRealTypes(typeMirror, typeMirror2);
        if (!(typeMirror instanceof TypeMirrorImpl) || !(typeMirror2 instanceof TypeMirrorImpl)) {
            return false;
        }
        Binding binding = ((TypeMirrorImpl)typeMirror).binding();
        Binding binding2 = ((TypeMirrorImpl)typeMirror2).binding();
        if (!(binding instanceof TypeBinding) || !(binding2 instanceof TypeBinding)) {
            throw new IllegalArgumentException();
        }
        if (((TypeBinding)binding).isCompatibleWith((TypeBinding)binding2)) {
            return true;
        }
        TypeBinding typeBinding = this._env.getLookupEnvironment().computeBoxingType((TypeBinding)binding);
        return null != typeBinding && typeBinding.isCompatibleWith((TypeBinding)binding2);
    }

    @Override
    public boolean isSameType(TypeMirror typeMirror, TypeMirror typeMirror2) {
        Binding binding;
        if (typeMirror instanceof NoTypeImpl) {
            if (typeMirror2 instanceof NoTypeImpl) {
                return ((NoTypeImpl)typeMirror).getKind() == ((NoTypeImpl)typeMirror2).getKind();
            }
            return false;
        }
        if (typeMirror2 instanceof NoTypeImpl) {
            return false;
        }
        if (typeMirror.getKind() == TypeKind.WILDCARD || typeMirror2.getKind() == TypeKind.WILDCARD) {
            return false;
        }
        if (typeMirror == typeMirror2) {
            return true;
        }
        if (!(typeMirror instanceof TypeMirrorImpl) || !(typeMirror2 instanceof TypeMirrorImpl)) {
            return false;
        }
        Binding binding2 = ((TypeMirrorImpl)typeMirror).binding();
        if (binding2 == (binding = ((TypeMirrorImpl)typeMirror2).binding())) {
            return true;
        }
        if (!(binding2 instanceof TypeBinding) || !(binding instanceof TypeBinding)) {
            return false;
        }
        TypeBinding typeBinding = (TypeBinding)binding2;
        TypeBinding typeBinding2 = (TypeBinding)binding;
        if (TypeBinding.equalsEquals(typeBinding, typeBinding2)) {
            return true;
        }
        return CharOperation.equals(typeBinding.computeUniqueKey(), typeBinding2.computeUniqueKey());
    }

    @Override
    public boolean isSubsignature(ExecutableType executableType, ExecutableType executableType2) {
        MethodBinding methodBinding = (MethodBinding)((ExecutableTypeImpl)executableType)._binding;
        MethodBinding methodBinding2 = (MethodBinding)((ExecutableTypeImpl)executableType2)._binding;
        if (!CharOperation.equals(methodBinding.selector, methodBinding2.selector)) {
            return false;
        }
        return methodBinding.areParameterErasuresEqual(methodBinding2) && methodBinding.areTypeVariableErasuresEqual(methodBinding2);
    }

    @Override
    public boolean isSubtype(TypeMirror typeMirror, TypeMirror typeMirror2) {
        Binding binding;
        this.validateRealTypes(typeMirror, typeMirror2);
        if (typeMirror instanceof NoTypeImpl) {
            if (typeMirror2 instanceof NoTypeImpl) {
                return ((NoTypeImpl)typeMirror).getKind() == ((NoTypeImpl)typeMirror2).getKind();
            }
            return false;
        }
        if (typeMirror2 instanceof NoTypeImpl) {
            return false;
        }
        if (!(typeMirror instanceof TypeMirrorImpl) || !(typeMirror2 instanceof TypeMirrorImpl)) {
            throw new IllegalArgumentException();
        }
        if (typeMirror == typeMirror2) {
            return true;
        }
        Binding binding2 = ((TypeMirrorImpl)typeMirror).binding();
        if (binding2 == (binding = ((TypeMirrorImpl)typeMirror2).binding())) {
            return true;
        }
        if (!(binding2 instanceof TypeBinding) || !(binding instanceof TypeBinding)) {
            throw new IllegalArgumentException();
        }
        if (binding2.kind() == 132 || binding.kind() == 132) {
            if (binding2.kind() != binding.kind()) {
                return false;
            }
            return ((TypeBinding)binding2).isCompatibleWith((TypeBinding)binding);
        }
        return ((TypeBinding)binding2).isCompatibleWith((TypeBinding)binding);
    }

    @Override
    public PrimitiveType unboxedType(TypeMirror typeMirror) {
        if (!(((TypeMirrorImpl)typeMirror)._binding instanceof ReferenceBinding)) {
            throw new IllegalArgumentException("Given type mirror cannot be unboxed");
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)((TypeMirrorImpl)typeMirror)._binding;
        TypeBinding typeBinding = this._env.getLookupEnvironment().computeBoxingType(referenceBinding);
        if (typeBinding.kind() != 132) {
            throw new IllegalArgumentException();
        }
        return (PrimitiveType)this._env.getFactory().newTypeMirror((BaseTypeBinding)typeBinding);
    }

    private static interface MemberInTypeFinder {
        public TypeMirror find(ReferenceBinding var1, Binding var2);
    }
}

