/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.batch.BasicModule;
import org.eclipse.jdt.internal.compiler.batch.ClasspathJrt;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.PackageExportImpl;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.util.Util;

public class ModuleFinder {
    public static List<FileSystem.Classpath> findModules(File file, String string, Parser parser, Map<String, String> map, boolean bl, String string2) {
        ArrayList<FileSystem.Classpath> arrayList = new ArrayList<FileSystem.Classpath>();
        ModuleFinder.scanForModules(string, parser, map, bl, false, arrayList, file, string2);
        return arrayList;
    }

    protected static FileSystem.Classpath findModule(File file, String string, Parser parser, Map<String, String> map, boolean bl, String string2) {
        FileSystem.Classpath classpath = FileSystem.getClasspath(file.getAbsolutePath(), null, !bl, null, string == null ? null : string + File.separator + file.getName(), map, string2);
        if (classpath != null) {
            ModuleFinder.scanForModule(classpath, file, parser, bl, string2);
        }
        return classpath;
    }

    protected static void scanForModules(String string, Parser parser, Map<String, String> map, boolean bl, boolean bl2, List<FileSystem.Classpath> list, File file, String string2) {
        FileSystem.Classpath classpath = FileSystem.getClasspath(file.getAbsolutePath(), null, !bl, null, string == null ? null : string + File.separator + file.getName(), map, string2);
        if (classpath != null) {
            IModule iModule = ModuleFinder.scanForModule(classpath, file, parser, bl2, string2);
            if (iModule != null) {
                list.add(classpath);
            } else if (file.isDirectory()) {
                File[] fileArray;
                for (File file2 : fileArray = file.listFiles()) {
                    ModuleFinder.scanForModules(string, parser, map, bl, bl, list, file2, string2);
                }
            }
        }
    }

    protected static IModule scanForModule(FileSystem.Classpath classpath, final File file, Parser parser, boolean bl, String string) {
        IModule iModule = null;
        if (file.isDirectory()) {
            String[] stringArray = file.list(new FilenameFilter(){

                @Override
                public boolean accept(File file2, String string) {
                    return file2 == file && (string.equalsIgnoreCase("module-info.class") || string.equalsIgnoreCase("module-info.java"));
                }
            });
            if (stringArray.length > 0) {
                String string2;
                switch (string2 = stringArray[0]) {
                    case "module-info.class": {
                        iModule = ModuleFinder.extractModuleFromClass(new File(file, string2), classpath);
                        break;
                    }
                    case "module-info.java": {
                        iModule = ModuleFinder.extractModuleFromSource(new File(file, string2), parser, classpath);
                        if (iModule == null) {
                            return null;
                        }
                        String string3 = new String(iModule.name());
                        if (string3.equals(file.getName())) break;
                        throw new IllegalArgumentException("module name " + string3 + " does not match expected name " + file.getName());
                    }
                }
            }
        } else {
            String string4 = ModuleFinder.getModulePathForArchive(file);
            if (string4 != null) {
                iModule = ModuleFinder.extractModuleFromArchive(file, classpath, string4, string);
            }
        }
        if (bl && iModule == null && !(classpath instanceof ClasspathJrt)) {
            iModule = IModule.createAutomatic(ModuleFinder.getFileName(file), file.isFile(), ModuleFinder.getManifest(file));
        }
        if (iModule != null) {
            classpath.acceptModule(iModule);
        }
        return iModule;
    }

    private static Manifest getManifest(File file) {
        Manifest manifest;
        if (ModuleFinder.getModulePathForArchive(file) == null) {
            return null;
        }
        JarFile jarFile = new JarFile(file);
        try {
            manifest = jarFile.getManifest();
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        jarFile.close();
        return manifest;
    }

    private static String getFileName(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    protected static String[] extractAddonRead(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        String string2 = null;
        String string3 = null;
        if (!stringTokenizer.hasMoreTokens()) {
            return null;
        }
        string2 = stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreTokens()) {
            return null;
        }
        string3 = stringTokenizer.nextToken();
        return new String[]{string2, string3};
    }

    protected static AddExport extractAddonExport(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        String string2 = null;
        String string3 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!stringTokenizer.hasMoreTokens()) {
            return null;
        }
        string2 = stringTokenizer.nextToken("/");
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken("/=");
        } else {
            return null;
        }
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken("=,"));
        }
        PackageExportImpl packageExportImpl = new PackageExportImpl();
        packageExportImpl.pack = string3.toCharArray();
        packageExportImpl.exportedTo = new char[arrayList.size()][];
        for (int i = 0; i < packageExportImpl.exportedTo.length; ++i) {
            packageExportImpl.exportedTo[i] = ((String)arrayList.get(i)).toCharArray();
        }
        return new AddExport(string2, packageExportImpl);
    }

    private static String getModulePathForArchive(File file) {
        int n = Util.archiveFormat(file.getAbsolutePath());
        if (n == 0) {
            return "module-info.class";
        }
        if (n == 1) {
            return "classes/module-info.class";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IModule extractModuleFromArchive(File file, FileSystem.Classpath classpath, String object, String string) {
        ZipFile zipFile = null;
        try {
            Object object2;
            Object object3;
            zipFile = new ZipFile(file);
            if (string != null && (object3 = zipFile.getEntry((String)(object2 = "META-INF/versions/" + string + "/" + (String)object))) != null) {
                object = object2;
            }
            if ((object3 = ModuleFinder.getModule((ClassFileReader)(object2 = ClassFileReader.read(zipFile, (String)object)))) != null) {
                IBinaryModule iBinaryModule = ((ClassFileReader)object2).getModuleDeclaration();
                return iBinaryModule;
            }
            IModule iModule = null;
            return iModule;
        }
        catch (IOException | ClassFormatException exception) {
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private static IModule extractModuleFromClass(File file, FileSystem.Classpath classpath) {
        try {
            ClassFileReader classFileReader = ClassFileReader.read(file);
            IModule iModule = ModuleFinder.getModule(classFileReader);
            if (iModule != null) {
                return classFileReader.getModuleDeclaration();
            }
            return null;
        }
        catch (IOException | ClassFormatException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static IModule getModule(ClassFileReader classFileReader) {
        if (classFileReader != null) {
            return classFileReader.getModuleDeclaration();
        }
        return null;
    }

    private static IModule extractModuleFromSource(File file, Parser parser, FileSystem.Classpath classpath) {
        CompilationResult compilationResult;
        CompilationUnit compilationUnit = new CompilationUnit(null, file.getAbsolutePath(), null, classpath.getDestinationPath());
        CompilationUnitDeclaration compilationUnitDeclaration = parser.parse(compilationUnit, compilationResult = new CompilationResult(compilationUnit, 0, 1, 10));
        if (compilationUnitDeclaration.isModuleInfo() && compilationUnitDeclaration.moduleDeclaration != null) {
            return new BasicModule(compilationUnitDeclaration.moduleDeclaration, classpath);
        }
        return null;
    }

    static class AddExport {
        public final String sourceModuleName;
        public final IModule.IPackageExport export;

        public AddExport(String string, IModule.IPackageExport iPackageExport) {
            this.sourceModuleName = string;
            this.export = iPackageExport;
        }
    }
}

