/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.classfmt;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.classfmt.ElementValuePairInfo;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryElementValuePair;
import org.eclipse.jdt.internal.compiler.env.ITypeAnnotationWalker;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.SignatureWrapper;

public class ExternalAnnotationProvider {
    public static final String ANNOTATION_FILE_EXTENSION = "eea";
    public static final String CLASS_PREFIX = "class ";
    public static final String SUPER_PREFIX = "super ";
    public static final char NULLABLE = '0';
    public static final char NONNULL = '1';
    public static final char NO_ANNOTATION = '@';
    public static final String ANNOTATION_FILE_SUFFIX = ".eea";
    private static final String TYPE_PARAMETER_PREFIX = " <";
    private String typeName;
    String typeParametersAnnotationSource;
    Map<String, String> supertypeAnnotationSources;
    private Map<String, String> methodAnnotationSources;
    private Map<String, String> fieldAnnotationSources;
    SingleMarkerAnnotation NULLABLE_ANNOTATION;
    SingleMarkerAnnotation NONNULL_ANNOTATION;

    public ExternalAnnotationProvider(InputStream inputStream, String string) throws IOException {
        this.typeName = string;
        this.initialize(inputStream);
    }

    private void initialize(InputStream inputStream) throws IOException {
        try (LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(inputStream));){
            String string;
            ExternalAnnotationProvider.assertClassHeader(lineNumberReader.readLine(), this.typeName);
            String string2 = lineNumberReader.readLine();
            if (string2 == null) {
                return;
            }
            if (string2.startsWith(TYPE_PARAMETER_PREFIX)) {
                string2 = lineNumberReader.readLine();
                if (string2 == null) {
                    return;
                }
                if (string2.startsWith(TYPE_PARAMETER_PREFIX)) {
                    this.typeParametersAnnotationSource = string2.substring(TYPE_PARAMETER_PREFIX.length());
                    string2 = lineNumberReader.readLine();
                    if (string2 == null) {
                        return;
                    }
                }
            }
            do {
                string = null;
                if ((string2 = string2.trim()).isEmpty()) continue;
                String string3 = null;
                String string4 = null;
                String string5 = string2;
                boolean bl = string5.startsWith(SUPER_PREFIX);
                if (bl) {
                    string5 = string5.substring(SUPER_PREFIX.length());
                }
                int n = -1;
                try {
                    string2 = lineNumberReader.readLine();
                    if (string2 != null && !string2.isEmpty() && string2.charAt(0) == ' ') {
                        string3 = string2.substring(1);
                    } else {
                        n = lineNumberReader.getLineNumber();
                    }
                    string2 = lineNumberReader.readLine();
                    if (string2 == null || string2.isEmpty()) continue;
                    if (string2.charAt(0) != ' ') {
                        string = string2;
                        continue;
                    }
                    string4 = string2.substring(1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string3 == null || string4 == null) {
                    if (n == -1) {
                        n = lineNumberReader.getLineNumber();
                    }
                    throw new IOException("Illegal format in annotation file for " + this.typeName + " at line " + n);
                }
                string4 = ExternalAnnotationProvider.trimTail(string4);
                if (bl) {
                    if (this.supertypeAnnotationSources == null) {
                        this.supertypeAnnotationSources = new HashMap<String, String>();
                    }
                    this.supertypeAnnotationSources.put('L' + string5 + string3 + ';', string4);
                    continue;
                }
                if (string3.contains("(")) {
                    if (this.methodAnnotationSources == null) {
                        this.methodAnnotationSources = new HashMap<String, String>();
                    }
                    this.methodAnnotationSources.put(string5 + string3, string4);
                    continue;
                }
                if (this.fieldAnnotationSources == null) {
                    this.fieldAnnotationSources = new HashMap<String, String>();
                }
                this.fieldAnnotationSources.put(string5 + ':' + string3, string4);
            } while ((string2 = string) != null || (string2 = lineNumberReader.readLine()) != null);
        }
    }

    public static void assertClassHeader(String string, String string2) throws IOException {
        if (string == null || !string.startsWith(CLASS_PREFIX)) {
            throw new IOException("missing class header in annotation file for " + string2);
        }
        string = string.substring(CLASS_PREFIX.length());
        if (!ExternalAnnotationProvider.trimTail(string).equals(string2)) {
            throw new IOException("mismatching class name in annotation file, expected " + string2 + ", but header said " + string);
        }
    }

    public static String extractSignature(String string) {
        if (string == null || string.isEmpty() || string.charAt(0) != ' ') {
            return null;
        }
        return ExternalAnnotationProvider.trimTail(string.substring(1));
    }

    protected static String trimTail(String string) {
        int n = string.indexOf(32);
        if (n == -1) {
            n = string.indexOf(9);
        }
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public ITypeAnnotationWalker forTypeHeader(LookupEnvironment lookupEnvironment) {
        if (this.typeParametersAnnotationSource != null || this.supertypeAnnotationSources != null) {
            return new DispatchingAnnotationWalker(lookupEnvironment);
        }
        return ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER;
    }

    public ITypeAnnotationWalker forMethod(char[] cArray, char[] cArray2, LookupEnvironment lookupEnvironment) {
        String string;
        Map<String, String> map = this.methodAnnotationSources;
        if (map != null && (string = map.get(String.valueOf(CharOperation.concat(cArray, cArray2)))) != null) {
            return new MethodAnnotationWalker(string.toCharArray(), 0, lookupEnvironment);
        }
        return ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER;
    }

    public ITypeAnnotationWalker forField(char[] cArray, char[] cArray2, LookupEnvironment lookupEnvironment) {
        String string;
        if (this.fieldAnnotationSources != null && (string = this.fieldAnnotationSources.get(String.valueOf(CharOperation.concat(cArray, cArray2, ':')))) != null) {
            return new FieldAnnotationWalker(string.toCharArray(), 0, lookupEnvironment);
        }
        return ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("External Annotations for ").append(this.typeName).append('\n');
        stringBuilder.append("Methods:\n");
        if (this.methodAnnotationSources != null) {
            for (Map.Entry<String, String> entry : this.methodAnnotationSources.entrySet()) {
                stringBuilder.append('\t').append(entry.getKey()).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    void initAnnotations(final LookupEnvironment lookupEnvironment) {
        if (this.NULLABLE_ANNOTATION == null) {
            this.NULLABLE_ANNOTATION = new SingleMarkerAnnotation(){

                @Override
                public char[] getTypeName() {
                    return this.getBinaryTypeName(lookupEnvironment.getNullableAnnotationName());
                }
            };
        }
        if (this.NONNULL_ANNOTATION == null) {
            this.NONNULL_ANNOTATION = new SingleMarkerAnnotation(){

                @Override
                public char[] getTypeName() {
                    return this.getBinaryTypeName(lookupEnvironment.getNonNullAnnotationName());
                }
            };
        }
    }

    class FieldAnnotationWalker
    extends BasicAnnotationWalker {
        public FieldAnnotationWalker(char[] cArray, int n, LookupEnvironment lookupEnvironment) {
            super(cArray, n, lookupEnvironment);
        }

        @Override
        public ITypeAnnotationWalker toField() {
            return this;
        }

        @Override
        public ITypeAnnotationWalker toMethodReturn() {
            throw new UnsupportedOperationException("Field has no method return");
        }

        @Override
        public ITypeAnnotationWalker toMethodParameter(short s) {
            throw new UnsupportedOperationException("Field has no method parameter");
        }

        @Override
        public ITypeAnnotationWalker toThrows(int n) {
            throw new UnsupportedOperationException("Field has no throws");
        }
    }

    class MethodAnnotationWalker
    extends BasicAnnotationWalker
    implements IMethodAnnotationWalker {
        int prevParamStart;
        TypeParametersAnnotationWalker typeParametersWalker;

        MethodAnnotationWalker(char[] cArray, int n, LookupEnvironment lookupEnvironment) {
            super(cArray, n, lookupEnvironment);
        }

        int typeEnd(int n) {
            while (this.source[n] == '[') {
                ++n;
                n = this.skipNullAnnotation(n);
            }
            SignatureWrapper signatureWrapper = this.wrapperWithStart(n);
            int n2 = signatureWrapper.skipAngleContents(signatureWrapper.computeEnd());
            return n2;
        }

        @Override
        public ITypeAnnotationWalker toTypeParameter(boolean bl, int n) {
            if (this.source[0] == '<') {
                if (this.typeParametersWalker == null) {
                    this.typeParametersWalker = new TypeParametersAnnotationWalker(this.source, this.pos + 1, n, null, this.environment);
                    return this.typeParametersWalker;
                }
                return this.typeParametersWalker.toTypeParameter(bl, n);
            }
            return ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER;
        }

        @Override
        public ITypeAnnotationWalker toTypeParameterBounds(boolean bl, int n) {
            if (this.typeParametersWalker != null) {
                return this.typeParametersWalker.toTypeParameterBounds(bl, n);
            }
            return ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER;
        }

        @Override
        public ITypeAnnotationWalker toMethodReturn() {
            int n = CharOperation.indexOf(')', this.source);
            if (n != -1) {
                this.pos = n + 1;
                return this;
            }
            return ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER;
        }

        @Override
        public ITypeAnnotationWalker toMethodParameter(short s) {
            if (s == 0) {
                int n;
                this.prevParamStart = n = CharOperation.indexOf('(', this.source) + 1;
                this.pos = n;
                return this;
            }
            int n = this.typeEnd(this.prevParamStart);
            this.prevParamStart = ++n;
            this.pos = n;
            return this;
        }

        @Override
        public ITypeAnnotationWalker toThrows(int n) {
            return this;
        }

        @Override
        public ITypeAnnotationWalker toField() {
            throw new UnsupportedOperationException("Methods have no fields");
        }

        @Override
        public int getParameterCount() {
            int n = 0;
            int n2 = CharOperation.indexOf('(', this.source) + 1;
            while (n2 < this.source.length && this.source[n2] != ')') {
                n2 = this.typeEnd(n2) + 1;
                ++n;
            }
            return n;
        }
    }

    public static interface IMethodAnnotationWalker
    extends ITypeAnnotationWalker {
        public int getParameterCount();
    }

    class SuperTypesAnnotationWalker
    extends BasicAnnotationWalker {
        SuperTypesAnnotationWalker(char[] cArray, LookupEnvironment lookupEnvironment) {
            super(cArray, 0, lookupEnvironment);
        }

        @Override
        public ITypeAnnotationWalker toField() {
            throw new UnsupportedOperationException("Supertype has no field annotations");
        }

        @Override
        public ITypeAnnotationWalker toMethodReturn() {
            throw new UnsupportedOperationException("Supertype has no method return");
        }

        @Override
        public ITypeAnnotationWalker toMethodParameter(short s) {
            throw new UnsupportedOperationException("Supertype has no method parameter");
        }

        @Override
        public ITypeAnnotationWalker toThrows(int n) {
            throw new UnsupportedOperationException("Supertype has no throws");
        }
    }

    public class TypeParametersAnnotationWalker
    extends BasicAnnotationWalker {
        int[] rankStarts;
        int currentRank;

        TypeParametersAnnotationWalker(char[] cArray, int n, int n2, int[] nArray, LookupEnvironment lookupEnvironment) {
            super(cArray, n, lookupEnvironment);
            this.currentRank = n2;
            if (nArray != null) {
                this.rankStarts = nArray;
            } else {
                int n3 = cArray.length;
                nArray = new int[n3];
                int n4 = 0;
                int n5 = 0;
                boolean bl = true;
                block6: for (int i = n; i < n3; ++i) {
                    switch (this.source[i]) {
                        case '<': {
                            ++n5;
                            continue block6;
                        }
                        case '>': {
                            if (--n5 >= 0) continue block6;
                            break block6;
                        }
                        case ';': {
                            if (n5 != 0 || i + 1 >= n3 || this.source[i + 1] == ':') continue block6;
                            bl = true;
                            continue block6;
                        }
                        case ':': {
                            if (n5 == 0) {
                                bl = true;
                            }
                            ++i;
                            while (i < n3 && this.source[i] == '[') {
                                ++i;
                            }
                            if (i < n3 && this.source[i] == 'L') {
                                int n6 = n5;
                                while (i < n3 && (n6 != n5 || this.source[i] != ';')) {
                                    if (this.source[i] == '<') {
                                        ++n6;
                                    }
                                    if (this.source[i] == '>') {
                                        --n6;
                                    }
                                    ++i;
                                }
                            }
                            --i;
                            continue block6;
                        }
                        default: {
                            if (!bl) continue block6;
                            bl = false;
                            nArray[n4++] = i;
                        }
                    }
                }
                this.rankStarts = new int[n4];
                System.arraycopy(nArray, 0, this.rankStarts, 0, n4);
            }
        }

        @Override
        public ITypeAnnotationWalker toTypeParameter(boolean bl, int n) {
            if (n == this.currentRank) {
                return this;
            }
            if (n < this.rankStarts.length) {
                return new TypeParametersAnnotationWalker(this.source, this.rankStarts[n], n, this.rankStarts, this.environment);
            }
            return ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER;
        }

        @Override
        public ITypeAnnotationWalker toTypeParameterBounds(boolean bl, int n) {
            return new TypeParametersAnnotationWalker(this.source, this.rankStarts[n], n, this.rankStarts, this.environment);
        }

        @Override
        public ITypeAnnotationWalker toTypeBound(short s) {
            int n = this.pos;
            int n2 = this.currentTypeBound;
            while (true) {
                int n3;
                if ((n3 = CharOperation.indexOf(':', this.source, n)) != -1) {
                    n = n3 + 1;
                }
                if (++n2 > s) break;
                n = this.wrapperWithStart(n).computeEnd() + 1;
            }
            this.pos = n;
            this.currentTypeBound = s;
            return this;
        }

        @Override
        public ITypeAnnotationWalker toField() {
            throw new UnsupportedOperationException("Cannot navigate to fields");
        }

        @Override
        public ITypeAnnotationWalker toMethodReturn() {
            throw new UnsupportedOperationException("Cannot navigate to method return");
        }

        @Override
        public ITypeAnnotationWalker toMethodParameter(short s) {
            throw new UnsupportedOperationException("Cannot navigate to method parameter");
        }

        @Override
        public ITypeAnnotationWalker toThrows(int n) {
            throw new UnsupportedOperationException("Cannot navigate to throws");
        }

        @Override
        public IBinaryAnnotation[] getAnnotationsAtCursor(int n, boolean bl) {
            if (this.pos != -1 && this.pos < this.source.length - 1) {
                switch (this.source[this.pos]) {
                    case '0': {
                        return new IBinaryAnnotation[]{ExternalAnnotationProvider.this.NULLABLE_ANNOTATION};
                    }
                    case '1': {
                        return new IBinaryAnnotation[]{ExternalAnnotationProvider.this.NONNULL_ANNOTATION};
                    }
                }
            }
            return super.getAnnotationsAtCursor(n, bl);
        }
    }

    abstract class BasicAnnotationWalker
    implements ITypeAnnotationWalker {
        char[] source;
        SignatureWrapper wrapper;
        int pos;
        int prevTypeArgStart;
        int currentTypeBound;
        LookupEnvironment environment;

        BasicAnnotationWalker(char[] cArray, int n, LookupEnvironment lookupEnvironment) {
            this.source = cArray;
            this.pos = n;
            this.environment = lookupEnvironment;
            ExternalAnnotationProvider.this.initAnnotations(lookupEnvironment);
        }

        SignatureWrapper wrapperWithStart(int n) {
            if (this.wrapper == null) {
                this.wrapper = new SignatureWrapper(this.source);
            }
            this.wrapper.start = n;
            this.wrapper.bracket = -1;
            return this.wrapper;
        }

        @Override
        public ITypeAnnotationWalker toReceiver() {
            return ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER;
        }

        @Override
        public ITypeAnnotationWalker toTypeParameter(boolean bl, int n) {
            return ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER;
        }

        @Override
        public ITypeAnnotationWalker toTypeParameterBounds(boolean bl, int n) {
            return ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER;
        }

        @Override
        public ITypeAnnotationWalker toTypeBound(short s) {
            return ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER;
        }

        @Override
        public ITypeAnnotationWalker toSupertype(short s, char[] cArray) {
            return ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER;
        }

        @Override
        public ITypeAnnotationWalker toTypeArgument(int n) {
            if (n == 0) {
                int n2;
                this.prevTypeArgStart = n2 = CharOperation.indexOf('<', this.source, this.pos) + 1;
                return new MethodAnnotationWalker(this.source, n2, this.environment);
            }
            int n3 = this.prevTypeArgStart;
            switch (this.source[n3]) {
                case '*': {
                    n3 = this.skipNullAnnotation(n3 + 1);
                    break;
                }
                case '+': 
                case '-': {
                    n3 = this.skipNullAnnotation(n3 + 1);
                }
                default: {
                    n3 = this.wrapperWithStart(n3).computeEnd();
                    ++n3;
                }
            }
            this.prevTypeArgStart = n3;
            return new MethodAnnotationWalker(this.source, n3, this.environment);
        }

        @Override
        public ITypeAnnotationWalker toWildcardBound() {
            switch (this.source[this.pos]) {
                case '+': 
                case '-': {
                    int n = this.skipNullAnnotation(this.pos + 1);
                    return new MethodAnnotationWalker(this.source, n, this.environment);
                }
            }
            return ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER;
        }

        @Override
        public ITypeAnnotationWalker toNextArrayDimension() {
            if (this.source[this.pos] == '[') {
                int n = this.skipNullAnnotation(this.pos + 1);
                return new MethodAnnotationWalker(this.source, n, this.environment);
            }
            return ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER;
        }

        @Override
        public ITypeAnnotationWalker toNextNestedType() {
            return this;
        }

        @Override
        public IBinaryAnnotation[] getAnnotationsAtCursor(int n, boolean bl) {
            if (this.pos != -1 && this.pos < this.source.length - 2) {
                switch (this.source[this.pos]) {
                    case '*': 
                    case '+': 
                    case '-': 
                    case 'L': 
                    case 'T': 
                    case '[': {
                        switch (this.source[this.pos + 1]) {
                            case '0': {
                                return new IBinaryAnnotation[]{ExternalAnnotationProvider.this.NULLABLE_ANNOTATION};
                            }
                            case '1': {
                                return new IBinaryAnnotation[]{ExternalAnnotationProvider.this.NONNULL_ANNOTATION};
                            }
                        }
                    }
                }
            }
            return NO_ANNOTATIONS;
        }

        int skipNullAnnotation(int n) {
            if (n >= this.source.length) {
                return n;
            }
            switch (this.source[n]) {
                case '0': 
                case '1': {
                    return n + 1;
                }
            }
            return n;
        }
    }

    class DispatchingAnnotationWalker
    implements ITypeAnnotationWalker {
        private LookupEnvironment environment;
        private TypeParametersAnnotationWalker typeParametersWalker;

        public DispatchingAnnotationWalker(LookupEnvironment lookupEnvironment) {
            this.environment = lookupEnvironment;
        }

        @Override
        public ITypeAnnotationWalker toTypeParameter(boolean bl, int n) {
            String string = ExternalAnnotationProvider.this.typeParametersAnnotationSource;
            if (string != null) {
                if (this.typeParametersWalker == null) {
                    this.typeParametersWalker = new TypeParametersAnnotationWalker(string.toCharArray(), 0, 0, null, this.environment);
                }
                return this.typeParametersWalker.toTypeParameter(bl, n);
            }
            return this;
        }

        @Override
        public ITypeAnnotationWalker toTypeParameterBounds(boolean bl, int n) {
            if (this.typeParametersWalker != null) {
                return this.typeParametersWalker.toTypeParameterBounds(bl, n);
            }
            return this;
        }

        @Override
        public ITypeAnnotationWalker toSupertype(short s, char[] cArray) {
            String string;
            Map<String, String> map = ExternalAnnotationProvider.this.supertypeAnnotationSources;
            if (map != null && (string = map.get(String.valueOf(cArray))) != null) {
                return new SuperTypesAnnotationWalker(string.toCharArray(), this.environment);
            }
            return this;
        }

        @Override
        public ITypeAnnotationWalker toField() {
            return this;
        }

        @Override
        public ITypeAnnotationWalker toThrows(int n) {
            return this;
        }

        @Override
        public ITypeAnnotationWalker toTypeArgument(int n) {
            return this;
        }

        @Override
        public ITypeAnnotationWalker toMethodParameter(short s) {
            return this;
        }

        @Override
        public ITypeAnnotationWalker toTypeBound(short s) {
            return this;
        }

        @Override
        public ITypeAnnotationWalker toMethodReturn() {
            return this;
        }

        @Override
        public ITypeAnnotationWalker toReceiver() {
            return this;
        }

        @Override
        public ITypeAnnotationWalker toWildcardBound() {
            return this;
        }

        @Override
        public ITypeAnnotationWalker toNextArrayDimension() {
            return this;
        }

        @Override
        public ITypeAnnotationWalker toNextNestedType() {
            return this;
        }

        @Override
        public IBinaryAnnotation[] getAnnotationsAtCursor(int n, boolean bl) {
            return NO_ANNOTATIONS;
        }
    }

    abstract class SingleMarkerAnnotation
    implements IBinaryAnnotation {
        SingleMarkerAnnotation() {
        }

        @Override
        public IBinaryElementValuePair[] getElementValuePairs() {
            return ElementValuePairInfo.NoMembers;
        }

        @Override
        public boolean isExternalAnnotation() {
            return true;
        }

        protected char[] getBinaryTypeName(char[][] cArray) {
            return CharOperation.concat('L', CharOperation.concatWith(cArray, '/'), ';');
        }
    }
}

