/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.env;

import java.util.Arrays;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;

public class NameEnvironmentAnswer {
    IBinaryType binaryType;
    ICompilationUnit compilationUnit;
    ISourceType[] sourceTypes;
    ReferenceBinding binding;
    AccessRestriction accessRestriction;
    char[] moduleName;
    public ModuleBinding moduleBinding;
    String externalAnnotationPath;

    public NameEnvironmentAnswer(IBinaryType iBinaryType, AccessRestriction accessRestriction) {
        this.binaryType = iBinaryType;
        this.accessRestriction = accessRestriction;
        this.moduleName = iBinaryType.getModule();
    }

    public NameEnvironmentAnswer(IBinaryType iBinaryType, AccessRestriction accessRestriction, char[] cArray) {
        this.binaryType = iBinaryType;
        this.accessRestriction = accessRestriction;
        this.moduleName = cArray;
    }

    public NameEnvironmentAnswer(ICompilationUnit iCompilationUnit, AccessRestriction accessRestriction) {
        this(iCompilationUnit, accessRestriction, iCompilationUnit.getModuleName());
    }

    public NameEnvironmentAnswer(ICompilationUnit iCompilationUnit, AccessRestriction accessRestriction, char[] cArray) {
        this.compilationUnit = iCompilationUnit;
        this.accessRestriction = accessRestriction;
        this.moduleName = cArray;
    }

    public NameEnvironmentAnswer(ISourceType[] iSourceTypeArray, AccessRestriction accessRestriction, String string, char[] cArray) {
        this.sourceTypes = iSourceTypeArray;
        this.accessRestriction = accessRestriction;
        this.externalAnnotationPath = string;
        this.moduleName = cArray;
    }

    public NameEnvironmentAnswer(ReferenceBinding referenceBinding, ModuleBinding moduleBinding) {
        this.binding = referenceBinding;
        this.moduleBinding = moduleBinding;
    }

    public String toString() {
        String string = "";
        if (this.binaryType != null) {
            char[] cArray = this.binaryType.getFileName();
            String string2 = cArray == null ? "" : new String(cArray);
            string = "IBinaryType " + string2;
        }
        if (this.compilationUnit != null) {
            string = "ICompilationUnit " + this.compilationUnit.toString();
        }
        if (this.sourceTypes != null) {
            string = Arrays.toString(this.sourceTypes);
        }
        if (this.accessRestriction != null) {
            string = string + " " + this.accessRestriction.toString();
        }
        if (this.externalAnnotationPath != null) {
            string = string + " extPath=" + this.externalAnnotationPath.toString();
        }
        if (this.moduleName != null) {
            string = string + " module=" + String.valueOf(this.moduleName);
        }
        return string;
    }

    public AccessRestriction getAccessRestriction() {
        return this.accessRestriction;
    }

    public void setBinaryType(IBinaryType iBinaryType) {
        this.binaryType = iBinaryType;
    }

    public IBinaryType getBinaryType() {
        return this.binaryType;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public String getExternalAnnotationPath() {
        return this.externalAnnotationPath;
    }

    public ISourceType[] getSourceTypes() {
        return this.sourceTypes;
    }

    public ReferenceBinding getResolvedBinding() {
        return this.binding;
    }

    public boolean isBinaryType() {
        return this.binaryType != null;
    }

    public boolean isCompilationUnit() {
        return this.compilationUnit != null;
    }

    public boolean isSourceType() {
        return this.sourceTypes != null;
    }

    public boolean isResolvedBinding() {
        return this.binding != null;
    }

    public boolean ignoreIfBetter() {
        return this.accessRestriction != null && this.accessRestriction.ignoreIfBetter();
    }

    public char[] moduleName() {
        return this.moduleName;
    }

    public boolean isBetter(NameEnvironmentAnswer nameEnvironmentAnswer) {
        if (nameEnvironmentAnswer == null) {
            return true;
        }
        if (this.accessRestriction == null) {
            return true;
        }
        return nameEnvironmentAnswer.accessRestriction != null && this.accessRestriction.getProblemId() < nameEnvironmentAnswer.accessRestriction.getProblemId();
    }
}

