/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;

public class UnresolvedAnnotationBinding
extends AnnotationBinding {
    private LookupEnvironment env;
    private boolean typeUnresolved = true;

    UnresolvedAnnotationBinding(ReferenceBinding referenceBinding, ElementValuePair[] elementValuePairArray, LookupEnvironment lookupEnvironment) {
        super(referenceBinding, elementValuePairArray);
        this.env = lookupEnvironment;
    }

    @Override
    public void resolve() {
        if (this.typeUnresolved) {
            boolean bl = this.env.mayTolerateMissingType;
            this.env.mayTolerateMissingType = true;
            try {
                this.type = (ReferenceBinding)BinaryTypeBinding.resolveType(this.type, this.env, false);
            }
            finally {
                this.env.mayTolerateMissingType = bl;
            }
            this.typeUnresolved = false;
        }
    }

    @Override
    public ReferenceBinding getAnnotationType() {
        this.resolve();
        return this.type;
    }

    @Override
    public ElementValuePair[] getElementValuePairs() {
        if (this.env != null) {
            if (this.typeUnresolved) {
                this.resolve();
            }
            int n = this.pairs.length;
            while (--n >= 0) {
                Object object;
                ElementValuePair elementValuePair = this.pairs[n];
                MethodBinding[] methodBindingArray = this.type.getMethods(elementValuePair.getName());
                if (methodBindingArray != null && methodBindingArray.length == 1) {
                    elementValuePair.setMethodBinding(methodBindingArray[0]);
                }
                if ((object = elementValuePair.getValue()) instanceof UnresolvedReferenceBinding) {
                    elementValuePair.setValue(((UnresolvedReferenceBinding)object).resolve(this.env, false));
                    continue;
                }
                if (!(object instanceof Object[])) continue;
                Object[] objectArray = (Object[])object;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!(objectArray[i] instanceof UnresolvedReferenceBinding)) continue;
                    objectArray[i] = ((UnresolvedReferenceBinding)objectArray[i]).resolve(this.env, false);
                }
            }
            this.env = null;
        }
        return this.pairs;
    }
}

