/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.composite;

import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

public class MapConverter
extends AbstractConfigurationConverter {
    @Override
    public boolean canConvert(Class type) {
        return Map.class.isAssignableFrom(type) && !Properties.class.isAssignableFrom(type);
    }

    @Override
    public Object fromConfiguration(ConverterLookup converterLookup, PlexusConfiguration configuration, Class type, Class baseType, ClassLoader classLoader, ExpressionEvaluator expressionEvaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Map<Object, Object> retValue = this.fromExpression(configuration, expressionEvaluator);
        if (retValue == null) {
            PlexusConfiguration[] children;
            Map<Object, Object> map = this.newMap(configuration, type, classLoader);
            for (PlexusConfiguration child : children = configuration.getChildren()) {
                String name = child.getName();
                map.put(name, this.fromExpression(child, expressionEvaluator));
            }
            retValue = map;
        }
        return retValue;
    }

    private Map<Object, Object> newMap(PlexusConfiguration configuration, Class<?> type, ClassLoader classLoader) throws ComponentConfigurationException {
        Object map;
        Class implementation = this.getClassForImplementationHint(type, configuration, classLoader);
        if (null == implementation || Modifier.isAbstract(implementation.getModifiers())) {
            map = this.getDefaultMap(implementation);
        } else {
            try {
                map = this.instantiateObject(implementation);
            }
            catch (ComponentConfigurationException e) {
                if (e.getFailedConfiguration() == null) {
                    e.setFailedConfiguration(configuration);
                }
                throw e;
            }
        }
        try {
            return (Map)Map.class.cast(map);
        }
        catch (ClassCastException e) {
            throw new ComponentConfigurationException(configuration, "The class " + implementation.getName() + " used to configure the property '" + configuration.getName() + "' is not a map", e);
        }
    }

    private Map<Object, Object> getDefaultMap(Class<?> mapType) {
        return new TreeMap<Object, Object>();
    }
}

