/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.user;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.Date;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.activeconnection.ActiveConnectionDirectory;
import org.apache.guacamole.auth.jdbc.base.ActivityRecordModel;
import org.apache.guacamole.auth.jdbc.base.RestrictedObject;
import org.apache.guacamole.auth.jdbc.connection.ConnectionDirectory;
import org.apache.guacamole.auth.jdbc.connection.ConnectionRecordSet;
import org.apache.guacamole.auth.jdbc.connection.ModeledConnection;
import org.apache.guacamole.auth.jdbc.connectiongroup.ConnectionGroupDirectory;
import org.apache.guacamole.auth.jdbc.connectiongroup.ModeledConnectionGroup;
import org.apache.guacamole.auth.jdbc.connectiongroup.RootConnectionGroup;
import org.apache.guacamole.auth.jdbc.sharingprofile.ModeledSharingProfile;
import org.apache.guacamole.auth.jdbc.sharingprofile.SharingProfileDirectory;
import org.apache.guacamole.auth.jdbc.user.ModeledAuthenticatedUser;
import org.apache.guacamole.auth.jdbc.user.ModeledUser;
import org.apache.guacamole.auth.jdbc.user.PrivilegedModeledAuthenticatedUser;
import org.apache.guacamole.auth.jdbc.user.UserDirectory;
import org.apache.guacamole.auth.jdbc.user.UserRecordMapper;
import org.apache.guacamole.auth.jdbc.user.UserRecordSet;
import org.apache.guacamole.auth.jdbc.usergroup.ModeledUserGroup;
import org.apache.guacamole.auth.jdbc.usergroup.UserGroupDirectory;
import org.apache.guacamole.form.Form;
import org.apache.guacamole.net.auth.ActiveConnection;
import org.apache.guacamole.net.auth.ActivityRecord;
import org.apache.guacamole.net.auth.ActivityRecordSet;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.net.auth.Connection;
import org.apache.guacamole.net.auth.ConnectionGroup;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.SharingProfile;
import org.apache.guacamole.net.auth.User;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.net.auth.UserGroup;

public class ModeledUserContext
extends RestrictedObject
implements UserContext {
    @Inject
    private UserDirectory userDirectory;
    @Inject
    private UserGroupDirectory userGroupDirectory;
    @Inject
    private ConnectionDirectory connectionDirectory;
    @Inject
    private ConnectionGroupDirectory connectionGroupDirectory;
    @Inject
    private SharingProfileDirectory sharingProfileDirectory;
    @Inject
    private ActiveConnectionDirectory activeConnectionDirectory;
    @Inject
    private Provider<RootConnectionGroup> rootGroupProvider;
    @Inject
    private Provider<ConnectionRecordSet> connectionRecordSetProvider;
    @Inject
    private Provider<UserRecordSet> userRecordSetProvider;
    @Inject
    private Provider<ModeledUserContext> userContextProvider;
    @Inject
    private UserRecordMapper userRecordMapper;
    private ActivityRecordModel userRecord;

    @Override
    public void init(ModeledAuthenticatedUser currentUser) {
        super.init(currentUser);
        this.userDirectory.init(currentUser);
        this.userGroupDirectory.init(currentUser);
        this.connectionDirectory.init(currentUser);
        this.connectionGroupDirectory.init(currentUser);
        this.sharingProfileDirectory.init(currentUser);
        this.activeConnectionDirectory.init(currentUser);
    }

    public void recordUserLogin() {
        if (this.userRecord != null) {
            return;
        }
        this.userRecord = new ActivityRecordModel();
        this.userRecord.setUsername(this.getCurrentUser().getIdentifier());
        this.userRecord.setStartDate(new Date());
        this.userRecord.setRemoteHost(this.getCurrentUser().getCredentials().getRemoteAddress());
        this.userRecordMapper.insert(this.userRecord);
    }

    public UserContext getPrivileged() {
        ModeledUserContext context = this.userContextProvider.get();
        context.init(new PrivilegedModeledAuthenticatedUser(this.getCurrentUser()));
        return context;
    }

    public User self() {
        return this.getCurrentUser().getUser();
    }

    public Object getResource() throws GuacamoleException {
        return null;
    }

    public AuthenticationProvider getAuthenticationProvider() {
        return this.getCurrentUser().getModelAuthenticationProvider();
    }

    public Directory<User> getUserDirectory() throws GuacamoleException {
        return this.userDirectory;
    }

    public Directory<UserGroup> getUserGroupDirectory() throws GuacamoleException {
        return this.userGroupDirectory;
    }

    public Directory<Connection> getConnectionDirectory() throws GuacamoleException {
        return this.connectionDirectory;
    }

    public Directory<ConnectionGroup> getConnectionGroupDirectory() throws GuacamoleException {
        return this.connectionGroupDirectory;
    }

    public Directory<SharingProfile> getSharingProfileDirectory() throws GuacamoleException {
        return this.sharingProfileDirectory;
    }

    public Directory<ActiveConnection> getActiveConnectionDirectory() throws GuacamoleException {
        return this.activeConnectionDirectory;
    }

    public ConnectionRecordSet getConnectionHistory() throws GuacamoleException {
        ConnectionRecordSet connectionRecordSet = this.connectionRecordSetProvider.get();
        connectionRecordSet.init(this.getCurrentUser());
        return connectionRecordSet;
    }

    public ActivityRecordSet<ActivityRecord> getUserHistory() throws GuacamoleException {
        UserRecordSet userRecordSet = this.userRecordSetProvider.get();
        userRecordSet.init(this.getCurrentUser());
        return userRecordSet;
    }

    public ConnectionGroup getRootConnectionGroup() throws GuacamoleException {
        RootConnectionGroup rootGroup = this.rootGroupProvider.get();
        rootGroup.init(this.getCurrentUser());
        return rootGroup;
    }

    public Collection<Form> getUserAttributes() {
        return ModeledUser.ATTRIBUTES;
    }

    public Collection<Form> getUserGroupAttributes() {
        return ModeledUserGroup.ATTRIBUTES;
    }

    public Collection<Form> getConnectionAttributes() {
        return ModeledConnection.ATTRIBUTES;
    }

    public Collection<Form> getConnectionGroupAttributes() {
        return ModeledConnectionGroup.ATTRIBUTES;
    }

    public Collection<Form> getSharingProfileAttributes() {
        return ModeledSharingProfile.ATTRIBUTES;
    }

    public void invalidate() {
        if (this.userRecord != null) {
            this.userRecord.setEndDate(new Date());
            this.userRecordMapper.update(this.userRecord);
        }
    }
}

