/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ext.RuntimeDelegate;

public class CacheControl {
    private boolean _private = false;
    private List<String> privateFields;
    private boolean noCache = false;
    private List<String> noCacheFields;
    private boolean noStore = false;
    private boolean noTransform = true;
    private boolean mustRevalidate = false;
    private boolean proxyRevalidate = false;
    private int maxAge = -1;
    private int sMaxAge = -1;
    private Map<String, String> cacheExtension;
    private static final RuntimeDelegate.HeaderDelegate<CacheControl> delegate = RuntimeDelegate.getInstance().createHeaderDelegate(CacheControl.class);

    public static CacheControl valueOf(String string) throws IllegalArgumentException {
        return delegate.fromString(string);
    }

    public boolean isMustRevalidate() {
        return this.mustRevalidate;
    }

    public void setMustRevalidate(boolean bl) {
        this.mustRevalidate = bl;
    }

    public boolean isProxyRevalidate() {
        return this.proxyRevalidate;
    }

    public void setProxyRevalidate(boolean bl) {
        this.proxyRevalidate = bl;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int n) {
        this.maxAge = n;
    }

    public int getSMaxAge() {
        return this.sMaxAge;
    }

    public void setSMaxAge(int n) {
        this.sMaxAge = n;
    }

    public List<String> getNoCacheFields() {
        if (this.noCacheFields == null) {
            this.noCacheFields = new ArrayList<String>();
        }
        return this.noCacheFields;
    }

    public void setNoCache(boolean bl) {
        this.noCache = bl;
    }

    public boolean isNoCache() {
        return this.noCache;
    }

    public boolean isPrivate() {
        return this._private;
    }

    public List<String> getPrivateFields() {
        if (this.privateFields == null) {
            this.privateFields = new ArrayList<String>();
        }
        return this.privateFields;
    }

    public void setPrivate(boolean bl) {
        this._private = bl;
    }

    public boolean isNoTransform() {
        return this.noTransform;
    }

    public void setNoTransform(boolean bl) {
        this.noTransform = bl;
    }

    public boolean isNoStore() {
        return this.noStore;
    }

    public void setNoStore(boolean bl) {
        this.noStore = bl;
    }

    public Map<String, String> getCacheExtension() {
        if (this.cacheExtension == null) {
            this.cacheExtension = new HashMap<String, String>();
        }
        return this.cacheExtension;
    }

    public String toString() {
        return delegate.toString(this);
    }

    public int hashCode() {
        int n = 7;
        n = 41 * n + (this._private ? 1 : 0);
        n = 41 * n + (this.privateFields != null ? ((Object)this.privateFields).hashCode() : 0);
        n = 41 * n + (this.noCache ? 1 : 0);
        n = 41 * n + (this.noCacheFields != null ? ((Object)this.noCacheFields).hashCode() : 0);
        n = 41 * n + (this.noStore ? 1 : 0);
        n = 41 * n + (this.noTransform ? 1 : 0);
        n = 41 * n + (this.mustRevalidate ? 1 : 0);
        n = 41 * n + (this.proxyRevalidate ? 1 : 0);
        n = 41 * n + this.maxAge;
        n = 41 * n + this.sMaxAge;
        n = 41 * n + (this.cacheExtension != null ? ((Object)this.cacheExtension).hashCode() : 0);
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CacheControl cacheControl = (CacheControl)object;
        if (this._private != cacheControl._private) {
            return false;
        }
        if (!(this.privateFields == cacheControl.privateFields || this.privateFields != null && ((Object)this.privateFields).equals(cacheControl.privateFields))) {
            return false;
        }
        if (this.noCache != cacheControl.noCache) {
            return false;
        }
        if (!(this.noCacheFields == cacheControl.noCacheFields || this.noCacheFields != null && ((Object)this.noCacheFields).equals(cacheControl.noCacheFields))) {
            return false;
        }
        if (this.noStore != cacheControl.noStore) {
            return false;
        }
        if (this.noTransform != cacheControl.noTransform) {
            return false;
        }
        if (this.mustRevalidate != cacheControl.mustRevalidate) {
            return false;
        }
        if (this.proxyRevalidate != cacheControl.proxyRevalidate) {
            return false;
        }
        if (this.maxAge != cacheControl.maxAge) {
            return false;
        }
        if (this.sMaxAge != cacheControl.sMaxAge) {
            return false;
        }
        return this.cacheExtension == cacheControl.cacheExtension || this.cacheExtension != null && ((Object)this.cacheExtension).equals(cacheControl.cacheExtension);
    }
}

