/*
 * Decompiled with CFR 0.152.
 */
package org.glyptodon.guacamole.token;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TokenFilter {
    private final Pattern tokenPattern = Pattern.compile("(.*?)(^|.)(\\$\\{([A-Za-z0-9_]*)\\})");
    private static final int LEADING_TEXT_GROUP = 1;
    private static final int ESCAPE_CHAR_GROUP = 2;
    private static final int TOKEN_GROUP = 3;
    private static final int TOKEN_NAME_GROUP = 4;
    private final Map<String, String> tokenValues = new HashMap<String, String>();

    public void setToken(String name, String value) {
        this.tokenValues.put(name, value);
    }

    public String getToken(String name) {
        return this.tokenValues.get(name);
    }

    public void unsetToken(String name) {
        this.tokenValues.remove(name);
    }

    public Map<String, String> getTokens() {
        return this.tokenValues;
    }

    public void setTokens(Map<String, String> tokens) {
        this.tokenValues.clear();
        this.tokenValues.putAll(tokens);
    }

    public String filter(String input) {
        StringBuilder output = new StringBuilder();
        Matcher tokenMatcher = this.tokenPattern.matcher(input);
        int endOfLastMatch = 0;
        while (tokenMatcher.find()) {
            String literal = tokenMatcher.group(1);
            String escape = tokenMatcher.group(2);
            output.append(literal);
            if ("$".equals(escape)) {
                String notToken = tokenMatcher.group(3);
                output.append(notToken);
            } else {
                output.append(escape);
                String tokenName = tokenMatcher.group(4);
                String tokenValue = this.getToken(tokenName);
                if (tokenValue == null) {
                    String notToken = tokenMatcher.group(3);
                    output.append(notToken);
                } else {
                    output.append(tokenValue);
                }
            }
            endOfLastMatch = tokenMatcher.end();
        }
        output.append(input.substring(endOfLastMatch));
        return output.toString();
    }

    public void filterValues(Map<?, String> map) {
        for (Map.Entry<?, String> entry : map.entrySet()) {
            String value = entry.getValue();
            if (value == null) continue;
            entry.setValue(this.filter(value));
        }
    }
}

