/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.Annotations;
import com.google.inject.internal.Errors;
import com.google.inject.internal.ProviderMethod;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.Message;
import com.google.inject.spi.ModuleAnnotatedMethodScanner;
import com.google.inject.util.Modules;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public final class ProviderMethodsModule
implements Module {
    private static ModuleAnnotatedMethodScanner PROVIDES_BUILDER = new ModuleAnnotatedMethodScanner(){

        @Override
        public <T> Key<T> prepareMethod(Binder binder, Annotation annotation, Key<T> key, InjectionPoint injectionPoint) {
            return key;
        }

        @Override
        public Set<? extends Class<? extends Annotation>> annotationClasses() {
            return ImmutableSet.of(Provides.class);
        }
    };
    private final Object delegate;
    private final TypeLiteral<?> typeLiteral;
    private final boolean skipFastClassGeneration;
    private final ModuleAnnotatedMethodScanner scanner;

    private ProviderMethodsModule(Object delegate, boolean skipFastClassGeneration, ModuleAnnotatedMethodScanner scanner) {
        this.delegate = Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
        this.typeLiteral = TypeLiteral.get(this.delegate.getClass());
        this.skipFastClassGeneration = skipFastClassGeneration;
        this.scanner = scanner;
    }

    public static Module forModule(Module module) {
        return ProviderMethodsModule.forObject(module, false, PROVIDES_BUILDER);
    }

    public static Module forModule(Object module, ModuleAnnotatedMethodScanner scanner) {
        return ProviderMethodsModule.forObject(module, false, scanner);
    }

    public static Module forObject(Object object) {
        return ProviderMethodsModule.forObject(object, true, PROVIDES_BUILDER);
    }

    private static Module forObject(Object object, boolean skipFastClassGeneration, ModuleAnnotatedMethodScanner scanner) {
        if (object instanceof ProviderMethodsModule) {
            return Modules.EMPTY_MODULE;
        }
        return new ProviderMethodsModule(object, skipFastClassGeneration, scanner);
    }

    public Object getDelegateModule() {
        return this.delegate;
    }

    @Override
    public synchronized void configure(Binder binder) {
        for (ProviderMethod<?> providerMethod : this.getProviderMethods(binder)) {
            providerMethod.configure(binder);
        }
    }

    public List<ProviderMethod<?>> getProviderMethods(Binder binder) {
        ArrayList result = Lists.newArrayList();
        HashMultimap methodsBySignature = HashMultimap.create();
        for (Class<?> c = this.delegate.getClass(); c != Object.class; c = c.getSuperclass()) {
            for (Method method : c.getDeclaredMethods()) {
                Optional<Annotation> annotation;
                if ((method.getModifiers() & 0xA) == 0 && !method.isBridge() && !method.isSynthetic()) {
                    methodsBySignature.put((Object)new Signature(method), (Object)method);
                }
                if (!(annotation = this.isProvider(binder, method)).isPresent()) continue;
                result.add(this.createProviderMethod(binder, method, (Annotation)annotation.get()));
            }
        }
        block2: for (ProviderMethod provider : result) {
            Method method = provider.getMethod();
            for (Method matchingSignature : methodsBySignature.get((Object)new Signature(method))) {
                if (matchingSignature.getDeclaringClass().isAssignableFrom(method.getDeclaringClass()) || !ProviderMethodsModule.overrides(matchingSignature, method)) continue;
                String annotationString = provider.getAnnotation().annotationType() == Provides.class ? "@Provides" : "@" + provider.getAnnotation().annotationType().getCanonicalName();
                binder.addError("Overriding " + annotationString + " methods is not allowed.\n\t" + annotationString + " method: %s\n\toverridden by: %s", method, matchingSignature);
                continue block2;
            }
        }
        return result;
    }

    private Optional<Annotation> isProvider(Binder binder, Method method) {
        if (method.isBridge() || method.isSynthetic()) {
            return Optional.absent();
        }
        Annotation annotation = null;
        for (Class<? extends Annotation> clazz : this.scanner.annotationClasses()) {
            Annotation foundAnnotation = method.getAnnotation(clazz);
            if (foundAnnotation == null) continue;
            if (annotation != null) {
                binder.addError("More than one annotation claimed by %s on method %s. Methods can only have one annotation claimed per scanner.", this.scanner, method);
                return Optional.absent();
            }
            annotation = foundAnnotation;
        }
        return Optional.fromNullable(annotation);
    }

    private static boolean overrides(Method a, Method b) {
        int modifiers = b.getModifiers();
        if (Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers)) {
            return true;
        }
        if (Modifier.isPrivate(modifiers)) {
            return false;
        }
        return a.getDeclaringClass().getPackage().equals(b.getDeclaringClass().getPackage());
    }

    private <T> ProviderMethod<T> createProviderMethod(Binder binder, Method method, Annotation annotation) {
        binder = binder.withSource(method);
        Errors errors = new Errors(method);
        InjectionPoint point = InjectionPoint.forMethod(method, this.typeLiteral);
        List<Dependency<?>> dependencies = point.getDependencies();
        ArrayList parameterProviders = Lists.newArrayList();
        for (Dependency<?> dependency : point.getDependencies()) {
            parameterProviders.add(binder.getProvider(dependency));
        }
        TypeLiteral<?> returnType = this.typeLiteral.getReturnType(method);
        Key<?> key = this.getKey(errors, returnType, method, method.getAnnotations());
        try {
            key = this.scanner.prepareMethod(binder, annotation, key, point);
        }
        catch (Throwable t) {
            binder.addError(t);
        }
        Class<? extends Annotation> scopeAnnotation = Annotations.findScopeAnnotation(errors, method.getAnnotations());
        for (Message message : errors.getMessages()) {
            binder.addError(message);
        }
        return ProviderMethod.create(key, method, this.delegate, ImmutableSet.copyOf(dependencies), parameterProviders, scopeAnnotation, this.skipFastClassGeneration, annotation);
    }

    <T> Key<T> getKey(Errors errors, TypeLiteral<T> type, Member member, Annotation[] annotations) {
        Annotation bindingAnnotation = Annotations.findBindingAnnotation(errors, member, annotations);
        return bindingAnnotation == null ? Key.get(type) : Key.get(type, bindingAnnotation);
    }

    public boolean equals(Object o) {
        return o instanceof ProviderMethodsModule && ((ProviderMethodsModule)o).delegate == this.delegate && ((ProviderMethodsModule)o).scanner == this.scanner;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    private final class Signature {
        final Class<?>[] parameters;
        final String name;
        final int hashCode;

        Signature(Method method) {
            this.name = method.getName();
            List<TypeLiteral<?>> resolvedParameterTypes = ProviderMethodsModule.this.typeLiteral.getParameterTypes(method);
            this.parameters = new Class[resolvedParameterTypes.size()];
            int i = 0;
            for (TypeLiteral<?> type : resolvedParameterTypes) {
                this.parameters[i] = type.getRawType();
            }
            this.hashCode = this.name.hashCode() + 31 * Arrays.hashCode(this.parameters);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Signature) {
                Signature other = (Signature)obj;
                return other.name.equals(this.name) && Arrays.equals(this.parameters, other.parameters);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

