/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.reflect;

import java.lang.ref.Reference;
import java.util.concurrent.ConcurrentMap;
import org.sonatype.guice.bean.reflect.MildValues;

final class MildConcurrentValues<K, V>
extends MildValues<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<K, Reference<V>> concurrentMap;

    MildConcurrentValues(ConcurrentMap<K, Reference<V>> map, boolean soft) {
        super(map, soft);
        this.concurrentMap = map;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        Reference<V> oldRef;
        this.compact();
        Reference<V> ref = this.mildValue(key, value);
        while ((oldRef = this.concurrentMap.putIfAbsent(key, ref)) != null) {
            V oldValue = oldRef.get();
            if (null != oldValue) {
                return oldValue;
            }
            this.concurrentMap.remove(key, oldRef);
        }
        return null;
    }

    @Override
    public V replace(K key, V value) {
        this.compact();
        Reference<V> ref = this.concurrentMap.replace(key, this.mildValue(key, value));
        return null != ref ? (V)ref.get() : null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.compact();
        return this.concurrentMap.replace(key, this.mildValue(null, oldValue), this.mildValue(key, newValue));
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.compact();
        return this.concurrentMap.remove(key, MildConcurrentValues.tempValue(value));
    }

    @Override
    void compact() {
        Reference ref;
        while ((ref = this.queue.poll()) != null) {
            this.concurrentMap.remove(((MildValues.InverseMapping)((Object)ref)).key(), ref);
        }
    }
}

