/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.reflect;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import org.sonatype.guice.bean.reflect.FileEntryIterator;
import org.sonatype.guice.bean.reflect.GlobberStrategy;
import org.sonatype.guice.bean.reflect.Streams;
import org.sonatype.guice.bean.reflect.ZipEntryIterator;

final class ResourceEnumeration
implements Enumeration<URL> {
    private static final Iterator<String> NO_ENTRIES = Collections.emptySet().iterator();
    private final URL[] urls;
    private final String subPath;
    private final GlobberStrategy globber;
    private final Object globPattern;
    private final boolean recurse;
    private int index;
    private URL currentURL;
    private boolean isFolder;
    private Iterator<String> entryNames = NO_ENTRIES;
    private String nextEntryName;

    ResourceEnumeration(String subPath, String glob, boolean recurse, URL[] urls) {
        this.subPath = ResourceEnumeration.normalizeSearchPath(subPath);
        this.globber = GlobberStrategy.selectFor(glob);
        this.globPattern = this.globber.compile(glob);
        this.recurse = recurse;
        this.urls = urls;
    }

    @Override
    public boolean hasMoreElements() {
        while (null == this.nextEntryName) {
            if (this.entryNames.hasNext()) {
                String name = this.entryNames.next();
                if (!this.matchesRequest(name)) continue;
                this.nextEntryName = name;
                continue;
            }
            if (this.index < this.urls.length) {
                this.currentURL = this.urls[this.index++];
                this.entryNames = this.scan(this.currentURL);
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public URL nextElement() {
        if (this.hasMoreElements()) {
            String name = this.nextEntryName;
            this.nextEntryName = null;
            try {
                return this.findResource(name);
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e.toString());
            }
        }
        throw new NoSuchElementException();
    }

    private static String normalizeSearchPath(String path) {
        if (null == path || "/".equals(path)) {
            return "";
        }
        boolean echoSlash = false;
        StringBuilder buf = new StringBuilder();
        int length = path.length();
        for (int i = 0; i < length; ++i) {
            boolean isNotSlash;
            char c = path.charAt(i);
            boolean bl = isNotSlash = '/' != c;
            if (!echoSlash && !isNotSlash) continue;
            echoSlash = isNotSlash;
            buf.append(c);
        }
        if (echoSlash) {
            buf.append('/');
        }
        return buf.toString();
    }

    private Iterator<String> scan(URL url) {
        this.isFolder = url.getPath().endsWith("/");
        if (this.globber == GlobberStrategy.EXACT && !this.recurse) {
            try {
                this.nextEntryName = this.subPath + this.globPattern;
                Streams.open(this.findResource(this.nextEntryName)).close();
            }
            catch (Exception e) {
                this.nextEntryName = null;
            }
            return NO_ENTRIES;
        }
        return this.isFolder ? new FileEntryIterator(url, this.subPath, this.recurse) : new ZipEntryIterator(url);
    }

    private URL findResource(String name) throws MalformedURLException {
        if (this.isFolder) {
            return new URL(this.currentURL, name);
        }
        if ("jar".equals(this.currentURL.getProtocol())) {
            return new URL(this.currentURL, "#" + name, new NestedJarURLHandler());
        }
        return new URL("jar:" + this.currentURL + "!/" + name);
    }

    private boolean matchesRequest(String entryName) {
        if (entryName.endsWith("/") || !entryName.startsWith(this.subPath)) {
            return false;
        }
        if (!this.recurse && entryName.indexOf(47, this.subPath.length()) > 0) {
            return false;
        }
        return this.globber.matches(this.globPattern, entryName);
    }

    static final class NestedJarURLHandler
    extends URLStreamHandler {
        NestedJarURLHandler() {
        }

        @Override
        protected URLConnection openConnection(URL url) {
            return new URLConnection(url){

                @Override
                public void connect() {
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    URL containingURL = new URL("jar", null, -1, this.url.getFile());
                    ZipInputStream is = new ZipInputStream(Streams.open(containingURL));
                    String entryName = this.url.getRef();
                    ZipEntry entry = is.getNextEntry();
                    while (entry != null) {
                        if (entryName.equals(entry.getName())) {
                            return is;
                        }
                        entry = is.getNextEntry();
                    }
                    throw new ZipException("No such entry: " + entryName + " in: " + containingURL);
                }
            };
        }
    }
}

