/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import org.eclipse.sisu.Hidden;
import org.eclipse.sisu.inject.BindingPublisher;
import org.eclipse.sisu.inject.InjectorBindings;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.inject.Sources;
import org.eclipse.sisu.inject.TypeArguments;

final class ImplicitBindings {
    private final Iterable<BindingPublisher> publishers;

    ImplicitBindings(Iterable<BindingPublisher> publishers) {
        this.publishers = publishers;
    }

    public <T> Binding<T> get(TypeLiteral<T> type) {
        Key implicitKey = TypeArguments.implicitKey(type.getRawType());
        for (BindingPublisher p : this.publishers) {
            Injector i;
            Binding binding;
            if (!(p instanceof InjectorBindings) || null == (binding = (Binding)(i = ((InjectorBindings)p).getInjector()).getBindings().get(implicitKey))) continue;
            Logs.trace("Using implicit binding: {} from: <>", binding, i);
            return binding;
        }
        Key justInTimeKey = Key.get(type);
        for (BindingPublisher p : this.publishers) {
            if (!(p instanceof InjectorBindings)) continue;
            Injector i = ((InjectorBindings)p).getInjector();
            try {
                Binding binding = i.getBinding(justInTimeKey);
                if (null != Sources.getAnnotation(binding, Hidden.class)) continue;
                Logs.trace("Using just-in-time binding: {} from: <>", binding, i);
                return binding;
            }
            catch (RuntimeException e) {
                Logs.trace("Problem with just-in-time binding: {}", justInTimeKey, e);
            }
            catch (LinkageError e) {
                Logs.trace("Problem with just-in-time binding: {}", justInTimeKey, e);
            }
        }
        return null;
    }
}

