/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;

public final class Streams {
    private static final boolean ON_WINDOWS;

    private Streams() {
    }

    public static InputStream open(URL url) throws IOException {
        if (ON_WINDOWS) {
            URLConnection conn = url.openConnection();
            conn.setUseCaches(false);
            return conn.getInputStream();
        }
        return url.openStream();
    }

    static {
        boolean onWindows;
        try {
            onWindows = System.getProperty("os.name").toLowerCase(Locale.US).contains("windows");
        }
        catch (RuntimeException e) {
            onWindows = false;
        }
        ON_WINDOWS = onWindows;
    }
}

