/*
 * Decompiled with CFR 0.152.
 */
package org.glyptodon.guacamole.protocol;

import org.glyptodon.guacamole.GuacamoleException;
import org.glyptodon.guacamole.GuacamoleServerException;
import org.glyptodon.guacamole.io.GuacamoleWriter;
import org.glyptodon.guacamole.protocol.GuacamoleFilter;
import org.glyptodon.guacamole.protocol.GuacamoleInstruction;
import org.glyptodon.guacamole.protocol.GuacamoleParser;

public class FilteredGuacamoleWriter
implements GuacamoleWriter {
    private final GuacamoleWriter writer;
    private final GuacamoleFilter filter;
    private final GuacamoleParser parser = new GuacamoleParser();

    public FilteredGuacamoleWriter(GuacamoleWriter writer, GuacamoleFilter filter) {
        this.writer = writer;
        this.filter = filter;
    }

    @Override
    public void write(char[] chunk, int offset, int length) throws GuacamoleException {
        while (length > 0) {
            int parsed;
            while ((parsed = this.parser.append(chunk, offset, length)) != 0) {
                offset += parsed;
                length -= parsed;
            }
            if (!this.parser.hasNext()) {
                throw new GuacamoleServerException("Filtered write() contained an incomplete instruction.");
            }
            this.writeInstruction(this.parser.next());
        }
    }

    @Override
    public void write(char[] chunk) throws GuacamoleException {
        this.write(chunk, 0, chunk.length);
    }

    @Override
    public void writeInstruction(GuacamoleInstruction instruction) throws GuacamoleException {
        GuacamoleInstruction filteredInstruction = this.filter.filter(instruction);
        if (filteredInstruction != null) {
            this.writer.writeInstruction(filteredInstruction);
        }
    }
}

