(function(window,angular){"use strict";function stringify(value){if(value==null){return""}switch(typeof value){case"string":return value;case"number":return""+value;default:return toJson(value)}}function indexToLineAndColumn(text,index){var lines=text.split(/\n/g);for(var i=0;i<lines.length;i++){var line=lines[i];if(index>=line.length){index-=line.length}else{return{line:i+1,column:index+1}}}}var PARSE_CACHE_FOR_TEXT_LITERALS=Object.create(null);function parseTextLiteral(text){var cachedFn=PARSE_CACHE_FOR_TEXT_LITERALS[text];if(cachedFn!=null){return cachedFn}function parsedFn(context){return text}parsedFn["$$watchDelegate"]=function watchDelegate(scope,listener,objectEquality){var unwatch=scope["$watch"](noop,function textLiteralWatcher(){if(isFunction(listener)){listener(text,text,scope)}unwatch()},objectEquality);return unwatch};PARSE_CACHE_FOR_TEXT_LITERALS[text]=parsedFn;parsedFn["exp"]=text;parsedFn["expressions"]=[];return parsedFn}function subtractOffset(expressionFn,offset){if(offset===0){return expressionFn}function minusOffset(value){return value==null?value:value-offset}function parsedFn(context){return minusOffset(expressionFn(context))}var unwatch;parsedFn["$$watchDelegate"]=function watchDelegate(scope,listener,objectEquality){unwatch=scope["$watch"](expressionFn,function pluralExpressionWatchListener(newValue,oldValue){if(isFunction(listener)){listener(minusOffset(newValue),minusOffset(oldValue),scope)}},objectEquality);return unwatch};return parsedFn}function MessageSelectorBase(expressionFn,choices){var self=this;this.expressionFn=expressionFn;this.choices=choices;if(choices["other"]===undefined){throw $interpolateMinErr("reqother","“other” is a required option.")}this.parsedFn=function(context){return self.getResult(context)};this.parsedFn["$$watchDelegate"]=function $$watchDelegate(scope,listener,objectEquality){return self.watchDelegate(scope,listener,objectEquality)};this.parsedFn["exp"]=expressionFn["exp"];this.parsedFn["expressions"]=expressionFn["expressions"]}MessageSelectorBase.prototype.getMessageFn=function getMessageFn(value){return this.choices[this.categorizeValue(value)]};MessageSelectorBase.prototype.getResult=function getResult(context){return this.getMessageFn(this.expressionFn(context))(context)};MessageSelectorBase.prototype.watchDelegate=function watchDelegate(scope,listener,objectEquality){var watchers=new MessageSelectorWatchers(this,scope,listener,objectEquality);return function(){watchers.cancelWatch()}};function MessageSelectorWatchers(msgSelector,scope,listener,objectEquality){var self=this;this.scope=scope;this.msgSelector=msgSelector;this.listener=listener;this.objectEquality=objectEquality;this.lastMessage=undefined;this.messageFnWatcher=noop;var expressionFnListener=function(newValue,oldValue){return self.expressionFnListener(newValue,oldValue)};this.expressionFnWatcher=scope["$watch"](msgSelector.expressionFn,expressionFnListener,objectEquality)}MessageSelectorWatchers.prototype.expressionFnListener=function expressionFnListener(newValue,oldValue){var self=this;this.messageFnWatcher();var messageFnListener=function(newMessage,oldMessage){return self.messageFnListener(newMessage,oldMessage)};var messageFn=this.msgSelector.getMessageFn(newValue);this.messageFnWatcher=this.scope["$watch"](messageFn,messageFnListener,this.objectEquality)};MessageSelectorWatchers.prototype.messageFnListener=function messageFnListener(newMessage,oldMessage){if(isFunction(this.listener)){this.listener.call(null,newMessage,newMessage===oldMessage?newMessage:this.lastMessage,this.scope)}this.lastMessage=newMessage};MessageSelectorWatchers.prototype.cancelWatch=function cancelWatch(){this.expressionFnWatcher();this.messageFnWatcher()};function SelectMessage(expressionFn,choices){MessageSelectorBase.call(this,expressionFn,choices)}function SelectMessageProto(){}SelectMessageProto.prototype=MessageSelectorBase.prototype;SelectMessage.prototype=new SelectMessageProto;SelectMessage.prototype.categorizeValue=function categorizeSelectValue(value){return this.choices[value]!==undefined?value:"other"};function PluralMessage(expressionFn,choices,offset,pluralCat){MessageSelectorBase.call(this,expressionFn,choices);this.offset=offset;this.pluralCat=pluralCat}function PluralMessageProto(){}PluralMessageProto.prototype=MessageSelectorBase.prototype;PluralMessage.prototype=new PluralMessageProto;PluralMessage.prototype.categorizeValue=function categorizePluralValue(value){if(isNaN(value)){return"other"}else if(this.choices[value]!==undefined){return value}else{var category=this.pluralCat(value-this.offset);return this.choices[category]!==undefined?category:"other"}};function InterpolationParts(trustedContext,allOrNothing){this.trustedContext=trustedContext;this.allOrNothing=allOrNothing;this.textParts=[];this.expressionFns=[];this.expressionIndices=[];this.partialText="";this.concatParts=null}InterpolationParts.prototype.flushPartialText=function flushPartialText(){if(this.partialText){if(this.concatParts==null){this.textParts.push(this.partialText)}else{this.textParts.push(this.concatParts.join(""));this.concatParts=null}this.partialText=""}};InterpolationParts.prototype.addText=function addText(text){if(text.length){if(!this.partialText){this.partialText=text}else if(this.concatParts){this.concatParts.push(text)}else{this.concatParts=[this.partialText,text]}}};InterpolationParts.prototype.addExpressionFn=function addExpressionFn(expressionFn){this.flushPartialText();this.expressionIndices.push(this.textParts.length);this.expressionFns.push(expressionFn);this.textParts.push("")};InterpolationParts.prototype.getExpressionValues=function getExpressionValues(context){var expressionValues=new Array(this.expressionFns.length);for(var i=0;i<this.expressionFns.length;i++){expressionValues[i]=this.expressionFns[i](context)}return expressionValues};InterpolationParts.prototype.getResult=function getResult(expressionValues){for(var i=0;i<this.expressionIndices.length;i++){var expressionValue=expressionValues[i];if(this.allOrNothing&&expressionValue===undefined)return;this.textParts[this.expressionIndices[i]]=expressionValue}return this.textParts.join("")};InterpolationParts.prototype.toParsedFn=function toParsedFn(mustHaveExpression,originalText){var self=this;this.flushPartialText();if(mustHaveExpression&&this.expressionFns.length===0){return undefined}if(this.textParts.length===0){return parseTextLiteral("")}if(this.trustedContext&&this.textParts.length>1){$interpolateMinErr["throwNoconcat"](originalText)}if(this.expressionFns.length===0){if(this.textParts.length!==1){this.errorInParseLogic()}return parseTextLiteral(this.textParts[0])}var parsedFn=function(context){return self.getResult(self.getExpressionValues(context))};parsedFn["$$watchDelegate"]=function $$watchDelegate(scope,listener,objectEquality){return self.watchDelegate(scope,listener,objectEquality)};parsedFn["exp"]=originalText;parsedFn["expressions"]=new Array(this.expressionFns.length);for(var i=0;i<this.expressionFns.length;i++){parsedFn["expressions"][i]=this.expressionFns[i]["exp"]}return parsedFn};InterpolationParts.prototype.watchDelegate=function watchDelegate(scope,listener,objectEquality){var watcher=new InterpolationPartsWatcher(this,scope,listener,objectEquality);return function(){watcher.cancelWatch()}};function InterpolationPartsWatcher(interpolationParts,scope,listener,objectEquality){this.interpolationParts=interpolationParts;this.scope=scope;this.previousResult=undefined;this.listener=listener;var self=this;this.expressionFnsWatcher=scope["$watchGroup"](interpolationParts.expressionFns,function(newExpressionValues,oldExpressionValues){self.watchListener(newExpressionValues,oldExpressionValues)})}InterpolationPartsWatcher.prototype.watchListener=function watchListener(newExpressionValues,oldExpressionValues){var result=this.interpolationParts.getResult(newExpressionValues);if(isFunction(this.listener)){this.listener.call(null,result,newExpressionValues===oldExpressionValues?result:this.previousResult,this.scope)}this.previousResult=result};InterpolationPartsWatcher.prototype.cancelWatch=function cancelWatch(){this.expressionFnsWatcher()};function copyNestedParserState(src,dst){dst.expressionFn=src.expressionFn;dst.expressionMinusOffsetFn=src.expressionMinusOffsetFn;dst.pluralOffset=src.pluralOffset;dst.choices=src.choices;dst.choiceKey=src.choiceKey;dst.interpolationParts=src.interpolationParts;dst.ruleChoiceKeyword=src.ruleChoiceKeyword;dst.msgStartIndex=src.msgStartIndex;dst.expressionStartIndex=src.expressionStartIndex}function NestedParserState(parser){copyNestedParserState(parser,this)}function MessageFormatParser(text,startIndex,$parse,pluralCat,stringifier,mustHaveExpression,trustedContext,allOrNothing){this.text=text;this.index=startIndex||0;this.$parse=$parse;this.pluralCat=pluralCat;this.stringifier=stringifier;this.mustHaveExpression=!!mustHaveExpression;this.trustedContext=trustedContext;this.allOrNothing=!!allOrNothing;this.expressionFn=null;this.expressionMinusOffsetFn=null;this.pluralOffset=null;this.choices=null;this.choiceKey=null;this.interpolationParts=null;this.msgStartIndex=null;this.nestedStateStack=[];this.parsedFn=null;this.rule=null;this.ruleStack=null;this.ruleChoiceKeyword=null;this.interpNestLevel=null;this.expressionStartIndex=null;this.stringStartIndex=null;this.stringQuote=null;this.stringInterestsRe=null;this.angularOperatorStack=null;this.textPart=null}var EMPTY_STATE=new NestedParserState(new MessageFormatParser("",0,null,null,null,false,null,false));MessageFormatParser.prototype.pushState=function pushState(){this.nestedStateStack.push(new NestedParserState(this));copyNestedParserState(EMPTY_STATE,this)};MessageFormatParser.prototype.popState=function popState(){if(this.nestedStateStack.length===0){this.errorInParseLogic()}var previousState=this.nestedStateStack.pop();copyNestedParserState(previousState,this)};MessageFormatParser.prototype.matchRe=function matchRe(re,search){re.lastIndex=this.index;var match=re.exec(this.text);if(match!=null&&(search===true||match.index===this.index)){this.index=re.lastIndex;return match}return null};MessageFormatParser.prototype.searchRe=function searchRe(re){return this.matchRe(re,true)};MessageFormatParser.prototype.consumeRe=function consumeRe(re){return!!this.matchRe(re)};MessageFormatParser.prototype.run=function run(initialRule){this.ruleStack=[initialRule];do{this.rule=this.ruleStack.pop();while(this.rule){this.rule()}this.assertRuleOrNull(this.rule)}while(this.ruleStack.length>0)};MessageFormatParser.prototype.errorInParseLogic=function errorInParseLogic(){throw $interpolateMinErr("logicbug","The messageformat parser has encountered an internal error.  Please file a github issue against the AngularJS project and provide this message text that triggers the bug.  Text: “{0}”",this.text)};MessageFormatParser.prototype.assertRuleOrNull=function assertRuleOrNull(rule){if(rule===undefined){this.errorInParseLogic()}};var NEXT_WORD_RE=/\s*(\w+)\s*/g;MessageFormatParser.prototype.errorExpecting=function errorExpecting(){var match=this.matchRe(NEXT_WORD_RE),position;if(match==null){position=indexToLineAndColumn(this.text,this.index);throw $interpolateMinErr("reqarg","Expected one of “plural” or “select” at line {0}, column {1} of text “{2}”",position.line,position.column,this.text)}var word=match[1];if(word==="select"||word==="plural"){position=indexToLineAndColumn(this.text,this.index);throw $interpolateMinErr("reqcomma","Expected a comma after the keyword “{0}” at line {1}, column {2} of text “{3}”",word,position.line,position.column,this.text)}else{position=indexToLineAndColumn(this.text,this.index);throw $interpolateMinErr("unknarg","Unsupported keyword “{0}” at line {0}, column {1}. Only “plural” and “select” are currently supported.  Text: “{3}”",word,position.line,position.column,this.text)}};var STRING_START_RE=/['"]/g;MessageFormatParser.prototype.ruleString=function ruleString(){var match=this.matchRe(STRING_START_RE);if(match==null){var position=indexToLineAndColumn(this.text,this.index);throw $interpolateMinErr("wantstring","Expected the beginning of a string at line {0}, column {1} in text “{2}”",position.line,position.column,this.text)}this.startStringAtMatch(match)};MessageFormatParser.prototype.startStringAtMatch=function startStringAtMatch(match){this.stringStartIndex=match.index;this.stringQuote=match[0];this.stringInterestsRe=this.stringQuote==="'"?SQUOTED_STRING_INTEREST_RE:DQUOTED_STRING_INTEREST_RE;this.rule=this.ruleInsideString};var SQUOTED_STRING_INTEREST_RE=/\\(?:\\|'|u[0-9A-Fa-f]{4}|x[0-9A-Fa-f]{2}|[0-7]{3}|\r\n|\n|[\s\S])|'/g;var DQUOTED_STRING_INTEREST_RE=/\\(?:\\|"|u[0-9A-Fa-f]{4}|x[0-9A-Fa-f]{2}|[0-7]{3}|\r\n|\n|[\s\S])|"/g;MessageFormatParser.prototype.ruleInsideString=function ruleInsideString(){var match=this.searchRe(this.stringInterestsRe);if(match==null){var position=indexToLineAndColumn(this.text,this.stringStartIndex);throw $interpolateMinErr("untermstr","The string beginning at line {0}, column {1} is unterminated in text “{2}”",position.line,position.column,this.text)}if(match[0]===this.stringQuote){this.rule=null}};var PLURAL_OR_SELECT_ARG_TYPE_RE=/\s*(plural|select)\s*,\s*/g;MessageFormatParser.prototype.rulePluralOrSelect=function rulePluralOrSelect(){var match=this.searchRe(PLURAL_OR_SELECT_ARG_TYPE_RE);if(match==null){this.errorExpecting()}var argType=match[1];switch(argType){case"plural":this.rule=this.rulePluralStyle;break;case"select":this.rule=this.ruleSelectStyle;break;default:this.errorInParseLogic()}};MessageFormatParser.prototype.rulePluralStyle=function rulePluralStyle(){this.choices=Object.create(null);this.ruleChoiceKeyword=this.rulePluralValueOrKeyword;this.rule=this.rulePluralOffset};MessageFormatParser.prototype.ruleSelectStyle=function ruleSelectStyle(){this.choices=Object.create(null);this.ruleChoiceKeyword=this.ruleSelectKeyword;this.rule=this.ruleSelectKeyword};var NUMBER_RE=/[0]|(?:[1-9][0-9]*)/g;var PLURAL_OFFSET_RE=new RegExp("\\s*offset\\s*:\\s*("+NUMBER_RE.source+")","g");MessageFormatParser.prototype.rulePluralOffset=function rulePluralOffset(){var match=this.matchRe(PLURAL_OFFSET_RE);this.pluralOffset=match==null?0:parseInt(match[1],10);this.expressionMinusOffsetFn=subtractOffset(this.expressionFn,this.pluralOffset);this.rule=this.rulePluralValueOrKeyword};MessageFormatParser.prototype.assertChoiceKeyIsNew=function assertChoiceKeyIsNew(choiceKey,index){if(this.choices[choiceKey]!==undefined){var position=indexToLineAndColumn(this.text,index);throw $interpolateMinErr("dupvalue","The choice “{0}” is specified more than once. Duplicate key is at line {1}, column {2} in text “{3}”",choiceKey,position.line,position.column,this.text)}};var SELECT_KEYWORD=/\s*(\w+)/g;MessageFormatParser.prototype.ruleSelectKeyword=function ruleSelectKeyword(){var match=this.matchRe(SELECT_KEYWORD);if(match==null){this.parsedFn=new SelectMessage(this.expressionFn,this.choices).parsedFn;this.rule=null;return}this.choiceKey=match[1];this.assertChoiceKeyIsNew(this.choiceKey,match.index);this.rule=this.ruleMessageText};var EXPLICIT_VALUE_OR_KEYWORD_RE=new RegExp("\\s*(?:(?:=("+NUMBER_RE.source+"))|(\\w+))","g");MessageFormatParser.prototype.rulePluralValueOrKeyword=function rulePluralValueOrKeyword(){var match=this.matchRe(EXPLICIT_VALUE_OR_KEYWORD_RE);if(match==null){this.parsedFn=new PluralMessage(this.expressionFn,this.choices,this.pluralOffset,this.pluralCat).parsedFn;this.rule=null;return}if(match[1]!=null){this.choiceKey=parseInt(match[1],10)}else{this.choiceKey=match[2]}this.assertChoiceKeyIsNew(this.choiceKey,match.index);this.rule=this.ruleMessageText};var BRACE_OPEN_RE=/\s*\{/g;var BRACE_CLOSE_RE=/}/g;MessageFormatParser.prototype.ruleMessageText=function ruleMessageText(){if(!this.consumeRe(BRACE_OPEN_RE)){var position=indexToLineAndColumn(this.text,this.index);throw $interpolateMinErr("reqopenbrace","The plural choice “{0}” must be followed by a message in braces at line {1}, column {2} in text “{3}”",this.choiceKey,position.line,position.column,this.text)}this.msgStartIndex=this.index;this.interpolationParts=new InterpolationParts(this.trustedContext,this.allOrNothing);this.rule=this.ruleInInterpolationOrMessageText};var INTERP_OR_END_MESSAGE_RE=/\\.|{{|}/g;var INTERP_OR_PLURALVALUE_OR_END_MESSAGE_RE=/\\.|{{|#|}/g;var ESCAPE_OR_MUSTACHE_BEGIN_RE=/\\.|{{/g;MessageFormatParser.prototype.advanceInInterpolationOrMessageText=function advanceInInterpolationOrMessageText(){var currentIndex=this.index,match;if(this.ruleChoiceKeyword==null){match=this.searchRe(ESCAPE_OR_MUSTACHE_BEGIN_RE);if(match==null){this.textPart=this.text.substring(currentIndex);this.index=this.text.length;return null}}else{match=this.searchRe(this.ruleChoiceKeyword===this.rulePluralValueOrKeyword?INTERP_OR_PLURALVALUE_OR_END_MESSAGE_RE:INTERP_OR_END_MESSAGE_RE);if(match==null){var position=indexToLineAndColumn(this.text,this.msgStartIndex);throw $interpolateMinErr("reqendbrace","The plural/select choice “{0}” message starting at line {1}, column {2} does not have an ending closing brace. Text “{3}”",this.choiceKey,position.line,position.column,this.text)}}var token=match[0];this.textPart=this.text.substring(currentIndex,match.index);return token};MessageFormatParser.prototype.ruleInInterpolationOrMessageText=function ruleInInterpolationOrMessageText(){var currentIndex=this.index;var token=this.advanceInInterpolationOrMessageText();if(token==null){this.index=this.text.length;this.interpolationParts.addText(this.text.substring(currentIndex));this.rule=null;return}if(token[0]==="\\"){this.interpolationParts.addText(this.textPart+token[1]);return}this.interpolationParts.addText(this.textPart);if(token==="{{"){this.pushState();this.ruleStack.push(this.ruleEndMustacheInInterpolationOrMessage);this.rule=this.ruleEnteredMustache}else if(token==="}"){this.choices[this.choiceKey]=this.interpolationParts.toParsedFn(false,this.text);this.rule=this.ruleChoiceKeyword}else if(token==="#"){this.interpolationParts.addExpressionFn(this.expressionMinusOffsetFn)}else{this.errorInParseLogic()}};MessageFormatParser.prototype.ruleInterpolate=function ruleInterpolate(){this.interpolationParts=new InterpolationParts(this.trustedContext,this.allOrNothing);this.rule=this.ruleInInterpolation};MessageFormatParser.prototype.ruleInInterpolation=function ruleInInterpolation(){var currentIndex=this.index;var match=this.searchRe(ESCAPE_OR_MUSTACHE_BEGIN_RE);if(match==null){this.index=this.text.length;this.interpolationParts.addText(this.text.substring(currentIndex));this.parsedFn=this.interpolationParts.toParsedFn(this.mustHaveExpression,this.text);this.rule=null;return}var token=match[0];if(token[0]==="\\"){this.interpolationParts.addText(this.text.substring(currentIndex,match.index)+token[1]);return}this.interpolationParts.addText(this.text.substring(currentIndex,match.index));this.pushState();this.ruleStack.push(this.ruleInterpolationEndMustache);this.rule=this.ruleEnteredMustache};MessageFormatParser.prototype.ruleInterpolationEndMustache=function ruleInterpolationEndMustache(){var expressionFn=this.parsedFn;this.popState();this.interpolationParts.addExpressionFn(expressionFn);this.rule=this.ruleInInterpolation};MessageFormatParser.prototype.ruleEnteredMustache=function ruleEnteredMustache(){this.parsedFn=null;this.ruleStack.push(this.ruleEndMustache);this.rule=this.ruleAngularExpression};MessageFormatParser.prototype.ruleEndMustacheInInterpolationOrMessage=function ruleEndMustacheInInterpolationOrMessage(){var expressionFn=this.parsedFn;this.popState();this.interpolationParts.addExpressionFn(expressionFn);this.rule=this.ruleInInterpolationOrMessageText};var INTERP_END_RE=/\s*}}/g;MessageFormatParser.prototype.ruleEndMustache=function ruleEndMustache(){var match=this.matchRe(INTERP_END_RE);if(match==null){var position=indexToLineAndColumn(this.text,this.index);throw $interpolateMinErr("reqendinterp","Expecting end of interpolation symbol, “{0}”, at line {1}, column {2} in text “{3}”","}}",position.line,position.column,this.text)}if(this.parsedFn==null){this.parsedFn=this.$parse(this.expressionFn,this.stringifier);this.parsedFn["exp"]=this.expressionFn["exp"];this.parsedFn["expressions"]=this.expressionFn["expressions"]}this.rule=null};MessageFormatParser.prototype.ruleAngularExpression=function ruleAngularExpression(){this.angularOperatorStack=[];this.expressionStartIndex=this.index;this.rule=this.ruleInAngularExpression};function getEndOperator(opBegin){switch(opBegin){case"{":return"}";case"[":return"]";case"(":return")";default:return null}}function getBeginOperator(opEnd){switch(opEnd){case"}":return"{";case"]":return"[";case")":return"(";default:return null}}var INTERESTING_OPERATORS_RE=/[[\]{}()'",]/g;MessageFormatParser.prototype.ruleInAngularExpression=function ruleInAngularExpression(){var match=this.searchRe(INTERESTING_OPERATORS_RE);var position;if(match==null){if(this.angularOperatorStack.length===0){this.index=this.text.length;this.expressionFn=this.$parse(this.text.substring(this.expressionStartIndex,this.index));this.expressionFn["exp"]=this.text.substring(this.expressionStartIndex,this.index);this.expressionFn["expressions"]=this.expressionFn["expressions"];this.rule=null;return}var innermostOperator=this.angularOperatorStack[0];throw $interpolateMinErr("badexpr","Unexpected end of Angular expression.  Expecting operator “{0}” at the end of the text “{1}”",this.getEndOperator(innermostOperator),this.text)}var operator=match[0];if(operator==="'"||operator==='"'){this.ruleStack.push(this.ruleInAngularExpression);this.startStringAtMatch(match);return}if(operator===","){if(this.trustedContext){position=indexToLineAndColumn(this.text,this.index);throw $interpolateMinErr("unsafe","Use of select/plural MessageFormat syntax is currently disallowed in a secure context ({0}).  At line {1}, column {2} of text “{3}”",this.trustedContext,position.line,position.column,this.text)}if(this.angularOperatorStack.length===0){this.expressionFn=this.$parse(this.text.substring(this.expressionStartIndex,match.index));this.expressionFn["exp"]=this.text.substring(this.expressionStartIndex,match.index);this.expressionFn["expressions"]=this.expressionFn["expressions"];this.rule=null;this.rule=this.rulePluralOrSelect}return}if(getEndOperator(operator)!=null){this.angularOperatorStack.unshift(operator);return}var beginOperator=getBeginOperator(operator);if(beginOperator==null){this.errorInParseLogic()}if(this.angularOperatorStack.length>0){if(beginOperator===this.angularOperatorStack[0]){this.angularOperatorStack.shift();return}position=indexToLineAndColumn(this.text,this.index);throw $interpolateMinErr("badexpr","Unexpected operator “{0}” at line {1}, column {2} in text. Was expecting “{3}”. Text: “{4}”",operator,position.line,position.column,getEndOperator(this.angularOperatorStack[0]),this.text)}this.index=match.index;this.expressionFn=this.$parse(this.text.substring(this.expressionStartIndex,this.index));this.expressionFn["exp"]=this.text.substring(this.expressionStartIndex,this.index);this.expressionFn["expressions"]=this.expressionFn["expressions"];this.rule=null};var $$MessageFormatFactory=["$parse","$locale","$sce","$exceptionHandler",function $$messageFormat($parse,$locale,$sce,$exceptionHandler){function getStringifier(trustedContext,allOrNothing,text){return function stringifier(value){try{value=trustedContext?$sce["getTrusted"](trustedContext,value):$sce["valueOf"](value);return allOrNothing&&value===undefined?value:stringify(value)}catch(err){$exceptionHandler($interpolateMinErr["interr"](text,err))}}}function interpolate(text,mustHaveExpression,trustedContext,allOrNothing){var stringifier=getStringifier(trustedContext,allOrNothing,text);var parser=new MessageFormatParser(text,0,$parse,$locale["pluralCat"],stringifier,mustHaveExpression,trustedContext,allOrNothing);parser.run(parser.ruleInterpolate);return parser.parsedFn}return{interpolate:interpolate}}];var $$interpolateDecorator=["$$messageFormat","$delegate",function $$interpolateDecorator($$messageFormat,$interpolate){if($interpolate["startSymbol"]()!=="{{"||$interpolate["endSymbol"]()!=="}}"){throw $interpolateMinErr("nochgmustache","angular-message-format.js currently does not allow you to use custom start and end symbols for interpolation.")}var interpolate=$$messageFormat["interpolate"];interpolate["startSymbol"]=$interpolate["startSymbol"];interpolate["endSymbol"]=$interpolate["endSymbol"];return interpolate}];var $interpolateMinErr;var isFunction;var noop;var toJson;var module=window["angular"]["module"]("ngMessageFormat",["ng"]);module["factory"]("$$messageFormat",$$MessageFormatFactory);module["config"](["$provide",function($provide){$interpolateMinErr=window["angular"]["$interpolateMinErr"];isFunction=window["angular"]["isFunction"];noop=window["angular"]["noop"];toJson=window["angular"]["toJson"];$provide["decorator"]("$interpolate",$$interpolateDecorator)}])})(window,window.angular);
